package com.ejianc.business.procurement.perform.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.consts.BusinessTypeEnum;
import com.ejianc.business.procurement.perform.bean.ExpertExtractionEntity;
import com.ejianc.business.procurement.perform.bean.ExpertExtractionMemberEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectEntity;
import com.ejianc.business.procurement.perform.consts.BusinessStateEnum;
import com.ejianc.business.procurement.perform.consts.NobidMethodEnum;
import com.ejianc.business.procurement.perform.service.IExpertExtractionMemberService;
import com.ejianc.business.procurement.perform.service.IExpertExtractionService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectService;
import com.ejianc.business.procurement.perform.vo.ExpertExtractionMemberVO;
import com.ejianc.business.procurement.perform.vo.ExpertExtractionVO;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 专家抽取记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("expertExtraction")
public class ExpertExtractionController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IExpertExtractionService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPurchaseProjectService purchaseProjectService;


    @Autowired
    private IExpertExtractionMemberService memberService;

    private static Map<String, String> codeRuleMap = new HashMap<>();

    static {
        codeRuleMap.put(BusinessTypeEnum.HUO_WU.getCode(), "EXPERT_EXTRACTION_CODE");
        codeRuleMap.put(BusinessTypeEnum.GONG_CHENG.getCode(), "EXPERT_EXTRACTION_GC_CODE");
        codeRuleMap.put(BusinessTypeEnum.FU_WU.getCode(), "EXPERT_EXTRACTION_FW_CODE");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpertExtractionVO> saveOrUpdate(@RequestBody ExpertExtractionVO saveOrUpdateVO) {
        LambdaQueryWrapper<ExpertExtractionEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ExpertExtractionEntity::getPurchaseProjectId, saveOrUpdateVO.getPurchaseProjectId());
        wrapper.ne(saveOrUpdateVO.getId() != null, ExpertExtractionEntity::getId, saveOrUpdateVO.getId());
        if (service.count(wrapper) > 0) {
            return CommonResponse.error("该采购项目已存在一条专家抽取记录！");
        }
        ExpertExtractionEntity entity = BeanMapper.map(saveOrUpdateVO, ExpertExtractionEntity.class);
        if (StringUtils.isBlank(saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(codeRuleMap.get(saveOrUpdateVO.getBusinessType()), InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        boolean b = service.saveOrUpdate(entity, false);
        if (b && entity.getPurchaseProjectId() != null) {
            UserContext userContextCache = sessionManager.getUserContext();
            long count = entity.getSuperviseList().stream().filter(t -> t.getConfirmFlag() != null).count();
            LambdaUpdateWrapper<PurchaseProjectEntity> updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(PurchaseProjectEntity::getId, entity.getPurchaseProjectId());
            updateWrapper.set(PurchaseProjectEntity::getExpertFlag, 1);
            updateWrapper.set(count > 0, PurchaseProjectEntity::getSupervisorId, userContextCache.getEmployeeId());
            updateWrapper.set(count > 0, PurchaseProjectEntity::getSupervisorName, userContextCache.getEmployeeName());
            purchaseProjectService.update(updateWrapper);
        }
        ExpertExtractionVO vo = BeanMapper.map(entity, ExpertExtractionVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertExtractionVO> queryDetail(Long id) {
        ExpertExtractionEntity entity = service.selectById(id);
        ExpertExtractionVO vo = BeanMapper.map(entity, ExpertExtractionVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertExtractionVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ExpertExtractionVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(ExpertExtractionVO::getId).collect(Collectors.toList());
        List<ExpertExtractionEntity> extractionEntities = (List<ExpertExtractionEntity>) service.listByIds(ids);
        List<Long> purchaseProjectIs = new ArrayList<>();
        for (ExpertExtractionEntity extractionEntity : extractionEntities) {
            Long purchaseProjectId = extractionEntity.getPurchaseProjectId();
            if (purchaseProjectId != null) {
                purchaseProjectIs.add(purchaseProjectId);
            }
        }
        if (CollectionUtils.isNotEmpty(purchaseProjectIs)) {
            LambdaUpdateWrapper<PurchaseProjectEntity> updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.in(PurchaseProjectEntity::getId, purchaseProjectIs);
            updateWrapper.set(PurchaseProjectEntity::getExpertFlag, 0);
            purchaseProjectService.update(updateWrapper);
        }
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpertExtractionVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "purchaseProjectName", "orgName", "executePlanCode"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ExpertExtractionEntity> page = service.queryPage(param, false);
        IPage<ExpertExtractionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertExtractionVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @description: queryExist
     *
     * @return {@link CommonResponse< String>}
     * @author songlx
     * @date: 2025/12/10
     */
    @RequestMapping(value = "/queryExist", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> queryExist(@RequestBody ExpertExtractionVO saveOrUpdateVO) {
        LambdaQueryWrapper<ExpertExtractionEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ExpertExtractionEntity::getPurchaseProjectId, saveOrUpdateVO.getPurchaseProjectId());
        wrapper.ne(saveOrUpdateVO.getId() != null, ExpertExtractionEntity::getId, saveOrUpdateVO.getId());
        if (service.count(wrapper) > 0) {
            return CommonResponse.error("该采购项目已存在一条专家抽取记录！");
        }
        return CommonResponse.success();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "purchaseProjectName", "orgName", "executePlanCode"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExpertExtractionEntity> list = service.queryList(param);
        List<ExpertExtractionVO> voList = BeanMapper.mapList(list, ExpertExtractionVO.class);
        for (ExpertExtractionVO vo : voList) {
            Integer permissionType = vo.getPermissionType();
            if (permissionType != null) {
                if (permissionType.intValue() == 1) {
                    vo.setPermissionTypeName("一级集采");
                } else if (permissionType.intValue() == 2) {
                    vo.setPermissionTypeName("二级集采");
                } else if (permissionType.intValue() == 3) {
                    vo.setPermissionTypeName("所属单位");
                } else if (permissionType.intValue() == 4) {
                    vo.setPermissionTypeName("项目经理部");
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().exportWithTrans("ExpertExtraction-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refExpertExtractionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExpertExtractionVO>> refExpertExtractionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ExpertExtractionEntity> page = service.queryPage(param, false);
        IPage<ExpertExtractionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertExtractionVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refExpertExtractionMemberData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExpertExtractionMemberVO>> refExpertExtractionMemberData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                         String condition,
                                                                                         String searchObject,
                                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long pid = 1L;
        ExpertExtractionEntity expertExtractionEntity = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("purchaseProjectId")) {
                Long purchaseProjectId = Long.valueOf(_con.get("purchaseProjectId").toString());
                LambdaQueryWrapper<ExpertExtractionEntity> wrapper = Wrappers.lambdaQuery();
                wrapper.eq(ExpertExtractionEntity::getPurchaseProjectId, purchaseProjectId);
                wrapper.in(ExpertExtractionEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                List<ExpertExtractionEntity> list = service.list(wrapper);
                if (CollectionUtils.isNotEmpty(list)) {
                    expertExtractionEntity = list.get(0);
                    pid = expertExtractionEntity.getId();
                }
            }
            if (_con.containsKey("inStore")) {
                param.getParams().put("inStore", new Parameter(QueryParam.EQ, _con.get("inStore")));
            }
        }
        param.getParams().put("pid", new Parameter(QueryParam.EQ, pid));

        IPage<ExpertExtractionMemberEntity> page = memberService.queryPage(param, false);
        IPage<ExpertExtractionMemberVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ExpertExtractionMemberVO> expertExtractionMemberVOS = BeanMapper.mapList(page.getRecords(), ExpertExtractionMemberVO.class);
        if (expertExtractionEntity != null) {
            for (ExpertExtractionMemberVO memberVO : expertExtractionMemberVOS) {
                memberVO.setStartDate(expertExtractionEntity.getStartDate());
            }
        }
        pageData.setRecords(expertExtractionMemberVOS);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
