package com.ejianc.business.procurement.perform.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 成交候选人确认-供应商
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_candidate_supplier")
public class CandidateSupplierEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value="source_type")
    private String sourceType; // 来源类型
    @TableField(value="candidate_flag")
    private Integer candidateFlag; // 是否为成交候选人:1-是，2-否
    @TableField(value="rank_num")
    private Integer rankNum; // 排名
    @TableField(value="sell_mny")
    private BigDecimal sellMny; // 无税总价
    @TableField(value="sell_tax_mny")
    private BigDecimal sellTaxMny; // 含税总价
    @TableField(value="total_score")
    private BigDecimal totalScore; // 总分
    @TableField(value="technology_score")
    private BigDecimal technologyScore; // 技术分
    @TableField(value="business_score")
    private BigDecimal businessScore; // 商务分
    @TableField(value="price_score")
    private BigDecimal priceScore; // 价格分
    @TableField(value="in_store")
    private Integer inStore; // 是否在库
    @TableField(value="supplier_select_flag")
    private Integer supplierSelectFlag; // 是否入围:1-是，2-否
    @TableField(value="supplier_flag")
    private Integer supplierFlag; // 是否符合:1-符合，2-不符合
    @TableField(value="lot")
    private Integer lot; // 标段
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 统一社会信用代码
    @TableField(value="supplier_name")
    private String supplierName; // 供应商name
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="pid")
    private Long pid; // 主表主键
    
    
    

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public Integer getCandidateFlag() {
        return candidateFlag;
    }

    public void setCandidateFlag(Integer candidateFlag) {
        this.candidateFlag = candidateFlag;
    }
    public Integer getRankNum() {
        return rankNum;
    }

    public void setRankNum(Integer rankNum) {
        this.rankNum = rankNum;
    }
    public BigDecimal getSellMny() {
        return sellMny;
    }

    public void setSellMny(BigDecimal sellMny) {
        this.sellMny = sellMny;
    }
    public BigDecimal getSellTaxMny() {
        return sellTaxMny;
    }

    public void setSellTaxMny(BigDecimal sellTaxMny) {
        this.sellTaxMny = sellTaxMny;
    }
    public BigDecimal getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(BigDecimal totalScore) {
        this.totalScore = totalScore;
    }
    public BigDecimal getTechnologyScore() {
        return technologyScore;
    }

    public void setTechnologyScore(BigDecimal technologyScore) {
        this.technologyScore = technologyScore;
    }
    public BigDecimal getBusinessScore() {
        return businessScore;
    }

    public void setBusinessScore(BigDecimal businessScore) {
        this.businessScore = businessScore;
    }
    public BigDecimal getPriceScore() {
        return priceScore;
    }

    public void setPriceScore(BigDecimal priceScore) {
        this.priceScore = priceScore;
    }
    public Integer getInStore() {
        return inStore;
    }

    public void setInStore(Integer inStore) {
        this.inStore = inStore;
    }
    public Integer getSupplierSelectFlag() {
        return supplierSelectFlag;
    }

    public void setSupplierSelectFlag(Integer supplierSelectFlag) {
        this.supplierSelectFlag = supplierSelectFlag;
    }
    public Integer getSupplierFlag() {
        return supplierFlag;
    }

    public void setSupplierFlag(Integer supplierFlag) {
        this.supplierFlag = supplierFlag;
    }
    public Integer getLot() {
        return lot;
    }

    public void setLot(Integer lot) {
        this.lot = lot;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
