/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.perform.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.perform.bean.ApproveConfirmEntity;
import com.ejianc.business.procurement.perform.bean.ApproveEntity;
import com.ejianc.business.procurement.perform.bean.ApproveSupplierAllEntity;
import com.ejianc.business.procurement.perform.bean.ApproveSupplierEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectConfirmEntity;
import com.ejianc.business.procurement.perform.service.IApproveConfirmService;
import com.ejianc.business.procurement.perform.service.IApproveService;
import com.ejianc.business.procurement.perform.service.IApproveSupplierAllService;
import com.ejianc.business.procurement.perform.service.IApproveSupplierService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectConfirmService;
import com.ejianc.business.procurement.perform.vo.ApproveConfirmVO;
import com.ejianc.business.procurement.perform.vo.ApproveSupplierVO;
import com.ejianc.business.procurement.perform.vo.ApproveVO;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectConfirmVO;
import com.ejianc.business.procurement.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"approve"})
public class ApproveController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IApproveService service;
    @Autowired
    private IApproveSupplierService approveSupplierService;
    @Autowired
    private IApproveConfirmService approveConfirmService;
    @Autowired
    private IApproveSupplierAllService approveSupplierAllService;
    private static final String HW_BILL_CODE = "APPROVE_HW_CODE";
    private static final String GC_BILL_CODE = "APPROVE_GC_CODE";
    private static final String FW_BILL_CODE = "APPROVE_FW_CODE";
    @Autowired
    private IPurchaseProjectConfirmService purchaseProjectConfirmService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApproveVO> saveOrUpdate(@RequestBody ApproveVO saveOrUpdateVO) {
        ApproveEntity entity = (ApproveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ApproveEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String billcode = "";
            if ("1".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = GC_BILL_CODE;
            } else if ("2".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = HW_BILL_CODE;
            } else if ("3".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)billcode, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getId() != null && entity.getId() != 0L) {
            LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
            lambdaSupplier.eq(ApproveSupplierEntity::getPid, (Object)entity.getId());
            this.approveSupplierService.remove((Wrapper)lambdaSupplier);
            LambdaQueryWrapper lambdaSupplierAll = Wrappers.lambdaQuery();
            lambdaSupplierAll.eq(ApproveSupplierAllEntity::getPid, (Object)entity.getId());
            this.approveSupplierAllService.remove((Wrapper)lambdaSupplierAll);
        }
        List detailListVo = saveOrUpdateVO.getApproveConfirmList();
        HashMap sipplierMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)detailListVo)) {
            detailListVo.forEach(e -> {
                if (!"del".equals(e.getRowState())) {
                    sipplierMap.put(e.getTid(), e.getSupplierList());
                }
            });
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<ApproveConfirmEntity> detailList = entity.getApproveConfirmList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ApproveConfirmEntity cdEntity : detailList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ApproveConfirmEntity cdEntity : detailList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.approveConfirmService.saveOrUpdateBatch(detailList);
        }
        ApproveVO vo = (ApproveVO)BeanMapper.map((Object)((Object)entity), ApproveVO.class);
        return this.queryDetail(entity.getId());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApproveVO> queryDetail(Long id) {
        ApproveEntity entity = (ApproveEntity)((Object)this.service.selectById(id));
        ApproveVO vo = (ApproveVO)BeanMapper.map((Object)((Object)entity), ApproveVO.class);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ApproveSupplierEntity::getPid, (Object)entity.getId());
        List supplierEntityList = this.approveSupplierService.list((Wrapper)lambda);
        Map<Long, List<ApproveSupplierEntity>> map = supplierEntityList.stream().collect(Collectors.groupingBy(ApproveSupplierEntity::getConfirmId));
        List detailEntityList = vo.getApproveConfirmList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (ApproveConfirmVO confirmVO : detailEntityList) {
                confirmVO.setSupplierList(BeanMapper.mapList((Iterable)map.get(confirmVO.getId()), ApproveSupplierVO.class));
            }
            vo.setApproveConfirmList(TreeNodeBUtil.buildTree((List)detailEntityList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryListByPurchaseProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PurchaseProjectConfirmVO>> queryListByPurchaseProjectId(Long purchaseProjectId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PurchaseProjectConfirmEntity::getPid, (Object)purchaseProjectId);
        List purchaseProjectConfirmEntities = this.purchaseProjectConfirmService.list((Wrapper)lambda);
        List purchaseProjectConfirmVOS = BeanMapper.mapList((Iterable)purchaseProjectConfirmEntities, PurchaseProjectConfirmVO.class);
        List purchaseProjectConfirmVOS1 = TreeNodeBUtil.buildTree((List)purchaseProjectConfirmVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)purchaseProjectConfirmVOS1);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApproveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ApproveVO vo : vos) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(ApproveSupplierEntity::getPid, (Object)vo.getId());
                this.approveSupplierService.remove((Wrapper)lambda);
                LambdaQueryWrapper lambdaAll = Wrappers.lambdaQuery();
                lambdaAll.eq(ApproveSupplierAllEntity::getPid, (Object)vo.getId());
                this.approveSupplierAllService.remove((Wrapper)lambdaAll);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApproveVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApproveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Approve-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refApproveData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ApproveVO>> refApproveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApproveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

