/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.perform.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.perform.bean.CandidateEntity;
import com.ejianc.business.procurement.perform.bean.FileSuperviseEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectEntity;
import com.ejianc.business.procurement.perform.service.ICandidateService;
import com.ejianc.business.procurement.perform.service.IFileSuperviseService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectService;
import com.ejianc.business.procurement.perform.vo.CandidateSuperviseVO;
import com.ejianc.business.procurement.perform.vo.CandidateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"candidate"})
public class CandidateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String HW_BILL_CODE = "HW-CANDIDATE-CODE";
    private static final String GC_BILL_CODE = "GC-CANDIDATE-CODE";
    private static final String FW_BILL_CODE = "FW-CANDIDATE-CODE";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICandidateService service;
    @Autowired
    private IPurchaseProjectService purchaseProjectService;
    @Autowired
    private IFileSuperviseService fileSuperviseService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CandidateVO> saveOrUpdate(@RequestBody CandidateVO saveOrUpdateVO) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(CandidateEntity::getPurchaseProjectId, (Object)saveOrUpdateVO.getPurchaseProjectId());
        wrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        if (this.service.count((Wrapper)wrapper) > 0) {
            return CommonResponse.error((String)"\u8be5\u91c7\u8d2d\u9879\u76ee\u5df2\u5b58\u5728\u4e00\u6761\u6210\u4ea4\u5019\u9009\u4eba\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        saveOrUpdateVO.sumDetailList();
        CandidateEntity entity = (CandidateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CandidateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            this.logger.info("\u7c7b\u578b---" + saveOrUpdateVO.getBusinessType());
            String billcode = "";
            if ("1".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = GC_BILL_CODE;
            } else if ("2".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = HW_BILL_CODE;
            } else if ("3".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)billcode, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getPurchaseProjectId() != null) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            long count = entity.getCandidateSuperviseList().stream().filter(t -> t.getConfirmFlag() != null).count();
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getPurchaseProjectId());
            updateWrapper.set(count > 0L, PurchaseProjectEntity::getSupervisorId, (Object)userContextCache.getEmployeeId());
            updateWrapper.set(count > 0L, PurchaseProjectEntity::getSupervisorName, (Object)userContextCache.getEmployeeName());
            this.purchaseProjectService.update((Wrapper)updateWrapper);
        }
        return this.queryDetail(entity.getId());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CandidateVO> queryDetail(Long id) {
        CandidateEntity entity = (CandidateEntity)((Object)this.service.selectById(id));
        CandidateVO vo = (CandidateVO)BeanMapper.map((Object)((Object)entity), CandidateVO.class);
        vo.splitDetailList();
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CandidateVO> queryDetailByProjectId(Long purchaseProjectId, Long id) {
        LambdaQueryWrapper candidatewrapper = Wrappers.lambdaQuery();
        candidatewrapper.eq(CandidateEntity::getPurchaseProjectId, (Object)purchaseProjectId);
        candidatewrapper.ne(id != null, BaseEntity::getId, (Object)id);
        if (this.service.count((Wrapper)candidatewrapper) > 0) {
            return CommonResponse.error((String)"\u8be5\u91c7\u8d2d\u9879\u76ee\u5df2\u5b58\u5728\u4e00\u6761\u6210\u4ea4\u5019\u9009\u4eba\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        CandidateVO vo = new CandidateVO();
        ArrayList candidateSuperviseList = new ArrayList();
        PurchaseProjectEntity purchaseProjectEntity = (PurchaseProjectEntity)((Object)this.purchaseProjectService.selectById(purchaseProjectId));
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(FileSuperviseEntity::getEnabled, (Object)true);
        wrapper.eq(FileSuperviseEntity::getKeyLink, (Object)"\u6210\u4ea4\u5019\u9009\u4eba\u786e\u8ba4");
        List fileSuperviseEntityList = this.fileSuperviseService.list((Wrapper)wrapper);
        fileSuperviseEntityList.forEach(e -> {
            CandidateSuperviseVO candidateSuperviseVO = new CandidateSuperviseVO();
            candidateSuperviseVO.setContentId(e.getId());
            candidateSuperviseVO.setContent(e.getContent());
            candidateSuperviseList.add(candidateSuperviseVO);
        });
        vo.setCandidateSuperviseList(candidateSuperviseList);
        if ("2".equals(purchaseProjectEntity.getPerformWay())) {
            // empty if block
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CandidateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CandidateVO vo : vos) {
                CandidateEntity entity = (CandidateEntity)((Object)this.service.selectById(vo.getId()));
                if (entity.getPurchaseProjectId() == null) continue;
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.eq(BaseEntity::getId, (Object)entity.getPurchaseProjectId());
                updateWrapper.set(PurchaseProjectEntity::getSupervisorId, null);
                updateWrapper.set(PurchaseProjectEntity::getSupervisorName, null);
                this.purchaseProjectService.update((Wrapper)updateWrapper);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CandidateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name", "orgName", "executePlanCode"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CandidateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name", "orgName", "executePlanCode"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, CandidateVO.class);
        for (CandidateVO vo : voList) {
            String businessType;
            Integer permissionType = vo.getPermissionType();
            if (permissionType != null) {
                if (permissionType == 1) {
                    vo.setPermissionTypeName("\u4e00\u7ea7\u96c6\u91c7");
                } else if (permissionType == 2) {
                    vo.setPermissionTypeName("\u4e8c\u7ea7\u96c6\u91c7");
                } else if (permissionType == 3) {
                    vo.setPermissionTypeName("\u6240\u5c5e\u5355\u4f4d");
                } else if (permissionType == 4) {
                    vo.setPermissionTypeName("\u9879\u76ee\u7ecf\u7406\u90e8");
                }
            }
            if ("1".equals(businessType = vo.getBusinessType())) {
                vo.setBusinessTypeName("\u5de5\u7a0b");
                continue;
            }
            if ("2".equals(businessType)) {
                vo.setBusinessTypeName("\u8d27\u7269");
                continue;
            }
            vo.setBusinessTypeName("\u670d\u52a1");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Candidate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCandidateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CandidateVO>> refCandidateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CandidateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

