package com.ejianc.business.procurement.perform.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.perform.bean.*;
import com.ejianc.business.procurement.perform.service.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.elasticsearch.search.suggest.term.TermSuggestion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("approve") 
public class ApproveBpmServiceImpl implements ICommonBusinessService {


	@Autowired
	private IScoreService scoreService;
	@Autowired
	private IScoreAnswerService scoreAnswerService;
	@Autowired
	private ICollectService collectService;
	@Autowired
	private ICollectSupplierService collectSupplierService;
	@Autowired
	private IApproveService approveService;
	@Autowired
	private IApproveSupplierAllService approveSupplierAllService;
	@Autowired
	private IPurchaseProjectMemberService purchaseProjectMemberService;

	@Autowired
	private IPurchaseProjectAnswerService purchaseProjectAnswerService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//生成评分数据和汇总的数据
		ApproveEntity approveEntity = approveService.selectById(billId);
		Integer lotNum = approveEntity.getLotNum();

		//查询所有供应商
		LambdaQueryWrapper<ApproveSupplierAllEntity> supplierAllEntityLambdaQueryWrapper = Wrappers.<ApproveSupplierAllEntity>lambdaQuery();
		supplierAllEntityLambdaQueryWrapper.eq(ApproveSupplierAllEntity::getPid, billId);
		List<ApproveSupplierAllEntity> approveSupplierAllEntities = approveSupplierAllService.list(supplierAllEntityLambdaQueryWrapper);

		//人员
		LambdaQueryWrapper<PurchaseProjectMemberEntity> memberEntityLambdaQueryWrapper = Wrappers.<PurchaseProjectMemberEntity>lambdaQuery();
		memberEntityLambdaQueryWrapper.eq(PurchaseProjectMemberEntity::getPid, approveEntity.getPurchaseProjectId());
		List<PurchaseProjectMemberEntity> purchaseProjectMemberEntities = purchaseProjectMemberService.list(memberEntityLambdaQueryWrapper);

		//评审清单
		LambdaQueryWrapper<PurchaseProjectAnswerEntity> answerEntityLambdaQueryWrapper = Wrappers.<PurchaseProjectAnswerEntity>lambdaQuery();
		answerEntityLambdaQueryWrapper.eq(PurchaseProjectAnswerEntity::getPid, approveEntity.getPurchaseProjectId());
		List<PurchaseProjectAnswerEntity> purchaseProjectAnswerEntities = purchaseProjectAnswerService.list(answerEntityLambdaQueryWrapper);

		List<ScoreEntity> scoreList = new ArrayList<>();
		List<ScoreAnswerEntity> scoreAnswerList = new ArrayList<>();
		for (PurchaseProjectMemberEntity purchaseProjectMemberEntity : purchaseProjectMemberEntities){
			ScoreEntity scoreEntity = BeanMapper.map(approveEntity, ScoreEntity.class);
			scoreEntity.setMemo(null);
			scoreEntity.setMemberId(purchaseProjectMemberEntity.getMemberId());
			scoreEntity.setMemberName(purchaseProjectMemberEntity.getMemberName());
			scoreEntity.setMemberCode(purchaseProjectMemberEntity.getMemberCode());
			scoreEntity.setScoreStatus(1);
			scoreEntity.setId(IdWorker.getId());
			scoreEntity.setBillState(0);
			scoreList.add(scoreEntity);

			//赋值子表评审清单信息
			if (lotNum != null) {
				for (int i = 0; i < lotNum; i++) {
					// 循环体，执行 lotNum 次
					// 例如：System.out.println("第 " + (i+1) + " 次循环");
					List<ScoreAnswerEntity> scoreAnswerEntities = BeanMapper.mapList(purchaseProjectAnswerEntities, ScoreAnswerEntity.class);
					for (ScoreAnswerEntity scoreAnswerEntity : scoreAnswerEntities){
						scoreAnswerEntity.setId(IdWorker.getId());
						scoreAnswerEntity.setPid(scoreEntity.getId());
						scoreAnswerEntity.setLot(i+1);
					}
					scoreAnswerList.addAll(scoreAnswerEntities);
				}
			}

			if (purchaseProjectMemberEntity.getLeaderFlag() == 1){
				CollectEntity collectEntity = BeanMapper.map(approveEntity, CollectEntity.class);
				collectEntity.setMemo(null);
				collectEntity.setId(IdWorker.getId());
				collectEntity.setCollectStatus(1);
				collectEntity.setBillState(0);
				collectService.save(collectEntity);

				//赋值汇总子表信息
				List<CollectSupplierEntity> collectSupplierList = new ArrayList<>();
				if (lotNum != null) {

					for (int i = 0; i < lotNum; i++) {
						// 循环体，执行 lotNum 次
						// 例如：System.out.println("第 " + (i+1) + " 次循环");
						List<CollectSupplierEntity> collectSupplierEntities = BeanMapper.mapList(approveSupplierAllEntities, CollectSupplierEntity.class);
						for (CollectSupplierEntity collectSupplierEntity : collectSupplierEntities){
							collectSupplierEntity.setId(IdWorker.getId());
							collectSupplierEntity.setPid(collectEntity.getId());
							collectSupplierEntity.setLot(i+1);
						}
						collectSupplierList.addAll(collectSupplierEntities);
					}
				}
				collectSupplierService.saveBatch(collectSupplierList);


			}

		}
		scoreService.saveBatch(scoreList);
		scoreAnswerService.saveBatch(scoreAnswerList);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("已生成下游数据,不能撤回!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
