package com.ejianc.business.procurement.perform.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.perform.bean.CandidateEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectEntity;
import com.ejianc.business.procurement.perform.consts.BusinessStateEnum;
import com.ejianc.business.procurement.perform.consts.NobidMethodEnum;
import com.ejianc.business.procurement.perform.service.ICandidateService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectService;
import com.ejianc.business.procurement.perform.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.procurement.perform.bean.ResultEntity;
import com.ejianc.business.procurement.perform.service.IResultService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 采购结果审批
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("result")
public class ResultController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String HW_BILL_CODE = "HW-RESULT-CODE";
    private static final String GC_BILL_CODE = "GC-RESULT-CODE";
    private static final String FW_BILL_CODE = "FW-RESULT-CODE";

    @Autowired
    private IResultService service;

    @Autowired
    private IPurchaseProjectService purchaseProjectService;
    @Autowired
    private ICandidateService candidateService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ResultVO> saveOrUpdate(@RequestBody ResultVO saveOrUpdateVO) {
        LambdaQueryWrapper<ResultEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ResultEntity::getPurchaseProjectId, saveOrUpdateVO.getPurchaseProjectId());
        wrapper.ne(saveOrUpdateVO.getId() != null, ResultEntity::getId, saveOrUpdateVO.getId());
        if (service.count(wrapper) > 0) {
            return CommonResponse.error("该采购项目已存在一条采购结果单据，不允许重复添加！");
        }
        saveOrUpdateVO.sumDetailList();
        saveOrUpdateVO.sumSupplierList();
    	ResultEntity entity = BeanMapper.map(saveOrUpdateVO, ResultEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            String billcode = "";
            if("1".equals(saveOrUpdateVO.getBusinessType())){
                billcode = GC_BILL_CODE;
            }else if("2".equals(saveOrUpdateVO.getBusinessType())){
                billcode = HW_BILL_CODE;
            }else if("3".equals(saveOrUpdateVO.getBusinessType())){
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(billcode,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	return queryDetail(entity.getId());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ResultVO> queryDetail(Long id) {
    	ResultEntity entity = service.selectById(id);
    	ResultVO vo = BeanMapper.map(entity, ResultVO.class);
        vo.splitDetailList();
        vo.splitSupplierList();
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description
     * @param purchaseProjectId
     */
    @RequestMapping(value = "/queryDetailByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ResultVO> queryDetailByProjectId(Long purchaseProjectId,Long id) {
        LambdaQueryWrapper<ResultEntity> resultWrapper = Wrappers.lambdaQuery();
        resultWrapper.eq(ResultEntity::getPurchaseProjectId, purchaseProjectId);
        resultWrapper.ne(id != null, ResultEntity::getId, id);
        if (service.count(resultWrapper) > 0) {
            return CommonResponse.error("该采购项目已存在一条采购结果单据，不允许重复添加！");
        }

        ResultVO vo = new ResultVO();
        //带采购项目的清单明细
        PurchaseProjectEntity purchaseProjectEntity = purchaseProjectService.selectById(purchaseProjectId);
        PurchaseProjectVO projectVO = BeanMapper.map(purchaseProjectEntity, PurchaseProjectVO.class);
        projectVO.getDetailList().forEach(e->{
            e.setSourceId(e.getId().toString());
        });
        vo.setResultDetailList(BeanMapper.mapList(projectVO.getDetailList(),ResultDetailVO.class));
        vo.splitDetailList();

        //区分招标非招标
        if("1".equals(purchaseProjectEntity.getPerformWay())){
            //区分一级和二级
            if(1!=purchaseProjectEntity.getPermissionType()){
                //带成交候选人供应商子表逻辑
                LambdaQueryWrapper<CandidateEntity> wrapper = Wrappers.lambdaQuery();
                wrapper.eq(CandidateEntity::getPurchaseProjectId, purchaseProjectId);
                CandidateEntity candidateEntity = candidateService.getOne(wrapper);
                candidateEntity.getCandidateSupplierList().forEach(e->{
                    e.setSourceType("3");// 成交候选人
                    e.setSourceId(e.getId().toString());
                });
                vo.setResultSupplierList(BeanMapper.mapList(candidateEntity.getCandidateSupplierList(),ResultSupplierVO.class));
                vo.splitSupplierList();
            }
        }else{
            if(NobidMethodEnum.ZHI_JIE.getCode()==purchaseProjectEntity.getNobidMethod()){
                //带采购项目的供应商子表(只有一条数据)
                vo.setResultSupplierList1(BeanMapper.mapList(projectVO.getSupplierList(),ResultSupplierVO.class));
                vo.getResultSupplierList1().get(0).setSourceId(projectVO.getSupplierList().get(0).getId().toString());
                vo.getResultSupplierList1().get(0).setSourceType("4");//采购方案
                vo.getResultSupplierList1().get(0).setSupplierBidFlag(1);
                vo.getResultSupplierList1().get(0).setCandidateFlag(1);
                vo.getResultSupplierList1().get(0).setSupplierSelectFlag(1);
                vo.getResultSupplierList1().get(0).setSupplierFlag(1);
            }else if(NobidMethodEnum.JIAN_YI.getCode()==purchaseProjectEntity.getNobidMethod()){
                //不处理
            }else{
                //区分一级和二级
                if(1!=purchaseProjectEntity.getPermissionType()){
                    //带成交候选人供应商子表逻辑
                    LambdaQueryWrapper<CandidateEntity> wrapper = Wrappers.lambdaQuery();
                    wrapper.eq(CandidateEntity::getPurchaseProjectId, purchaseProjectId);
                    CandidateEntity candidateEntity = candidateService.getOne(wrapper);
                    candidateEntity.getCandidateSupplierList().forEach(e->{
                        e.setSourceType("3");// 成交候选人
                        e.setSourceId(e.getId().toString());
                    });
                    vo.setResultSupplierList(BeanMapper.mapList(candidateEntity.getCandidateSupplierList(),ResultSupplierVO.class));
                    vo.splitSupplierList();
                }

            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ResultVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ResultVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ResultVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResultVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name", "orgName", "executePlanCode"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ResultEntity> page = service.queryPage(param,false);
        IPage<ResultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ResultVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name", "orgName", "executePlanCode"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ResultEntity> list = service.queryList(param);
        List<ResultVO> voList = BeanMapper.mapList(list, ResultVO.class);
        for (ResultVO vo : voList) {
            Integer permissionType = vo.getPermissionType();
            if (permissionType != null) {
                if (permissionType.intValue() == 1) {
                    vo.setPermissionTypeName("一级集采");
                } else if (permissionType.intValue() == 2) {
                    vo.setPermissionTypeName("二级集采");
                } else if (permissionType.intValue() == 3) {
                    vo.setPermissionTypeName("所属单位");
                } else if (permissionType.intValue() == 4) {
                    vo.setPermissionTypeName("项目经理部");
                }
            }
            String businessType = vo.getBusinessType();
            if ("1".equals(businessType)) {
                vo.setBusinessTypeName("工程");
            } else if ("2".equals(businessType)) {
                vo.setBusinessTypeName("货物");
            }else {
                vo.setBusinessTypeName("服务");
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Result-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refResultData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ResultVO>> refResultData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("orgId")){
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            if(_con.containsKey("purchaseType")){
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ,_con.get("purchaseType")));
            }
            if(_con.containsKey("purchaseStage")){
                param.getParams().put("purchaseStage", new Parameter(QueryParam.EQ,_con.get("purchaseStage")));
            }
            if(_con.containsKey("businessType")){
                param.getParams().put("businessType", new Parameter(QueryParam.EQ, _con.get("businessType")));
            }
        }

        IPage<ResultEntity> page = service.queryPage(param,false);
        IPage<ResultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ResultVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelDetailExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelDetailExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ResultDetailVO> list = new ArrayList<>();
        Integer lot = Integer.getInteger(param.getParams().get("lot").getValue().toString());
        if(param.getParams().containsKey("id")){
            Long id= Long.valueOf(param.getParams().get("id").getValue().toString());
            ResultEntity resultEntity = service.selectById(id);
            list = BeanMapper.mapList(resultEntity.getResultDetailList().stream().filter(entity -> entity.getLot() == lot).collect(Collectors.toList()),ResultDetailVO.class);
        }else {
            Long purchaseProjectId = Long.valueOf(param.getParams().get("purchaseProjectId").getValue().toString());
            PurchaseProjectEntity purchaseProjectEntity = purchaseProjectService.selectById(purchaseProjectId);
            list = BeanMapper.mapList(purchaseProjectEntity.getDetailList().stream().filter(entity -> entity.getLot() == lot).collect(Collectors.toList()),ResultDetailVO.class);
            list.forEach(e->{
                e.setSourceId(e.getId().toString());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ResultDetail-export.xlsx", beans, response);
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ResultDetailVO> successList = new ArrayList<>();
        List<ResultDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ResultDetailVO detailVO = new ResultDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String sourceId = datas.get(0);
                    detailVO.setSourceId(sourceId);
                    if(ObjectUtils.isNotEmpty(datas.get(18))){
                        try {
                            detailVO.setWinbidDetailTaxPrice(BigDecimal.valueOf(Double.parseDouble(datas.get(18))));
                        } catch (Exception e) {
                            detailVO.setErrorCode(sourceId);
                            detailVO.setErrorMsg("中标含税单价格式错误！");
                            errorList.add(detailVO);
                            continue;
                        }
                    }else{
                        detailVO.setErrorCode(sourceId);
                        detailVO.setErrorMsg("中标含税单价不能为空！");
                        errorList.add(detailVO);
                        continue;
                    }
                    if(ObjectUtils.isNotEmpty(datas.get(19))){
                        try {
                            detailVO.setWinbidDetailPrice(BigDecimal.valueOf(Double.parseDouble(datas.get(19))));
                        } catch (Exception e) {
                            detailVO.setErrorCode(sourceId);
                            detailVO.setErrorMsg("中标无税单价格式错误！");
                            errorList.add(detailVO);
                            continue;
                        }
                    }else{
                        detailVO.setErrorCode(sourceId);
                        detailVO.setErrorMsg("中标无税单价不能为空！");
                        errorList.add(detailVO);
                        continue;
                    }

                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
