package com.ejianc.business.procurement.perform.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.perform.bean.*;
import com.ejianc.business.procurement.perform.service.*;
import com.ejianc.business.procurement.perform.vo.*;
import com.ejianc.business.procurement.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 应答文件评审表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("score")
public class ScoreController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;


    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IScoreSupplierService scoreSupplierService;
    @Autowired
    private IScoreAnswerService scoreAnswerService;
    @Autowired
    private IScoreSupplierAllService scoreSupplierAllService;

    @Autowired
    private IPurchaseProjectAnswerService purchaseProjectAnswerService;


    @Autowired
    private IScoreService service;

    private static final String HW_BILL_CODE = "SCORE_HW_CODE";
    private static final String GC_BILL_CODE = "SCORE_GC_CODE";
    private static final String FW_BILL_CODE = "SCORE_FW_CODE";

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ScoreVO> saveOrUpdate(@RequestBody ScoreVO saveOrUpdateVO) {
    	ScoreEntity entity = BeanMapper.map(saveOrUpdateVO, ScoreEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            String billcode = "";
            if("1".equals(saveOrUpdateVO.getBusinessType())){
                billcode = GC_BILL_CODE;
            }else if("2".equals(saveOrUpdateVO.getBusinessType())){
                billcode = HW_BILL_CODE;
            }else if("3".equals(saveOrUpdateVO.getBusinessType())){
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(billcode,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(entity.getId() == null || entity.getId() == 0){

        }else{
            //如果是修改的话  先根据主表id删除孙子表的所有信息
            LambdaQueryWrapper<ScoreSupplierEntity> lambdaSupplier = Wrappers.<ScoreSupplierEntity>lambdaQuery();
            lambdaSupplier.eq(ScoreSupplierEntity::getPid, entity.getId());
            scoreSupplierService.remove(lambdaSupplier);
            LambdaQueryWrapper<ScoreSupplierAllEntity> lambdaSupplierAll = Wrappers.<ScoreSupplierAllEntity>lambdaQuery();
            lambdaSupplierAll.eq(ScoreSupplierAllEntity::getPid, entity.getId());
            scoreSupplierAllService.remove(lambdaSupplierAll);
        }

        List<ScoreAnswerVO> detailListVo = saveOrUpdateVO.getScoreAnswerList();
        Map<String,List<ScoreSupplierVO>> sipplierMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(detailListVo)){
            detailListVo.forEach(e->{
                if(!"del".equals(e.getRowState())){
                    sipplierMap.put(e.getTid(),e.getSupplierList());
                }
            });
        }

    	service.saveOrUpdate(entity, false);

        //更新子表的 树形结构
        List<ScoreAnswerEntity> detailList = entity.getScoreAnswerList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (ScoreAnswerEntity cdEntity : detailList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ScoreAnswerEntity cdEntity : detailList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            scoreAnswerService.saveOrUpdateBatch(detailList);
        }

    	ScoreVO vo = BeanMapper.map(entity, ScoreVO.class);
    	return queryDetail(entity.getId());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ScoreVO> queryDetail(Long id) {
    	ScoreEntity entity = service.selectById(id);
    	ScoreVO vo = BeanMapper.map(entity, ScoreVO.class);
        LambdaQueryWrapper<ScoreSupplierEntity> lambda = Wrappers.<ScoreSupplierEntity>lambdaQuery();
        lambda.eq(ScoreSupplierEntity::getPid, entity.getId());
        List<ScoreSupplierEntity> supplierEntityList = scoreSupplierService.list(lambda);
        Map<Long,List<ScoreSupplierEntity>> map = supplierEntityList .stream().collect(Collectors.groupingBy(ScoreSupplierEntity::getAnswerId));
        List<ScoreAnswerVO> detailEntityList = vo.getScoreAnswerList();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for(ScoreAnswerVO confirmVO:detailEntityList){
                confirmVO.setSupplierList(BeanMapper.mapList(map.get(confirmVO.getId()),ScoreSupplierVO.class));
            }
            vo.setScoreAnswerList(TreeNodeBUtil.buildTree(detailEntityList));
        }

        //返回评审清单详情信息
//        purchaseProjectAnswerService.list();


        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScoreVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ScoreVO vo : vos) {
                LambdaQueryWrapper<ScoreSupplierEntity> lambda = Wrappers.<ScoreSupplierEntity>lambdaQuery();
                lambda.eq(ScoreSupplierEntity::getPid, vo.getId());
                scoreSupplierService.remove(lambda);
                LambdaQueryWrapper<ScoreSupplierAllEntity> lambdaAll = Wrappers.<ScoreSupplierAllEntity>lambdaQuery();
                lambdaAll.eq(ScoreSupplierAllEntity::getPid, vo.getId());
                scoreSupplierAllService.remove(lambdaAll);
            }
        }
        service.removeByIds(vos.stream().map(ScoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScoreVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ScoreEntity> page = service.queryPage(param,false);
        IPage<ScoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScoreVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ScoreEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Score-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refScoreData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ScoreVO>> refScoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ScoreEntity> page = service.queryPage(param,false);
        IPage<ScoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScoreVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
