package com.ejianc.business.production.task.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/6/15
 * @description:生产任务单分配车辆信息
 */
public class TaskDistributeCarVO implements Serializable {
    private static final long serialVersionUID = 1L;
    private BigDecimal transportCount; // 预计发货数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date transportTime; // 发货时间
    private Long unitId; // 机组id
    private String unitName; // 机组名称
    private Integer transportStatue; // 发货状态
    private BigDecimal shipmentQuantity; // 发货数量
    private String carCode; // 车牌号

    public BigDecimal getTransportCount() {
        return transportCount;
    }

    public void setTransportCount(BigDecimal transportCount) {
        this.transportCount = transportCount;
    }

    public Date getTransportTime() {
        return transportTime;
    }

    public void setTransportTime(Date transportTime) {
        this.transportTime = transportTime;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Integer getTransportStatue() {
        return transportStatue;
    }

    public void setTransportStatue(Integer transportStatue) {
        this.transportStatue = transportStatue;
    }

    public BigDecimal getShipmentQuantity() {
        return shipmentQuantity;
    }

    public void setShipmentQuantity(BigDecimal shipmentQuantity) {
        this.shipmentQuantity = shipmentQuantity;
    }

    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
}
