package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 租赁合同解除
 * 
 * @author generator
 * 
 */
public class RentContractRelieveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 项目部id
    private Long handleUser; // 经办人id
    private String handleUserName; // 经办人名称
    private Long departmentId; // 经办部门id
    private String departmentName; // 经办部门名称
    private String departmentCode; // 经办部门编码
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long partyId; // 甲方id
    private String partyName; // 甲方名称
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date relieveDate; // 解除日期
    private String relieveCause; // 解除原因
    private Integer draftType; // 起草方式 1、上传解除协议，2、已签章；
    private Long attachmentFileId; // 附件协议
    private String attachmentFileName; // 附件协议名称
    private String performanceStatus; // 合同状态 1、未签订；2、履约中；3、已终止；4、已作废 ；5 已冻结
    private String signatureState; // 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private Long companyId; // 所属单位
    private String companyName; // 所属单位名称
    @TableField("filing_ref")
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否
    @TableField("filing_status")
    private Integer filingStatus;//是否归档 1：是；0：否

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getHandleUser() {
        return handleUser;
    }
    @ReferDeserialTransfer
    public void setHandleUser(Long handleUser) {
        this.handleUser = handleUser;
    }
    public String getHandleUserName() {
        return handleUserName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getCompanyId() {
        return companyId;
    }
    @ReferDeserialTransfer
    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public void setHandleUserName(String handleUserName) {
        this.handleUserName = handleUserName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getPartyId() {
        return partyId;
    }
    @ReferDeserialTransfer
    public void setPartyId(Long partyId) {
        this.partyId = partyId;
    }
    public String getPartyName() {
        return partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getRelieveDate() {
        return relieveDate;
    }

    public void setRelieveDate(Date relieveDate) {
        this.relieveDate = relieveDate;
    }
    public String getRelieveCause() {
        return relieveCause;
    }

    public void setRelieveCause(String relieveCause) {
        this.relieveCause = relieveCause;
    }
    public Integer getDraftType() {
        return draftType;
    }

    public void setDraftType(Integer draftType) {
        this.draftType = draftType;
    }
    public Long getAttachmentFileId() {
        return attachmentFileId;
    }

    public void setAttachmentFileId(Long attachmentFileId) {
        this.attachmentFileId = attachmentFileId;
    }
    public String getAttachmentFileName() {
        return attachmentFileName;
    }

    public void setAttachmentFileName(String attachmentFileName) {
        this.attachmentFileName = attachmentFileName;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public String getSignatureState() {
        return signatureState;
    }

    public void setSignatureState(String signatureState) {
        this.signatureState = signatureState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
}
