package com.ejianc.business.appearance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 设备出场表
 * 
 * @author generator
 * 
 */
public class SupAppearanceVO{
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billCode; // 单据编号
    private String contractName; // 合同名称
    private Long contractId; // 合同id
    private String projectName; // 项目名称
    private Long projectId; // 项目id
    private String projectOrg; // 所属单位
    private Long projectOrgId; // 所属单位id
    private String supplierName; // 供应商
    private Long supplierId; // 供应商id
    private Date appearanceDate; // 出场日期
    private Date rentEndDate; // 止租日期
    private String employee; // 经办人
    private Long employeeId; // 经办人id
    private String photoPath; // 现场照片路径
    private String memo; // 备注
    private Long projectDepartmentId; // 项目部ID
    private String projectDepartmentName; // 项目部名称
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Boolean notSignature;//是否签字
    private String projectMangerSign; // 项目经理签字
    private String supplierSign; // 供应商签字

    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    private String systemId;//来源业务系统id
    private Long id; // 主键
    @ApiModelProperty("")
    private String supOperatorUserCode;
    @ApiModelProperty("")
    private String supOperatorPhone;
    @ApiModelProperty("")
    private String supOperatorName;
    @ApiModelProperty("")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;
    private List<SupAppearanceSubVO> appearanceSubList = new ArrayList<>(); // 设备出场-设备明细

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectOrg() {
        return projectOrg;
    }

    public void setProjectOrg(String projectOrg) {
        this.projectOrg = projectOrg;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Date getAppearanceDate() {
        return appearanceDate;
    }

    public void setAppearanceDate(Date appearanceDate) {
        this.appearanceDate = appearanceDate;
    }
    public Date getRentEndDate() {
        return rentEndDate;
    }

    public void setRentEndDate(Date rentEndDate) {
        this.rentEndDate = rentEndDate;
    }
    public String getEmployee() {
        return employee;
    }

    public void setEmployee(String employee) {
        this.employee = employee;
    }
    public Long getEmployeeId() {
        return employeeId;
    }
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getPhotoPath() {
        return photoPath;
    }

    public void setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Boolean getNotSignature() {
        return notSignature;
    }

    public void setNotSignature(Boolean notSignature) {
        this.notSignature = notSignature;
    }

    public String getProjectMangerSign() {
        return projectMangerSign;
    }

    public void setProjectMangerSign(String projectMangerSign) {
        this.projectMangerSign = projectMangerSign;
    }

    public String getSupplierSign() {
        return supplierSign;
    }

    public void setSupplierSign(String supplierSign) {
        this.supplierSign = supplierSign;
    }

    public List<SupAppearanceSubVO> getAppearanceSubList() {
        return appearanceSubList;
     }

     public void setAppearanceSubList(List<SupAppearanceSubVO> appearanceSubList) {
        this.appearanceSubList = appearanceSubList;
     }
}
