package com.ejianc.business.rent.hystrix;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rent.api.IRentAcceptanceApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

/**
 * 设备租赁熔断降级
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Component
public class RentAcceptanceHystrix implements IRentAcceptanceApi {

	/**
	 * 根据项目id、验收日期查询设备租赁单据数量
	 *
	 * @param jsonObject 参数
	 *
	 * @return CommonResponse<Integer>
	 */
	@Override
	public CommonResponse<Integer> countBillNum(JSONObject jsonObject) {
		return CommonResponse.error("服务器开小差了，请重试！");
	}
}
