package com.ejianc.business.rent.vo;

public enum RentPlanEnum {

    /** 待采购 */
    PLAN_STATE_WAIT(1, "待采购"),
    /** 采购中 */
    PLAN_STATE_EXEC(2, "采购中"),
    /** 采购完成 */
    PLAN_STATE_OVER(3, "采购完成");

    private final Integer planState;
    private final String description;

    RentPlanEnum(Integer planState, String description) {
        this.planState = planState;
        this.description = description;
    }

    /**
     * 获取采购状态
     * @return 采购状态
     */
    public Integer getPlanState() {
        return this.planState;
    }

    /**
     * 获取采购状态注释
     * @return 采购状态注释
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 根据采购状态获取采购状态枚举
     * @param planState 采购状态
     * @return 采购状态枚举
     */
    public static RentPlanEnum getEnumByStateCode(Integer planState) {
        for (RentPlanEnum bat : RentPlanEnum.values()) {
            if (bat.getPlanState().equals(planState)) return bat;
        }
        return null;
    }

    /**
     * 根据采购状态获取采购状态注释
     * @param planState 采购状态
     * @return 采购状态注释
     */
    public static String getDescriptionByStateCode(Integer planState){
        RentPlanEnum batPlanEnum = getEnumByStateCode(planState);
        if (batPlanEnum != null) return batPlanEnum.getDescription();
        return null;
    }
}
