package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁结算零星机械费用明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁结算零星机械费用明细")
public class RentSettlementFragmentaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键ID")
    private Long settlementId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(记录—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    @ApiModelProperty("开始日期")
    private Date fragmentaryStartDate;
    @ApiModelProperty("结束日期")
    private Date fragmentaryEndDate;
    @ApiModelProperty("金额(无税)")
    private BigDecimal fragmentaryMny;
    @ApiModelProperty("金额)")
    private BigDecimal fragmentaryTaxMny;
    @ApiModelProperty("税率")
    private BigDecimal fragmentaryTaxRate;
    @ApiModelProperty("税额")
    private BigDecimal fragmentaryTax;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("核算对象主键")
    private Long wbsIdFragmentary;
    @ApiModelProperty("核算对象编码")
    private String wbsCodeFragmentary;
    @ApiModelProperty("核算对象名称")
    private String wbsNameFragmentary;
    @ApiModelProperty("成本科目主键")
    private Long subjectIdFragmentary;
    @ApiModelProperty("成本科目编码")
    private String subjectCodeFragmentary;
    @ApiModelProperty("成本科目名称")
    private String subjectNameFragmentary;
    

    /**
     * 结算主键ID
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键ID
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源类型名称(记录—100231)
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称(记录—100231)
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源类型
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源编码
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源编码
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 开始日期
     */
    public Date getFragmentaryStartDate() {
        return fragmentaryStartDate;
    }

    /**
     * 开始日期
     */
    public void setFragmentaryStartDate(Date fragmentaryStartDate) {
        this.fragmentaryStartDate = fragmentaryStartDate;
    }
    /**
     * 结束日期
     */
    public Date getFragmentaryEndDate() {
        return fragmentaryEndDate;
    }

    /**
     * 结束日期
     */
    public void setFragmentaryEndDate(Date fragmentaryEndDate) {
        this.fragmentaryEndDate = fragmentaryEndDate;
    }
    /**
     * 金额(无税)
     */
    public BigDecimal getFragmentaryMny() {
        return fragmentaryMny;
    }

    /**
     * 金额(无税)
     */
    public void setFragmentaryMny(BigDecimal fragmentaryMny) {
        this.fragmentaryMny = fragmentaryMny;
    }
    /**
     * 金额)
     */
    public BigDecimal getFragmentaryTaxMny() {
        return fragmentaryTaxMny;
    }

    /**
     * 金额)
     */
    public void setFragmentaryTaxMny(BigDecimal fragmentaryTaxMny) {
        this.fragmentaryTaxMny = fragmentaryTaxMny;
    }
    /**
     * 税率
     */
    public BigDecimal getFragmentaryTaxRate() {
        return fragmentaryTaxRate;
    }

    /**
     * 税率
     */
    public void setFragmentaryTaxRate(BigDecimal fragmentaryTaxRate) {
        this.fragmentaryTaxRate = fragmentaryTaxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getFragmentaryTax() {
        return fragmentaryTax;
    }

    /**
     * 税额
     */
    public void setFragmentaryTax(BigDecimal fragmentaryTax) {
        this.fragmentaryTax = fragmentaryTax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 核算对象主键
     */
    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsIdFragmentary() {
        return wbsIdFragmentary;
    }

    /**
     * 核算对象主键
     */
    @ReferDeserialTransfer
    public void setWbsIdFragmentary(Long wbsIdFragmentary) {
        this.wbsIdFragmentary = wbsIdFragmentary;
    }
    /**
     * 核算对象编码
     */
    public String getWbsCodeFragmentary() {
        return wbsCodeFragmentary;
    }

    /**
     * 核算对象编码
     */
    public void setWbsCodeFragmentary(String wbsCodeFragmentary) {
        this.wbsCodeFragmentary = wbsCodeFragmentary;
    }
    /**
     * 核算对象名称
     */
    public String getWbsNameFragmentary() {
        return wbsNameFragmentary;
    }

    /**
     * 核算对象名称
     */
    public void setWbsNameFragmentary(String wbsNameFragmentary) {
        this.wbsNameFragmentary = wbsNameFragmentary;
    }
    /**
     * 成本科目主键
     */
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectIdFragmentary() {
        return subjectIdFragmentary;
    }

    /**
     * 成本科目主键
     */
    @ReferDeserialTransfer
    public void setSubjectIdFragmentary(Long subjectIdFragmentary) {
        this.subjectIdFragmentary = subjectIdFragmentary;
    }
    /**
     * 成本科目编码
     */


    public String getSubjectCodeFragmentary() {
        return subjectCodeFragmentary;
    }

    /**
     * 成本科目编码
     */
    public void setSubjectCodeFragmentary(String subjectCodeFragmentary) {
        this.subjectCodeFragmentary = subjectCodeFragmentary;
    }
    /**
     * 成本科目名称
     */
    public String getSubjectNameFragmentary() {
        return subjectNameFragmentary;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectNameFragmentary(String subjectNameFragmentary) {
        this.subjectNameFragmentary = subjectNameFragmentary;
    }
    
}
