package com.ejianc.business.rent.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 设备租赁结算主表
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁结算主表")
public class SupRentSettlementVO{
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    @ConvertField(targetField = "billCode")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    @ConvertField(targetField = "billState")
    private Integer billState;
    @ApiModelProperty("项目")
    @ConvertField(targetField = "projectId")
    private Long projectId;
    @ApiModelProperty("项目编码")
    @ConvertField(targetField = "projectCode")
    private String projectCode;
    @ApiModelProperty("项目名称")
    @ConvertField(targetField = "projectName")
    private String projectName;
    @ApiModelProperty("组织")
    @ConvertField(targetField = "orgId")
    private Long orgId;
    @ApiModelProperty("组织名称")
    @ConvertField(targetField = "orgName")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    @ConvertField(targetField = "parentOrgId")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    @ConvertField(targetField = "parentOrgName")
    private String parentOrgName;
    @ApiModelProperty("合同主键")
    @ConvertField(targetField = "contractId")
    private Long contractId;
    @ApiModelProperty("合同名称")
    @ConvertField(targetField = "contractName")
    private String contractName;
    @ApiModelProperty("合同编号")
    @ConvertField(targetField = "contractCode")
    private String contractCode;
    @ApiModelProperty("供应商")
    @ConvertField(targetField = "partybId")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    @ConvertField(targetField = "partybName")
    private String supplierName;
    @ApiModelProperty("经办人")
    @ConvertField(targetField = "employeeId")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    @ConvertField(targetField = "employeeName")
    private String employeeName;
    @ApiModelProperty("结算日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ConvertField(targetField = "settleDate")
    private Date settlementDate;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("备注")
    @ConvertField(targetField = "memo")
    private String memo;
    @ApiModelProperty("签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章")
    private Integer signatureStatus;
    @ApiModelProperty("签字状态，0-未签字,1-已签字")
    private Integer signStatus;
    @ApiModelProperty("结算类型，0-过程,1-最终")
    @ConvertField(targetField = "ultimateFlag")
    private Integer settlementType;
    @ApiModelProperty("计租方式")
    private String meterRentType;
    @ApiModelProperty("计租方式名称")
    private String meterRentTypeName;
    @ApiModelProperty("结算金额(无税)")
    @ConvertField(targetField = "curMny")
    private BigDecimal settlementMny;
    @ApiModelProperty("结算金额")
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal settlementTaxMny;
    @ApiModelProperty("结算税额")
    @ConvertField(targetField = "curTax")
    private BigDecimal settlementTax;
    @ApiModelProperty("租赁金额(无税)")
    private BigDecimal rentTotalMny;
    @ApiModelProperty("租赁金额")
    private BigDecimal rentTotalTaxMny;
    @ApiModelProperty("租赁税额")
    private BigDecimal rentTotalTax;
    @ApiModelProperty("其他金额(无税)")
    private BigDecimal otherMny;
    @ApiModelProperty("其他金额")
    private BigDecimal otherTaxMny;
    @ApiModelProperty("其他税额")
    private BigDecimal otherTax;
    @ApiModelProperty("合同金额")
    private BigDecimal contractTaxMny;
    @ApiModelProperty("合同金额（无税）")
    private BigDecimal contractMny;
    @ApiModelProperty("合同税额")
    private BigDecimal contractTax;
    @ApiModelProperty("合同收票金额")
    private BigDecimal contractInvoiceTaxMny;
    @ApiModelProperty("合同收票金额(不含税)")
    private BigDecimal contractInvoiceMny;
    @ApiModelProperty("合同已付金额")
    private BigDecimal contractPayMny;
    @ApiModelProperty("含本期结算金额")
    private BigDecimal currentSettlementTaxMny;
    @ApiModelProperty("含本期结算金额（无税）")
    private BigDecimal currentSettlementMny;
    @ApiModelProperty("合同支付比例")
    private BigDecimal contractPaymentRatio;
    @ApiModelProperty("")
    private String supOperatorUserCode;
    @ApiModelProperty("")
    private String supOperatorPhone;
    @ApiModelProperty("")
    private String supOperatorName;
    @ApiModelProperty("")
    private Date supOperateTime;
    @ApiModelProperty("单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方")
    private String billPushFlag;
    private BigDecimal dayTotalMny; // 日租赁金额(无税)
    private BigDecimal dayTotalTaxMny; // 日租赁金额
    private BigDecimal dayTotalTax; // 日租赁税额
    private BigDecimal monthTotalMny; // 月租赁金额(无税)
    private BigDecimal monthTotalTaxMny; // 月租赁金额
    private BigDecimal monthTotalTax; // 月租赁税额
    private BigDecimal quantitiesTotalMny; // 工程量租赁金额(无税)
    private BigDecimal quantitiesTotalTaxMny; // 工程量租赁金额
    private BigDecimal quantitiesTotalTax; // 工程量租赁税额
    private BigDecimal rentalTotalMny; // 租金额(无税)
    private BigDecimal rentalTotalTaxMny; // 租金金额
    private BigDecimal rentalTotalTax; // 租金税额
    @ApiModelProperty("关联状态")
    private String relationFlag; // 关联状态(1:是，0：否)
    @ApiModelProperty("分摊状态")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    private String systemId;//来源业务系统id
    private Long id; // 主键
    private Integer settlementNum;//生效结算次数
    @ApiModelProperty("项目部编码")
    private String orgCode; // 项目部编码
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode; // 项目部上级组织编码
    @ApiModelProperty("设备租赁结算日租明细")
    @SubEntity
    private List<SupRentSettlementDayVO> rentSettlementDayList = new ArrayList<>();
    @ApiModelProperty("设备租赁结算月租明细")
    @SubEntity
    private List<SupRentSettlementMonthVO> rentSettlementMonthList = new ArrayList<>();
    @ApiModelProperty("设备租赁结算工程量明细")
    @SubEntity
    private List<SupRentSettlementQuantitiesVO> rentSettlementQuantitiesList = new ArrayList<>();
    @ApiModelProperty("设备租赁结算租金明细")
    private List<SupRentSettlementRentalVO> rentSettlementRentalList = new ArrayList<>();
    @ApiModelProperty("设备租赁结算费用明细")
    private List<SupRentSettlementFeeVO> rentSettlementFeeList = new ArrayList<>();
    @ApiModelProperty("设备租赁结算零星机械费用明细")
    private List<SupRentSettlementFragmentaryVO> rentSettlementFragmentaryList = new ArrayList<>();

    public List<SupRentSettlementFragmentaryVO> getRentSettlementFragmentaryList() {
        return rentSettlementFragmentaryList;
    }

    public void setRentSettlementFragmentaryList(List<SupRentSettlementFragmentaryVO> rentSettlementFragmentaryList) {
        this.rentSettlementFragmentaryList = rentSettlementFragmentaryList;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getSettlementNum() {
        return settlementNum;
    }

    public void setSettlementNum(Integer settlementNum) {
        this.settlementNum = settlementNum;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public BigDecimal getDayTotalMny() {
        return dayTotalMny;
    }

    public void setDayTotalMny(BigDecimal dayTotalMny) {
        this.dayTotalMny = dayTotalMny;
    }

    public BigDecimal getDayTotalTaxMny() {
        return dayTotalTaxMny;
    }

    public void setDayTotalTaxMny(BigDecimal dayTotalTaxMny) {
        this.dayTotalTaxMny = dayTotalTaxMny;
    }

    public BigDecimal getDayTotalTax() {
        return dayTotalTax;
    }

    public void setDayTotalTax(BigDecimal dayTotalTax) {
        this.dayTotalTax = dayTotalTax;
    }

    public BigDecimal getMonthTotalMny() {
        return monthTotalMny;
    }

    public void setMonthTotalMny(BigDecimal monthTotalMny) {
        this.monthTotalMny = monthTotalMny;
    }

    public BigDecimal getMonthTotalTaxMny() {
        return monthTotalTaxMny;
    }

    public void setMonthTotalTaxMny(BigDecimal monthTotalTaxMny) {
        this.monthTotalTaxMny = monthTotalTaxMny;
    }

    public BigDecimal getMonthTotalTax() {
        return monthTotalTax;
    }

    public void setMonthTotalTax(BigDecimal monthTotalTax) {
        this.monthTotalTax = monthTotalTax;
    }

    public BigDecimal getQuantitiesTotalMny() {
        return quantitiesTotalMny;
    }

    public void setQuantitiesTotalMny(BigDecimal quantitiesTotalMny) {
        this.quantitiesTotalMny = quantitiesTotalMny;
    }

    public BigDecimal getQuantitiesTotalTaxMny() {
        return quantitiesTotalTaxMny;
    }

    public void setQuantitiesTotalTaxMny(BigDecimal quantitiesTotalTaxMny) {
        this.quantitiesTotalTaxMny = quantitiesTotalTaxMny;
    }

    public BigDecimal getQuantitiesTotalTax() {
        return quantitiesTotalTax;
    }

    public void setQuantitiesTotalTax(BigDecimal quantitiesTotalTax) {
        this.quantitiesTotalTax = quantitiesTotalTax;
    }

    public BigDecimal getRentalTotalMny() {
        return rentalTotalMny;
    }

    public void setRentalTotalMny(BigDecimal rentalTotalMny) {
        this.rentalTotalMny = rentalTotalMny;
    }

    public BigDecimal getRentalTotalTaxMny() {
        return rentalTotalTaxMny;
    }

    public void setRentalTotalTaxMny(BigDecimal rentalTotalTaxMny) {
        this.rentalTotalTaxMny = rentalTotalTaxMny;
    }

    public BigDecimal getRentalTotalTax() {
        return rentalTotalTax;
    }

    public void setRentalTotalTax(BigDecimal rentalTotalTax) {
        this.rentalTotalTax = rentalTotalTax;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 结算日期
     */
    public Date getSettlementDate() {
        return settlementDate;
    }

    /**
     * 结算日期
     */
    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    /**
     * 签字状态，0-未签字,1-已签字
     */
    public Integer getSignStatus() {
        return signStatus;
    }

    /**
     * 签字状态，0-未签字,1-已签字
     */
    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    /**
     * 结算类型，0-过程,1-最终
     */
    public Integer getSettlementType() {
        return settlementType;
    }

    /**
     * 结算类型，0-过程,1-最终
     */
    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }
    /**
     * 计租方式
     */
    public String getMeterRentType() {
        return meterRentType;
    }

    /**
     * 计租方式
     */
    public void setMeterRentType(String meterRentType) {
        this.meterRentType = meterRentType;
    }
    /**
     * 计租方式名称
     */
    public String getMeterRentTypeName() {
        return meterRentTypeName;
    }

    /**
     * 计租方式名称
     */
    public void setMeterRentTypeName(String meterRentTypeName) {
        this.meterRentTypeName = meterRentTypeName;
    }
    /**
     * 结算金额(无税)
     */
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    /**
     * 结算金额(无税)
     */
    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    /**
     * 结算金额
     */
    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    /**
     * 结算金额
     */
    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }
    /**
     * 结算税额
     */
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    /**
     * 结算税额
     */
    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }
    /**
     * 租赁金额(无税)
     */
    public BigDecimal getRentTotalMny() {
        return rentTotalMny;
    }

    /**
     * 租赁金额(无税)
     */
    public void setRentTotalMny(BigDecimal rentTotalMny) {
        this.rentTotalMny = rentTotalMny;
    }
    /**
     * 租赁金额
     */
    public BigDecimal getRentTotalTaxMny() {
        return rentTotalTaxMny;
    }

    /**
     * 租赁金额
     */
    public void setRentTotalTaxMny(BigDecimal rentTotalTaxMny) {
        this.rentTotalTaxMny = rentTotalTaxMny;
    }
    /**
     * 租赁税额
     */
    public BigDecimal getRentTotalTax() {
        return rentTotalTax;
    }

    /**
     * 租赁税额
     */
    public void setRentTotalTax(BigDecimal rentTotalTax) {
        this.rentTotalTax = rentTotalTax;
    }
    /**
     * 其他金额(无税)
     */
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    /**
     * 其他金额(无税)
     */
    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    /**
     * 其他金额
     */
    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    /**
     * 其他金额
     */
    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    /**
     * 其他税额
     */
    public BigDecimal getOtherTax() {
        return otherTax;
    }

    /**
     * 其他税额
     */
    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额（无税）
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额（无税）
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同税额
     */
    public BigDecimal getContractTax() {
        return contractTax;
    }

    /**
     * 合同税额
     */
    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    /**
     * 合同收票金额
     */
    public BigDecimal getContractInvoiceTaxMny() {
        return contractInvoiceTaxMny;
    }

    /**
     * 合同收票金额
     */
    public void setContractInvoiceTaxMny(BigDecimal contractInvoiceTaxMny) {
        this.contractInvoiceTaxMny = contractInvoiceTaxMny;
    }
    /**
     * 合同收票金额(不含税)
     */
    public BigDecimal getContractInvoiceMny() {
        return contractInvoiceMny;
    }

    /**
     * 合同收票金额(不含税)
     */
    public void setContractInvoiceMny(BigDecimal contractInvoiceMny) {
        this.contractInvoiceMny = contractInvoiceMny;
    }
    /**
     * 合同已付金额
     */
    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    /**
     * 合同已付金额
     */
    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }
    /**
     * 含本期结算金额
     */
    public BigDecimal getCurrentSettlementTaxMny() {
        return currentSettlementTaxMny;
    }

    /**
     * 含本期结算金额
     */
    public void setCurrentSettlementTaxMny(BigDecimal currentSettlementTaxMny) {
        this.currentSettlementTaxMny = currentSettlementTaxMny;
    }
    /**
     * 含本期结算金额（无税）
     */
    public BigDecimal getCurrentSettlementMny() {
        return currentSettlementMny;
    }

    /**
     * 含本期结算金额（无税）
     */
    public void setCurrentSettlementMny(BigDecimal currentSettlementMny) {
        this.currentSettlementMny = currentSettlementMny;
    }
    /**
     * 合同支付比例
     */
    public BigDecimal getContractPaymentRatio() {
        return contractPaymentRatio;
    }

    /**
     * 合同支付比例
     */
    public void setContractPaymentRatio(BigDecimal contractPaymentRatio) {
        this.contractPaymentRatio = contractPaymentRatio;
    }
    /**
     * 
     */
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    /**
     * 
     */
    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    /**
     * 
     */
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    /**
     * 
     */
    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    /**
     * 
     */
    public String getSupOperatorName() {
        return supOperatorName;
    }

    /**
     * 
     */
    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    /**
     * 
     */
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    /**
     * 
     */
    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    public String getBillPushFlag() {
        return billPushFlag;
    }

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
    
     /**
      * 设备租赁结算日租明细
      */
      public List<SupRentSettlementDayVO> getRentSettlementDayList() {
         return rentSettlementDayList;
      }
     /**
      * 设备租赁结算日租明细
      */
     public void setRentSettlementDayList(List<SupRentSettlementDayVO> rentSettlementDayList) {
         this.rentSettlementDayList = rentSettlementDayList;
     }
     /**
      * 设备租赁结算月租明细
      */
      public List<SupRentSettlementMonthVO> getRentSettlementMonthList() {
         return rentSettlementMonthList;
      }
     /**
      * 设备租赁结算月租明细
      */
     public void setRentSettlementMonthList(List<SupRentSettlementMonthVO> rentSettlementMonthList) {
         this.rentSettlementMonthList = rentSettlementMonthList;
     }
     /**
      * 设备租赁结算工程量明细
      */
      public List<SupRentSettlementQuantitiesVO> getRentSettlementQuantitiesList() {
         return rentSettlementQuantitiesList;
      }
     /**
      * 设备租赁结算工程量明细
      */
     public void setRentSettlementQuantitiesList(List<SupRentSettlementQuantitiesVO> rentSettlementQuantitiesList) {
         this.rentSettlementQuantitiesList = rentSettlementQuantitiesList;
     }
     /**
      * 设备租赁结算租金明细
      */
      public List<SupRentSettlementRentalVO> getRentSettlementRentalList() {
         return rentSettlementRentalList;
      }
     /**
      * 设备租赁结算租金明细
      */
     public void setRentSettlementRentalList(List<SupRentSettlementRentalVO> rentSettlementRentalList) {
         this.rentSettlementRentalList = rentSettlementRentalList;
     }
     /**
      * 设备租赁结算费用明细
      */
      public List<SupRentSettlementFeeVO> getRentSettlementFeeList() {
         return rentSettlementFeeList;
      }
     /**
      * 设备租赁结算费用明细
      */
     public void setRentSettlementFeeList(List<SupRentSettlementFeeVO> rentSettlementFeeList) {
         this.rentSettlementFeeList = rentSettlementFeeList;
     }
}
