package com.ejianc.business.settle.api;


import com.ejianc.business.settle.hystrix.SettleHystrix;
import com.ejianc.business.settle.vo.SourceBliVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 结算API
 */
@FeignClient(name = "ejc-proequipment-web", url = "${common.env.feign-client-url}", path = "ejc-proequipment-web", fallback = SettleHystrix.class)
public interface ISettleApi {
    /**
     * 设备管理：
     * 1、累计单据数量：查该供应商在本下项目生效的  设备租赁验收单、设备租赁结算单数量、设备采购结算；
     * 2、协同单据数量：查该供应商在本下项目生效的  设备租赁验收单（订单）、设备租赁结算单数量（已签字）、设备采购结算（已签字）；
     * 3、比例：协同单据数量/累计单据数量；
     * @param supplierId
     * @param dateIn
     * @return
     */
    @GetMapping(value = "/api/settle/getSourceBliVO")
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId, @RequestParam(value = "dateIn",required = false) String dateIn);
}
