package com.ejianc.business.pricelib.api;

import com.ejianc.business.pricelib.hystrix.RentPriceContractCollectHystrix;
import com.ejianc.business.pricelib.vo.RentPriceContractCollectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 设备购置价格库API
 */
@FeignClient(
        name = "ejc-proequipment-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-proequipment-web",
        fallback = RentPriceContractCollectHystrix.class
)
public interface IRentPriceContractCollectApi {

    // 查询多个档案清单历史价格
    @PostMapping(value = "/api/priceContractCollectApi/getPriceContractByDocIds")
    CommonResponse<List<RentPriceContractCollectVO>> getPriceContractByDocIds(@RequestParam List<Long> docIds, @RequestParam Integer rentType);
}
