package com.ejianc.business.pricelib.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pricelib.vo.RentPriceGuideDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 设备租赁指导价-主实体
 * 
 * @author generator
 * 
 */
public class RentPriceGuideVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private String theme; // 主题
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long employeeId; // 发布人id
    private String employeeName; // 发布人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date publishDate; // 发布日期
    private Integer flag; // 开启状态(0-开启,1-关闭)
    private String memo; // 描述
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    private String  flagName;
    private String billStateName;
    
    private List<RentPriceGuideDetailVO> rentPriceGuideDetailList = new ArrayList<>(); // 设备租赁指导价-价格明细子实体

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }
    public Integer getFlag() {
        return flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    
     public List<RentPriceGuideDetailVO> getRentPriceGuideDetailList() {
        return rentPriceGuideDetailList;
     }

     public void setRentPriceGuideDetailList(List<RentPriceGuideDetailVO> rentPriceGuideDetailList) {
        this.rentPriceGuideDetailList = rentPriceGuideDetailList;
     }

    public String getFlagName() {
        return flagName;
    }

    public void setFlagName(String flagName) {
        this.flagName = flagName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
