package com.ejianc.business.rent.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rent.hystrix.RentAcceptanceHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 设备租赁接口
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@FeignClient(name = "ejc-proequipment-web", url = "${common.env.feign-client-url}", path = "ejc-proequipment-web", fallback = RentAcceptanceHystrix.class)
public interface IRentAcceptanceApi {

	/**
	 * 根据项目id、验收日期查询设备租赁单据数量
	 *
	 * @param jsonObject 参数
	 *
	 * @return CommonResponse<Integer>
	 */
	@PostMapping(value = "/api/rentAcceptance/countBillNum")
	CommonResponse<Integer> countBillNum(@RequestBody JSONObject jsonObject);

}
