package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 租赁设备验收明细
 *
 * @author generator
 *
 */
public class RentAcceptanceSubVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 单据编号
    private String name; // 费用项目名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中

    private String specs; // 规格型号
    private String rentMode; // 租凭方式
    private String equipmentAppearanceCode; // 设备出场编号
    private Integer acceptanceResult; // 验收结果:1-合格,2-不合格
    private String acceptanceResultName; // 验收结果
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 启动时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date appearanceDate; // 出厂日期
    private String memo; // 备注
    private Long pid; // 主表id
    @ReferJsonField(referCode = "equipmentType001",referFields = "code",resultFields = "equipmentTypeCode")
    private Long categoryId; // 设备分类id
    private String categoryName; // 设备分类
    private String equipmentCode; // 设备编号
    private Long equipmentId; // 设备id
    private Integer num; // 数量
    private Integer rentTypeId; // 租赁方式id:1--日租,2--月租,3--工程量
    private String rentTypeName; // 租赁方式名称
    private BigDecimal price; // 租赁金额
    private BigDecimal notTaxPrice; // 无税租赁金额
    private Long contractId; // 合同id

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planIntoDate; // 计划进场日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planOutDate; // 计划出场日期
    private String productionManufactor; // 生成厂家
    private String unitName;
    private String factoryCode;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date meterRentDate;//计租日期
    private BigDecimal quantitiesNum;//工程数量
    private Long sourceId;
    @TableField(value="delivery_id")
    private Long deliveryId; // 发货主键ID
    @TableField(value="delivery_detail_id")
    private Long deliveryDetailId; // 发货明细主键ID
    @TableField(value="order_id")
    private Long orderId; // 订单主键ID
    @TableField(value="order_detail_id")
    private Long orderDetailId; // 订单明细主键ID
    public String getCode() {
        return code;
    }
    @TableField(value="unit_id")
    private Long unitId; //
    private Integer flagOil; // 是否含油 (1:是，0：否)
    private Integer flagOperation; // 是否含操作手(1:是，0：否)
    private String equipmentTypeCode;//设备类别编码

    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    public Integer getFlagOil() {
        return flagOil;
    }

    public void setFlagOil(Integer flagOil) {
        this.flagOil = flagOil;
    }

    public Integer getFlagOperation() {
        return flagOperation;
    }

    public void setFlagOperation(Integer flagOperation) {
        this.flagOperation = flagOperation;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }

    public Long getDeliveryDetailId() {
        return deliveryDetailId;
    }

    public void setDeliveryDetailId(Long deliveryDetailId) {
        this.deliveryDetailId = deliveryDetailId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getOrderDetailId() {
        return orderDetailId;
    }

    public void setOrderDetailId(Long orderDetailId) {
        this.orderDetailId = orderDetailId;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getSpecs() {
        return specs;
    }

    public void setSpecs(String specs) {
        this.specs = specs;
    }
    public String getRentMode() {
        return rentMode;
    }

    public void setRentMode(String rentMode) {
        this.rentMode = rentMode;
    }
    public String getEquipmentAppearanceCode() {
        return equipmentAppearanceCode;
    }

    public void setEquipmentAppearanceCode(String equipmentAppearanceCode) {
        this.equipmentAppearanceCode = equipmentAppearanceCode;
    }
    public Integer getAcceptanceResult() {
        return acceptanceResult;
    }

    public void setAcceptanceResult(Integer acceptanceResult) {
        this.acceptanceResult = acceptanceResult;
    }
    public String getAcceptanceResultName() {
        return acceptanceResultName;
    }

    public void setAcceptanceResultName(String acceptanceResultName) {
        this.acceptanceResultName = acceptanceResultName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getAppearanceDate() {
        return appearanceDate;
    }

    public void setAppearanceDate(Date appearanceDate) {
        this.appearanceDate = appearanceDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }
    public Integer getRentTypeId() {
        return rentTypeId;
    }

    public void setRentTypeId(Integer rentTypeId) {
        this.rentTypeId = rentTypeId;
    }
    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getNotTaxPrice() {
        return notTaxPrice;
    }

    public void setNotTaxPrice(BigDecimal notTaxPrice) {
        this.notTaxPrice = notTaxPrice;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    public Date getPlanOutDate() {
        return planOutDate;
    }

    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }

    public Date getMeterRentDate() {
        return meterRentDate;
    }

    public void setMeterRentDate(Date meterRentDate) {
        this.meterRentDate = meterRentDate;
    }

    public BigDecimal getQuantitiesNum() {
        return quantitiesNum;
    }

    public void setQuantitiesNum(BigDecimal quantitiesNum) {
        this.quantitiesNum = quantitiesNum;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
}
