package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 租赁合同-工程量明细记录表
 * 
 * @author generator
 * 
 */
public class RentQuantitiesRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 设备名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String quantitiesFactoryCode; // 设备出厂编号
    @ReferJsonField(referCode = "equipmentType001",referFields = "code",resultFields = "equipmentTypeCode")
    private Long categoryId; // 设备类别id
    private String categoryName; // 设备类别名称
    private String spec; // 规格型号
    private String unitName; // 单位
    private BigDecimal quantitiesNum; // 工程数量
    private BigDecimal quantitiesPrice; // 工程量单价
    private Integer rentNum; // 租赁数量
    private BigDecimal tax; // 税率
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planIntoDate; // 计划进程日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planOutDate; // 计划出场日期
    private String productionManufactor; // 生产厂家
    private String memo; // 备注
    private Long pid; // 主表id
    private String equipmentCode; // 设备编号
    private Long equipmentId; // 设备id
    private BigDecimal notTaxQuantitiesPrice; // 
    private BigDecimal notTaxQuantitiesMny; // 无税工程量金额
    private Long contractId; // 合同id
    private Long changeId; // 变更id
    private Long srcTblId; // 来源子表主键
    private Long recordId; // 记录表id
    private Long billingUnitId;
    private String billingUnitName;

    @TableField(value="rent_mny")
    private BigDecimal rentMny; // 租赁金额(无税)
    @TableField(value="rent_tax_mny")
    private BigDecimal rentTaxMny; // 租赁金额(含税)
    @TableField(value="tax_money")
    private BigDecimal taxMoney; // 税额
    @TableField(value="change_bid")
    private Long changeBid;//变更子表主键
    private String historyPriceArea;//历史价格区间（无税）
    private String historyTaxPriceArea;//历史价格区间（含税）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）
    private Integer flagOil; // 是否含油 (1:是，0：否)
    private Integer flagOperation; // 是否含操作手(1:是，0：否)
    private String equipmentTypeCode;//设备类别编码
    private String detailMeasurementRules;//计量规则

    private String jobContent;//工作内容

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getJobContent() {
        return jobContent;
    }

    public void setJobContent(String jobContent) {
        this.jobContent = jobContent;
    }
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    public Integer getFlagOil() {
        return flagOil;
    }

    public void setFlagOil(Integer flagOil) {
        this.flagOil = flagOil;
    }

    public Integer getFlagOperation() {
        return flagOperation;
    }

    public void setFlagOperation(Integer flagOperation) {
        this.flagOperation = flagOperation;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }

    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getQuantitiesFactoryCode() {
        return quantitiesFactoryCode;
    }

    public void setQuantitiesFactoryCode(String quantitiesFactoryCode) {
        this.quantitiesFactoryCode = quantitiesFactoryCode;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getQuantitiesNum() {
        return quantitiesNum;
    }

    public void setQuantitiesNum(BigDecimal quantitiesNum) {
        this.quantitiesNum = quantitiesNum;
    }

    public BigDecimal getQuantitiesPrice() {
        return quantitiesPrice;
    }

    public void setQuantitiesPrice(BigDecimal quantitiesPrice) {
        this.quantitiesPrice = quantitiesPrice;
    }
    public Integer getRentNum() {
        return rentNum;
    }

    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    public Date getPlanOutDate() {
        return planOutDate;
    }

    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public BigDecimal getNotTaxQuantitiesPrice() {
        return notTaxQuantitiesPrice;
    }

    public void setNotTaxQuantitiesPrice(BigDecimal notTaxQuantitiesPrice) {
        this.notTaxQuantitiesPrice = notTaxQuantitiesPrice;
    }
    public BigDecimal getNotTaxQuantitiesMny() {
        return notTaxQuantitiesMny;
    }

    public void setNotTaxQuantitiesMny(BigDecimal notTaxQuantitiesMny) {
        this.notTaxQuantitiesMny = notTaxQuantitiesMny;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }
    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
    @ReferSerialTransfer(referCode="share-unit")
    public Long getBillingUnitId() {
        return billingUnitId;
    }

    @ReferDeserialTransfer
    public void setBillingUnitId(Long billingUnitId) {
        this.billingUnitId = billingUnitId;
    }

    public String getBillingUnitName() {
        return billingUnitName;
    }

    public void setBillingUnitName(String billingUnitName) {
        this.billingUnitName = billingUnitName;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
}
