package com.ejianc.business.temporary.settlement.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.temporary.settlement.hystrix.ITemporarySettlementHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(
        name = "ejc-proequipment-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-proequipment-web",
        fallback = ITemporarySettlementHystrix.class
)
public interface ITemporarySettlementApi {

    /**
     * 根据 项目查询所有状态下的临时租赁结算的结算金额之和
     *
     * @param projectId  项目id
     * @return 查询结果
     */
    @RequestMapping(
            value = {"/api/temporarySettlement/queryTemporarySettlementMny"},
            method = {RequestMethod.GET}
    )
    CommonResponse<JSONObject> queryTemporarySettlementMny(@RequestParam("projectId") Long projectId);
}
