package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.rent.vo.RentRentalDayVO;
import com.ejianc.business.rent.vo.RentRentalMonthVO;
import com.ejianc.business.rent.vo.RentRentalQuantitiesVO;

/**
 * 租金计算主表
 * 
 * @author generator
 * 
 */
@ApiModel("租金计算主表")
public class RentRentalVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目编码")
    private String parentOrgCode;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("供应商")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("租金计算日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentalDate;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("计租方式")
    private String meterRentType;
    @ApiModelProperty("计租方式名称")
    private String meterRentTypeName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("租赁金额(无税)")
    private BigDecimal rentTotalMny;
    @ApiModelProperty("租赁金额")
    private BigDecimal rentTotalTaxMny;
    @ApiModelProperty("租赁税额")
    private BigDecimal rentTotalTax;
    @ApiModelProperty("结算状态（0-已结算，1-未结算）")
    private Integer settlementState;
    @ApiModelProperty("结算状态名称（0-已结算，1-未结算）")
    private String settlementStateName;

    private String billStateName;

    @ApiModelProperty("关联状态")
    private String relationFlag; // 关联状态(1:是，0：否)
    @ApiModelProperty("分摊状态")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @ApiModelProperty("租金计算类型（0：手动计算，1：自动计算）")
    private String rentalType; // 租金计算类型（0：手动计算，1：自动计算）
    private String orgCode; // 项目部编码
    private String rentType; // 租赁方式(0-外租，1-内租)
    
    @ApiModelProperty("租金计算日租明细")
    private List<RentRentalDayVO> rentRentalDayList = new ArrayList<>();
    @ApiModelProperty("租金计算月租明细")
    private List<RentRentalMonthVO> rentRentalMonthList = new ArrayList<>();
    @ApiModelProperty("租金计算工程量租明细")
    private List<RentRentalQuantitiesVO> rentRentalQuantitiesList = new ArrayList<>();

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getSettlementStateName() {
        return settlementStateName;
    }

    public void setSettlementStateName(String settlementStateName) {
        this.settlementStateName = settlementStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public String getRentalType() {
        return rentalType;
    }

    public void setRentalType(String rentalType) {
        this.rentalType = rentalType;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode = "rent-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 租金计算日期
     */
    public Date getRentalDate() {
        return rentalDate;
    }

    /**
     * 租金计算日期
     */
    public void setRentalDate(Date rentalDate) {
        this.rentalDate = rentalDate;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 计租方式
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getMeterRentType() {
        return meterRentType;
    }

    /**
     * 计租方式
     */
    @ReferDeserialTransfer
    public void setMeterRentType(String meterRentType) {
        this.meterRentType = meterRentType;
    }
    /**
     * 计租方式名称
     */
    public String getMeterRentTypeName() {
        return meterRentTypeName;
    }

    /**
     * 计租方式名称
     */
    public void setMeterRentTypeName(String meterRentTypeName) {
        this.meterRentTypeName = meterRentTypeName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 租赁金额(无税)
     */
    public BigDecimal getRentTotalMny() {
        return rentTotalMny;
    }

    /**
     * 租赁金额(无税)
     */
    public void setRentTotalMny(BigDecimal rentTotalMny) {
        this.rentTotalMny = rentTotalMny;
    }
    /**
     * 租赁金额
     */
    public BigDecimal getRentTotalTaxMny() {
        return rentTotalTaxMny;
    }

    /**
     * 租赁金额
     */
    public void setRentTotalTaxMny(BigDecimal rentTotalTaxMny) {
        this.rentTotalTaxMny = rentTotalTaxMny;
    }
    /**
     * 租赁税额
     */
    public BigDecimal getRentTotalTax() {
        return rentTotalTax;
    }

    /**
     * 租赁税额
     */
    public void setRentTotalTax(BigDecimal rentTotalTax) {
        this.rentTotalTax = rentTotalTax;
    }

    public Integer getSettlementState() {
        return settlementState;
    }

    public void setSettlementState(Integer settlementState) {
        this.settlementState = settlementState;
    }

    /**
      * 租金计算日租明细
      */
      public List<RentRentalDayVO> getRentRentalDayList() {
         return rentRentalDayList;
      }
     /**
      * 租金计算日租明细
      */
     public void setRentRentalDayList(List<RentRentalDayVO> rentRentalDayList) {
         this.rentRentalDayList = rentRentalDayList;
     }
     /**
      * 租金计算月租明细
      */
      public List<RentRentalMonthVO> getRentRentalMonthList() {
         return rentRentalMonthList;
      }
     /**
      * 租金计算月租明细
      */
     public void setRentRentalMonthList(List<RentRentalMonthVO> rentRentalMonthList) {
         this.rentRentalMonthList = rentRentalMonthList;
     }
     /**
      * 租金计算工程量租明细
      */
      public List<RentRentalQuantitiesVO> getRentRentalQuantitiesList() {
         return rentRentalQuantitiesList;
      }
     /**
      * 租金计算工程量租明细
      */
     public void setRentRentalQuantitiesList(List<RentRentalQuantitiesVO> rentRentalQuantitiesList) {
         this.rentRentalQuantitiesList = rentRentalQuantitiesList;
     }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }
}
