package com.ejianc.business.order.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 设备公司单据枚举
 */
public enum OutStatusTypeEnum {

    租出启用单("租出启用单", "EJCBT202210000064","projectSign"),
    租出停用单("租出停用单", "EJCBT202210000063","projectSign"),
    租出退场单("租出退场单", "EJCBT202210000054","projectSign"),
    租出结算单("租出结算单", "EJCBT202210000068","projectSign");

    private final String name;
    private final String code;
    private final String fileType;
    private static Map<String, OutStatusTypeEnum> enumMap = new HashMap();

    OutStatusTypeEnum(String name, String code, String fileType) {
        this.name = name;
        this.code = code;
        this.fileType = fileType;
    }

    public String getFileType() {
        return fileType;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static OutStatusTypeEnum getEnumByName(String billTypeName) {
        return (OutStatusTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(OutStatusTypeEnum.class).stream().collect(Collectors.toMap(OutStatusTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
