package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 租赁合同变更月租明细
 * 
 * @author generator
 * 
 */
public class RentChangeMonthDetailedVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 设备名称
    private String changeType; // 变更类型
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String monthFactoryCode; // 设备出厂编号
    private Long categoryId; // 设备类别id
    private String categoryName; // 设备类别名称
    private String spec; // 规格型号
    private String unitName; // 单位
    private BigDecimal monthRentPrice; // 月租单价
    private BigDecimal insufficientMonthDayRentPrice; // 不足月日租单价
    private BigDecimal stopRentPrice; // 停租单价
    private Integer rentNum; // 租赁数量
    private BigDecimal tax; // 税率
    private BigDecimal monthRentNotTaxPrice; // 日租单价无税
    private BigDecimal insufficientMonthNotTaxRentPrice; // 不足月日租单价(无税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planIntoDate; // 计划进程日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planOutDate; // 计划出场日期
    private String productionManufactor; // 生产厂家
    private String memo; // 备注
    private String equipmentCode; // 设备编号
    private Long contractId; // 合同id
    private Long changeId; // 变更id
    private Long srcTblId; // 来源子表主键
    private BigDecimal dayTaxPrice; // 含税日租单价
    private BigDecimal taxMny; // 含税金额
    private BigDecimal notTaxMonthPrice; // 无税月租单价
    private BigDecimal dayRentNotTaxPrice; // 无税日租单价
    private BigDecimal notTaxStopPrice; // 无税停租单价
    private BigDecimal beforeMonthRentPrice; // 变更前月租单价
    private BigDecimal beforeInsufficientMonthDayRentPrice; // 变更前不足月日租单价(无税)
    private BigDecimal beforeDayTaxPrice; // 变更前含税日租单价
    private Long equipmentId;
    private Long sourceId;
    private Boolean contrastFlag;
    private BigDecimal rentMonth; // 租赁月数
    private BigDecimal rentDay; // 租赁天数
    private BigDecimal rentMny; // 租赁金额(无税)
    private BigDecimal rentTaxMny; // 租赁金额(含税)
    private BigDecimal taxMoney; // 税额


    private String bcMonthFactoryCode; // 变更前设备出厂编号
    private BigDecimal bcMonthRentPrice; // 变更前月租单价
    private BigDecimal bcInsufficientMonthDayRentPrice; // 变更前不足月日租单价
    private BigDecimal bcStopRentPrice; // 变更前停租单价
    private Integer bcRentNum; // 变更前租赁数量
    private BigDecimal bcTax; // 变更前税率
    private BigDecimal bcMonthRentNotTaxPrice; // 变更前日租单价无税
    private BigDecimal bcInsufficientMonthNotTaxRentPrice; // 变更前不足月日租单价(无税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bcPlanIntoDate; // 变更前计划进程日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bcPlanOutDate; // 变更前计划出场日期
    private String bcProductionManufactor; // 变更前生产厂家
    private String bcMemo; // 变更前备注
    private String bcEquipmentCode; // 变更前变更前设备编号
    private BigDecimal bcDayTaxPrice; // 变更前含税日租单价
    private BigDecimal bcTaxMny; // 变更前含税金额
    private BigDecimal bcNotTaxMonthPrice; // 变更前无税月租单价
    private BigDecimal bcDayRentNotTaxPrice; // 变更前无税日租单价
    private BigDecimal bcNotTaxStopPrice; // 变更前无税停租单价
    private BigDecimal bcRentMonth; // 变更前租赁月数
    private BigDecimal bcRentDay; // 变更前租赁天数
    private BigDecimal bcRentMny; // 变更前租赁金额(无税)
    private BigDecimal bcRentTaxMny; // 变更前租赁金额(含税)
    private BigDecimal bcTaxMoney; // 变更前税额
    @TableField(value="target_unit_tax_price")
    private BigDecimal targetUnitTaxPrice; //定标单价
    private String historyPriceArea;//历史价格区间（无税）
    private String historyTaxPriceArea;//历史价格区间（含税）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    public BigDecimal getTargetUnitTaxPrice() {
        return targetUnitTaxPrice;
    }

    public void setTargetUnitTaxPrice(BigDecimal targetUnitTaxPrice) {
        this.targetUnitTaxPrice = targetUnitTaxPrice;
    }
    public String getBcMonthFactoryCode() {
        return bcMonthFactoryCode;
    }

    public void setBcMonthFactoryCode(String bcMonthFactoryCode) {
        this.bcMonthFactoryCode = bcMonthFactoryCode;
    }

    public BigDecimal getBcMonthRentPrice() {
        return bcMonthRentPrice;
    }

    public void setBcMonthRentPrice(BigDecimal bcMonthRentPrice) {
        this.bcMonthRentPrice = bcMonthRentPrice;
    }

    public BigDecimal getBcInsufficientMonthDayRentPrice() {
        return bcInsufficientMonthDayRentPrice;
    }

    public void setBcInsufficientMonthDayRentPrice(BigDecimal bcInsufficientMonthDayRentPrice) {
        this.bcInsufficientMonthDayRentPrice = bcInsufficientMonthDayRentPrice;
    }

    public BigDecimal getBcStopRentPrice() {
        return bcStopRentPrice;
    }

    public void setBcStopRentPrice(BigDecimal bcStopRentPrice) {
        this.bcStopRentPrice = bcStopRentPrice;
    }

    public Integer getBcRentNum() {
        return bcRentNum;
    }

    public void setBcRentNum(Integer bcRentNum) {
        this.bcRentNum = bcRentNum;
    }

    public BigDecimal getBcTax() {
        return bcTax;
    }

    public void setBcTax(BigDecimal bcTax) {
        this.bcTax = bcTax;
    }

    public BigDecimal getBcMonthRentNotTaxPrice() {
        return bcMonthRentNotTaxPrice;
    }

    public void setBcMonthRentNotTaxPrice(BigDecimal bcMonthRentNotTaxPrice) {
        this.bcMonthRentNotTaxPrice = bcMonthRentNotTaxPrice;
    }

    public BigDecimal getBcInsufficientMonthNotTaxRentPrice() {
        return bcInsufficientMonthNotTaxRentPrice;
    }

    public void setBcInsufficientMonthNotTaxRentPrice(BigDecimal bcInsufficientMonthNotTaxRentPrice) {
        this.bcInsufficientMonthNotTaxRentPrice = bcInsufficientMonthNotTaxRentPrice;
    }

    public Date getBcPlanIntoDate() {
        return bcPlanIntoDate;
    }

    public void setBcPlanIntoDate(Date bcPlanIntoDate) {
        this.bcPlanIntoDate = bcPlanIntoDate;
    }

    public Date getBcPlanOutDate() {
        return bcPlanOutDate;
    }

    public void setBcPlanOutDate(Date bcPlanOutDate) {
        this.bcPlanOutDate = bcPlanOutDate;
    }

    public String getBcProductionManufactor() {
        return bcProductionManufactor;
    }

    public void setBcProductionManufactor(String bcProductionManufactor) {
        this.bcProductionManufactor = bcProductionManufactor;
    }

    public String getBcMemo() {
        return bcMemo;
    }

    public void setBcMemo(String bcMemo) {
        this.bcMemo = bcMemo;
    }

    public String getBcEquipmentCode() {
        return bcEquipmentCode;
    }

    public void setBcEquipmentCode(String bcEquipmentCode) {
        this.bcEquipmentCode = bcEquipmentCode;
    }

    public BigDecimal getBcDayTaxPrice() {
        return bcDayTaxPrice;
    }

    public void setBcDayTaxPrice(BigDecimal bcDayTaxPrice) {
        this.bcDayTaxPrice = bcDayTaxPrice;
    }

    public BigDecimal getBcTaxMny() {
        return bcTaxMny;
    }

    public void setBcTaxMny(BigDecimal bcTaxMny) {
        this.bcTaxMny = bcTaxMny;
    }

    public BigDecimal getBcNotTaxMonthPrice() {
        return bcNotTaxMonthPrice;
    }

    public void setBcNotTaxMonthPrice(BigDecimal bcNotTaxMonthPrice) {
        this.bcNotTaxMonthPrice = bcNotTaxMonthPrice;
    }

    public BigDecimal getBcDayRentNotTaxPrice() {
        return bcDayRentNotTaxPrice;
    }

    public void setBcDayRentNotTaxPrice(BigDecimal bcDayRentNotTaxPrice) {
        this.bcDayRentNotTaxPrice = bcDayRentNotTaxPrice;
    }

    public BigDecimal getBcNotTaxStopPrice() {
        return bcNotTaxStopPrice;
    }

    public void setBcNotTaxStopPrice(BigDecimal bcNotTaxStopPrice) {
        this.bcNotTaxStopPrice = bcNotTaxStopPrice;
    }

    public BigDecimal getBcRentMonth() {
        return bcRentMonth;
    }

    public void setBcRentMonth(BigDecimal bcRentMonth) {
        this.bcRentMonth = bcRentMonth;
    }

    public BigDecimal getBcRentDay() {
        return bcRentDay;
    }

    public void setBcRentDay(BigDecimal bcRentDay) {
        this.bcRentDay = bcRentDay;
    }

    public BigDecimal getBcRentMny() {
        return bcRentMny;
    }

    public void setBcRentMny(BigDecimal bcRentMny) {
        this.bcRentMny = bcRentMny;
    }

    public BigDecimal getBcRentTaxMny() {
        return bcRentTaxMny;
    }

    public void setBcRentTaxMny(BigDecimal bcRentTaxMny) {
        this.bcRentTaxMny = bcRentTaxMny;
    }

    public BigDecimal getBcTaxMoney() {
        return bcTaxMoney;
    }

    public void setBcTaxMoney(BigDecimal bcTaxMoney) {
        this.bcTaxMoney = bcTaxMoney;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public BigDecimal getRentMonth() {
        return rentMonth;
    }

    public void setRentMonth(BigDecimal rentMonth) {
        this.rentMonth = rentMonth;
    }

    public BigDecimal getRentDay() {
        return rentDay;
    }

    public void setRentDay(BigDecimal rentDay) {
        this.rentDay = rentDay;
    }

    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }

    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMonthFactoryCode() {
        return monthFactoryCode;
    }

    public void setMonthFactoryCode(String monthFactoryCode) {
        this.monthFactoryCode = monthFactoryCode;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getMonthRentPrice() {
        return monthRentPrice;
    }

    public void setMonthRentPrice(BigDecimal monthRentPrice) {
        this.monthRentPrice = monthRentPrice;
    }

    public BigDecimal getStopRentPrice() {
        return stopRentPrice;
    }

    public void setStopRentPrice(BigDecimal stopRentPrice) {
        this.stopRentPrice = stopRentPrice;
    }
    public Integer getRentNum() {
        return rentNum;
    }

    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getMonthRentNotTaxPrice() {
        return monthRentNotTaxPrice;
    }

    public void setMonthRentNotTaxPrice(BigDecimal monthRentNotTaxPrice) {
        this.monthRentNotTaxPrice = monthRentNotTaxPrice;
    }

    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    public Date getPlanOutDate() {
        return planOutDate;
    }

    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }
    public BigDecimal getDayTaxPrice() {
        return dayTaxPrice;
    }

    public void setDayTaxPrice(BigDecimal dayTaxPrice) {
        this.dayTaxPrice = dayTaxPrice;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getNotTaxMonthPrice() {
        return notTaxMonthPrice;
    }

    public void setNotTaxMonthPrice(BigDecimal notTaxMonthPrice) {
        this.notTaxMonthPrice = notTaxMonthPrice;
    }
    public BigDecimal getDayRentNotTaxPrice() {
        return dayRentNotTaxPrice;
    }

    public void setDayRentNotTaxPrice(BigDecimal dayRentNotTaxPrice) {
        this.dayRentNotTaxPrice = dayRentNotTaxPrice;
    }
    public BigDecimal getNotTaxStopPrice() {
        return notTaxStopPrice;
    }

    public void setNotTaxStopPrice(BigDecimal notTaxStopPrice) {
        this.notTaxStopPrice = notTaxStopPrice;
    }
    public BigDecimal getInsufficientMonthDayRentPrice() {
        return insufficientMonthDayRentPrice;
    }

    public void setInsufficientMonthDayRentPrice(BigDecimal insufficientMonthDayRentPrice) {
        this.insufficientMonthDayRentPrice = insufficientMonthDayRentPrice;
    }
    public BigDecimal getInsufficientMonthNotTaxRentPrice() {
        return insufficientMonthNotTaxRentPrice;
    }

    public void setInsufficientMonthNotTaxRentPrice(BigDecimal insufficientMonthNotTaxRentPrice) {
        this.insufficientMonthNotTaxRentPrice = insufficientMonthNotTaxRentPrice;
    }
    public BigDecimal getBeforeMonthRentPrice() {
        return beforeMonthRentPrice;
    }

    public void setBeforeMonthRentPrice(BigDecimal beforeMonthRentPrice) {
        this.beforeMonthRentPrice = beforeMonthRentPrice;
    }
    public BigDecimal getBeforeInsufficientMonthDayRentPrice() {
        return beforeInsufficientMonthDayRentPrice;
    }

    public void setBeforeInsufficientMonthDayRentPrice(BigDecimal beforeInsufficientMonthDayRentPrice) {
        this.beforeInsufficientMonthDayRentPrice = beforeInsufficientMonthDayRentPrice;
    }
    public BigDecimal getBeforeDayTaxPrice() {
        return beforeDayTaxPrice;
    }

    public void setBeforeDayTaxPrice(BigDecimal beforeDayTaxPrice) {
        this.beforeDayTaxPrice = beforeDayTaxPrice;
    }

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Boolean getContrastFlag() {
        return contrastFlag;
    }

    public void setContrastFlag(Boolean contrastFlag) {
        this.contrastFlag = contrastFlag;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
}
