package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 施工机械结算子表
 * 
 * @author generator
 * 
 */
public class RentMachineSettlementContentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long settlementId; // 结算单主表ID
    private String equipmentCode; // 设备自编码
    private String equipmentName; // 设备名称
    private String spec; // 规格型号
    private String rentalUnit; // 计租单位
    private String enableTime; // 启用时间
    private String disableTime; // 停用时间
    private BigDecimal quantity; // 数量
    private BigDecimal price; // 单价
    private BigDecimal amount; // 金额
    private BigDecimal settlementNoTaxAmount; // 无税金额
    private BigDecimal settlementTaxAmount; // 税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date useDate; // 使用日期
    private String workContent; // 工作内容
    private Long rentUnitId;
    private Long equipmentId;

    private Long categoryId;
    private String categoryName;
    private String categoryCode;

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    @ReferSerialTransfer(referCode="share-unit")
    public Long getRentUnitId() {
        return rentUnitId;
    }
    @ReferDeserialTransfer
    public void setRentUnitId(Long rentUnitId) {
        this.rentUnitId = rentUnitId;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getRentalUnit() {
        return rentalUnit;
    }

    public void setRentalUnit(String rentalUnit) {
        this.rentalUnit = rentalUnit;
    }
    public String getEnableTime() {
        return enableTime;
    }

    public void setEnableTime(String enableTime) {
        this.enableTime = enableTime;
    }
    public String getDisableTime() {
        return disableTime;
    }

    public void setDisableTime(String disableTime) {
        this.disableTime = disableTime;
    }
    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public BigDecimal getSettlementNoTaxAmount() {
        return settlementNoTaxAmount;
    }

    public void setSettlementNoTaxAmount(BigDecimal settlementNoTaxAmount) {
        this.settlementNoTaxAmount = settlementNoTaxAmount;
    }
    public BigDecimal getSettlementTaxAmount() {
        return settlementTaxAmount;
    }

    public void setSettlementTaxAmount(BigDecimal settlementTaxAmount) {
        this.settlementTaxAmount = settlementTaxAmount;
    }
    public String getWorkContent() {
        return workContent;
    }

    public void setWorkContent(String workContent) {
        this.workContent = workContent;
    }

    public Date getUseDate() {
        return useDate;
    }

    public void setUseDate(Date useDate) {
        this.useDate = useDate;
    }
}
