package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.rent.vo.RentEquipmentPlanSubVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 租赁设备租赁计划
 * 
 * @author generator
 * 
 */
public class RentEquipmentPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 费用项目名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long companyId; // 所属单位
    private String companyName; // 所属单位名称
    private String planCode; // 计划编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planOutDateMain; // 计划出场日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planApproachDateMain; // 计划进场日期
    private Integer biddingState; // 招标状态:1-待招标,2-招标中，3-已招标
    private String biddingStateName;
    private BigDecimal temporaryAmount; // 暂估金额
    private String editionCode; // 版本编号
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private String memo; // 备注
    private Long organizationUserId; // 编制人id
    private String organizationUserName; // 编制人名称
    private String equipmentType; // 设备分类
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date organizationDate;
    private Long orgId;
    private String orgName; // 上级组织名称
    private List<RentEquipmentPlanSubVO> rentEquipmentPlanSubList = new ArrayList<>(); // 租赁设备租赁计划子表
    private String billStateName;

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public Date getPlanOutDateMain() {
        return planOutDateMain;
    }

    public void setPlanOutDateMain(Date planOutDateMain) {
        this.planOutDateMain = planOutDateMain;
    }

    public Date getPlanApproachDateMain() {
        return planApproachDateMain;
    }

    public void setPlanApproachDateMain(Date planApproachDateMain) {
        this.planApproachDateMain = planApproachDateMain;
    }

    public Integer getBiddingState() {
        return biddingState;
    }

    public void setBiddingState(Integer biddingState) {
        this.biddingState = biddingState;
    }
    public BigDecimal getTemporaryAmount() {
        return temporaryAmount;
    }

    public void setTemporaryAmount(BigDecimal temporaryAmount) {
        this.temporaryAmount = temporaryAmount;
    }
    public String getEditionCode() {
        return editionCode;
    }

    public void setEditionCode(String editionCode) {
        this.editionCode = editionCode;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrganizationUserId() {
        return organizationUserId;
    }

    public void setOrganizationUserId(Long organizationUserId) {
        this.organizationUserId = organizationUserId;
    }
    public String getOrganizationUserName() {
        return organizationUserName;
    }

    public void setOrganizationUserName(String organizationUserName) {
        this.organizationUserName = organizationUserName;
    }
    public String getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }
    
     public List<RentEquipmentPlanSubVO> getRentEquipmentPlanSubList() {
        return rentEquipmentPlanSubList;
     }

     public void setRentEquipmentPlanSubList(List<RentEquipmentPlanSubVO> rentEquipmentPlanSubList) {
        this.rentEquipmentPlanSubList = rentEquipmentPlanSubList;
     }

    public Date getOrganizationDate() {
        return organizationDate;
    }

    public void setOrganizationDate(Date organizationDate) {
        this.organizationDate = organizationDate;
    }

    public String getBiddingStateName() {
        return biddingStateName;
    }

    public void setBiddingStateName(String biddingStateName) {
        this.biddingStateName = biddingStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
