package com.ejianc.business.order.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.order.hystrix.RentReceiptsHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(
        name = "ejc-proequipment-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-proequipment-web",
        fallback = RentReceiptsHystrix.class
)
public interface IRentReceiptsApi {

    /**
     * 接收辅料中心推送的内租单据
     * @param json,type 单据标识
     */
    @PostMapping(value = "/api/proequipment/receiptsSync")
    CommonResponse<String> receiptsSync(@RequestBody JSONObject json, @RequestParam("type") String type);

    /**
     * 辅料中心内租单据删除
     * @param id,type 单据标识
     * @return
     */
    @PostMapping(value = "/api/proequipment/delReceipts")
    CommonResponse<String> delReceipts(@RequestParam("id") Long id, @RequestParam("type") String type);

    /**
     * 设备公司推送单据修改台账中设备状态
     * @param jsonArray
     * @param updateStartFlag：是否初次进场启用单撤回
     * @return
     */
    @PostMapping(value = "/api/proequipment/updateEquipmentState")
    CommonResponse<String> updateEquipmentState(@RequestBody JSONArray jsonArray, @RequestParam("updateStartFlag") Boolean updateStartFlag);

    /**
     * 订单变更送货状态
     * @param jsonArray
     * @return
     */
    @PostMapping(value = "/api/proequipment/orderChangeStatus")
    CommonResponse<String> orderChangeStatus(@RequestBody JSONArray jsonArray);
}
