package com.ejianc.business.rent.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 设备租赁结算月租明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁结算月租明细")
public class SupRentSettlementMonthVO  {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键ID")
    private Long settlementId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(记录—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    @ApiModelProperty("出厂编码")
    private String monthFactoryCode;
    @ApiModelProperty("设备类别")
    private Long equipmentTypeId;
    @ApiModelProperty("设备类别名称")
    private String equipmentTypeName;
    @ApiModelProperty("设备主键")
    private Long equipmentId;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("设备编码")
    private String equipmentCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date monthStartDate;
    @ApiModelProperty("结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date monthEndDate;
    @ApiModelProperty("月租赁单价(无税)")
    private BigDecimal monthPrice;
    @ApiModelProperty("月租赁单价")
    private BigDecimal monthTaxPrice;
    @ApiModelProperty("月停租赁单价(无税)")
    private BigDecimal monthStopPrice;
    @ApiModelProperty("月停租赁单价")
    private BigDecimal monthStopTaxPrice;
    @ApiModelProperty("不足月租赁单价")
    private BigDecimal ltMonthTaxPrice;
    @ApiModelProperty("不足月租赁单价(无税)")
    private BigDecimal ltMonthPrice;
    @ApiModelProperty("月租赁数量")
    private BigDecimal monthNum;
    @ApiModelProperty("月租赁金额(无税)")
    private BigDecimal monthMny;
    @ApiModelProperty("月租赁金额)")
    private BigDecimal monthTaxMny;
    @ApiModelProperty("月租赁税率")
    private BigDecimal monthTaxRate;
    @ApiModelProperty("月租赁税额")
    private BigDecimal monthTax;
    @ApiModelProperty("备注")
    private String memo;
    private String productionManufactor; // 生产厂家
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称
    private Long id; // 主键

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }


    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }


    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }

    /**
     * 结算主键ID
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键ID
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源类型名称(记录—100231)
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称(记录—100231)
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源类型
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源编码
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源编码
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 出厂编码
     */
    public String getMonthFactoryCode() {
        return monthFactoryCode;
    }

    public void setMonthFactoryCode(String monthFactoryCode) {
        this.monthFactoryCode = monthFactoryCode;
    }

    /**
     * 设备类别
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备类别
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 设备类别名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 设备类别名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 设备主键
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备主键
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 设备编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 开始日期
     */
    public Date getMonthStartDate() {
        return monthStartDate;
    }

    /**
     * 开始日期
     */
    public void setMonthStartDate(Date monthStartDate) {
        this.monthStartDate = monthStartDate;
    }
    /**
     * 结束日期
     */
    public Date getMonthEndDate() {
        return monthEndDate;
    }

    /**
     * 结束日期
     */
    public void setMonthEndDate(Date monthEndDate) {
        this.monthEndDate = monthEndDate;
    }
    /**
     * 月租赁单价(无税)
     */
    public BigDecimal getMonthPrice() {
        return monthPrice;
    }

    /**
     * 月租赁单价(无税)
     */
    public void setMonthPrice(BigDecimal monthPrice) {
        this.monthPrice = monthPrice;
    }
    /**
     * 月租赁单价
     */
    public BigDecimal getMonthTaxPrice() {
        return monthTaxPrice;
    }

    /**
     * 月租赁单价
     */
    public void setMonthTaxPrice(BigDecimal monthTaxPrice) {
        this.monthTaxPrice = monthTaxPrice;
    }
    /**
     * 月停租赁单价(无税)
     */
    public BigDecimal getMonthStopPrice() {
        return monthStopPrice;
    }

    /**
     * 月停租赁单价(无税)
     */
    public void setMonthStopPrice(BigDecimal monthStopPrice) {
        this.monthStopPrice = monthStopPrice;
    }
    /**
     * 月停租赁单价
     */
    public BigDecimal getMonthStopTaxPrice() {
        return monthStopTaxPrice;
    }

    /**
     * 月停租赁单价
     */
    public void setMonthStopTaxPrice(BigDecimal monthStopTaxPrice) {
        this.monthStopTaxPrice = monthStopTaxPrice;
    }
    /**
     * 不足月租赁单价
     */
    public BigDecimal getLtMonthTaxPrice() {
        return ltMonthTaxPrice;
    }

    /**
     * 不足月租赁单价
     */
    public void setLtMonthTaxPrice(BigDecimal ltMonthTaxPrice) {
        this.ltMonthTaxPrice = ltMonthTaxPrice;
    }
    /**
     * 不足月租赁单价(无税)
     */
    public BigDecimal getLtMonthPrice() {
        return ltMonthPrice;
    }

    /**
     * 不足月租赁单价(无税)
     */
    public void setLtMonthPrice(BigDecimal ltMonthPrice) {
        this.ltMonthPrice = ltMonthPrice;
    }
    /**
     * 月租赁数量
     */
    public BigDecimal getMonthNum() {
        return monthNum;
    }

    /**
     * 月租赁数量
     */
    public void setMonthNum(BigDecimal monthNum) {
        this.monthNum = monthNum;
    }
    /**
     * 月租赁金额(无税)
     */
    public BigDecimal getMonthMny() {
        return monthMny;
    }

    public void setMonthMny(BigDecimal monthMny) {
        this.monthMny = monthMny;
    }

    /**
     * 月租赁金额)
     */
    public BigDecimal getMonthTaxMny() {
        return monthTaxMny;
    }

    /**
     * 月租赁金额)
     */
    public void setMonthTaxMny(BigDecimal monthTaxMny) {
        this.monthTaxMny = monthTaxMny;
    }
    /**
     * 月租赁税率
     */
    public BigDecimal getMonthTaxRate() {
        return monthTaxRate;
    }

    /**
     * 月租赁税率
     */
    public void setMonthTaxRate(BigDecimal monthTaxRate) {
        this.monthTaxRate = monthTaxRate;
    }
    /**
     * 月租赁税额
     */
    public BigDecimal getMonthTax() {
        return monthTax;
    }

    /**
     * 月租赁税额
     */
    public void setMonthTax(BigDecimal monthTax) {
        this.monthTax = monthTax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
