package com.ejianc.business.ac.service;

import com.ejianc.business.ac.vo.ContractRelieveVO;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.ac.bean.ContractRelieveEntity;

/**
 * 安拆合同解除实体
 * 
 * @author generator
 * 
 */
public interface IContractRelieveService extends IBaseService<ContractRelieveEntity> {

    /**
     * 根据合同编号查询是否可以新增合同解除单据
     *
     * @param contractId 合同id
     * @return Boolean 是否可以新增
     */
    Boolean isCanRelieve(Long contractId);

    ExecutionVO targetCost(ContractRelieveVO contractRelieveVO, String linkUrl, Integer contractType);

    CommonResponse<String> relieveContract(String billId, String status, String refCode);
    
}
