package com.ejianc.business.pricelib.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pricelib.bean.RentPriceGuideDetailEntity;
import com.ejianc.business.pricelib.bean.RentPriceGuideEntity;
import com.ejianc.business.pricelib.service.IRentPriceGuideService;
import com.ejianc.business.pricelib.vo.PriceGuideDetailVO;
import com.ejianc.business.pricelib.vo.RentPriceGuideDetailVO;
import com.ejianc.business.pricelib.vo.RentPriceGuideVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 设备租赁指导价-主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentPriceGuide")
public class RentPriceGuideController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "RENT_GUID_PRICE";//专业分包指导价编码

    @Autowired
    private IRentPriceGuideService service;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentPriceGuideVO> saveOrUpdate(@RequestBody RentPriceGuideVO saveOrUpdateVO) {
        RentPriceGuideEntity entity = BeanMapper.map(saveOrUpdateVO, RentPriceGuideEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        RentPriceGuideVO vo = BeanMapper.map(service.selectById(entity.getId()), RentPriceGuideVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentPriceGuideVO> queryDetail(Long id) {
        RentPriceGuideEntity entity = service.selectById(id);
        RentPriceGuideVO vo = BeanMapper.map(entity, RentPriceGuideVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentPriceGuideVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (RentPriceGuideVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(RentPriceGuideVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentPriceGuideVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("theme");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        //查询本上范围内的指导价
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findParentsByOrgId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本上组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }

//        Boolean topOrgFlag = false;
//        CommonResponse<OrgVO> orgVO = iOrgApi.getOneById(orgId);
//        if(!orgResp.isSuccess()) {
//            logger.error("分页查询失败，获取当前本上组织信息失败, {}", orgResp.getMsg());
//            return CommonResponse.error("查询失败，获取组织信息失败！");
//        }else {
//            if (null == orgVO.getData().getParentId()){
//                topOrgFlag = true;
//            }
//        }

        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));


        IPage<RentPriceGuideEntity> page = service.queryPage(param,false);
        IPage<RentPriceGuideVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentPriceGuideVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("theme");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<RentPriceGuideEntity> list = service.queryList(param);
        List<RentPriceGuideVO> guideVOS = BeanMapper.mapList(list, RentPriceGuideVO.class);
        //todo:字段翻译等等
        guideVOS.stream().forEach(item -> {
            item.setFlagName(item.getFlag() == 0 ? "启用" : "禁用");
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", guideVOS);

        String exportFileName = "rentPriceGuide-export.xlsx";
        ExcelExport.getInstance().export(exportFileName, beans, response);
    }


    /**
     * @Description saveOrUpdate 启停用
     */
    @RequestMapping(value = "/startUpdate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentPriceGuideVO> startUpdate(@RequestParam Long id, Integer state) {
        RentPriceGuideEntity priceGuideEntity = service.selectById(id);
        priceGuideEntity.setFlag(state);
        service.saveOrUpdate(priceGuideEntity, false);
        RentPriceGuideVO vo = BeanMapper.map(priceGuideEntity, RentPriceGuideVO.class);
        return CommonResponse.success("启用停用状态调整成功！",vo);
    }


    /**
     * @Description saveOrUpdate 复制子表
     */
    @RequestMapping(value = "/copyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RentPriceGuideDetailVO>> copyDetail(@RequestParam Long id) {
        RentPriceGuideEntity priceGuideEntity = service.selectById(id);
        List<RentPriceGuideDetailEntity> detailList = priceGuideEntity.getRentPriceGuideDetailList();
        //将id设置为空
        detailList.forEach(detail -> {
            detail.setId(IdWorker.getId());
            detail.setRowState("add");
            detail.setVersion(null);
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setCreateUserCode(null);
            detail.setUpdateUserCode(null);
        });
        return CommonResponse.success("复制子表成功！",BeanMapper.mapList(detailList, RentPriceGuideDetailVO.class));
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "priceDetail-import.xlsx", "指导价明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<com.ejianc.business.pricelib.vo.PriceGuideDetailVO> successList = new ArrayList<>();
        List<com.ejianc.business.pricelib.vo.PriceGuideDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, EquipmentVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
                }
                CommonResponse<List<EquipmentVO>> equipmentRes =  shareEquipmentApi.queryEquipmentListByCodes(materialCodeList);
                if(!equipmentRes.isSuccess()){
                    return CommonResponse.error(equipmentRes.getMsg());
                }
                map = equipmentRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    com.ejianc.business.pricelib.vo.PriceGuideDetailVO detailVO = new PriceGuideDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String equipmentCode = datas.get(0);
                    detailVO.setDocCode(equipmentCode);
                    if(map.containsKey(equipmentCode)){
                        EquipmentVO equipmentVO =   map.get(equipmentCode);
                        detailVO.setDocCategoryId(equipmentVO.getCategoryId());
                        detailVO.setDocCategoryName(equipmentVO.getCategoryName());
                        detailVO.setDocId(equipmentVO.getId());
                        detailVO.setDocName(equipmentVO.getName());
                        detailVO.setSpec(equipmentVO.getSpec());
                        detailVO.setUnitId(equipmentVO.getUnitId());
                        detailVO.setUnitName(equipmentVO.getUnitName());
                    }else{
//                        detailVO.setErrorMsg("编码不匹配！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String minMny = datas.get(1);
                        detailVO.setMinPrice(StringUtils.isNotBlank(minMny) ? new BigDecimal(minMny) : null);
                    }
                    catch (Exception e) {
//                        detailVO.setErrorMsg("最低价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String maxMny = datas.get(2);
                        detailVO.setMaxPrice(StringUtils.isNotBlank(maxMny) ? new BigDecimal(maxMny) : null);
                    }
                    catch (Exception e) {
//                        detailVO.setErrorMsg("最高价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}


