package com.ejianc.business.pricelib.controller.api;

import com.ejianc.business.pricelib.service.IRentPriceContractCollectService;
import com.ejianc.business.pricelib.vo.RentPriceContractCollectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 设备租赁价格库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/priceContractCollectApi")
public class RentPriceContractCollectApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRentPriceContractCollectService service;

    //查询多个档案清单历史价格
    @PostMapping("/getPriceContractByDocIds")
    @ResponseBody
    public CommonResponse<List<RentPriceContractCollectVO>> getPriceContractByDocIds(@RequestParam List<Long> docIds, @RequestParam Integer rentType){
        logger.info("档案id集合【{}】", docIds);
        List<RentPriceContractCollectVO> PriceContractCollectVOList = service.getPriceContractByDocIds(docIds, rentType);
        return CommonResponse.success("查询成功！",PriceContractCollectVOList);
    }

}
