package com.ejianc.business.pricelib.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.pricelib.vo.PriceLibVO;
import com.ejianc.business.pricelib.vo.PriceTrendVo;
import com.ejianc.business.pricelib.vo.RentPriceContractVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.pricelib.bean.RentPriceContractEntity;

import java.util.Date;
import java.util.List;

/**
 * 设备租赁价格库-清单明细实体
 * 
 * @author generator
 * 
 */
public interface IRentPriceContractService extends IBaseService<RentPriceContractEntity> {
    /**
     * 查询合同价格库列表
     * @param param
     * @return
     */
    IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param);

    void savePriceContractByTiming(Date date);

    PriceLibVO queryPriceLibDetail(QueryParam param);

    List<PriceTrendVo> queryPriceTrendContractList(QueryParam param);

    void removePriceContractDetail(Long id);

    /**
     * 查询合同价价格库明细
     * @param param
     * @return
     */
    IPage<RentPriceContractVO>  queryPriceContractListDetail(QueryParam param);
}
