package com.ejianc.business.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 设备租赁结算工程量明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_rent_settlement_quantities")
public class RentSettlementQuantitiesEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="settlement_id")
    private Long settlementId; // 结算主键ID
    @TableField(value="source_id")
    private Long sourceId; // 来源主键ID
    @TableField(value="source_detail_id")
    private Long sourceDetailId; // 来源明细主键ID
    @TableField(value="source_name")
    private String sourceName; // 来源类型名称(记录—100231)
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型
    @TableField(value="source_code")
    private String sourceCode; // 来源编码
    @TableField(value="quantities_factory_code")
    private String quantitiesFactoryCode; // 出厂编码
    @TableField(value="equipment_type_id")
    private Long equipmentTypeId; // 设备类别
    @TableField(value="equipment_type_name")
    private String equipmentTypeName; // 设备类别名称
    @TableField(value="equipment_id")
    private Long equipmentId; // 设备主键
    @TableField(value="equipment_name")
    private String equipmentName; // 设备名称
    @TableField(value="equipment_code")
    private String equipmentCode; // 设备编码
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="unit_id")
    private Long unitId; // 单位id
    @TableField(value="billing_unit_name")
    private String billingUnitName; // 计费单位
    @TableField(value="billing_unit_id")
    private Long billingUnitId; // 计费单位id
    @TableField(value="quantities_start_date")
    private Date quantitiesStartDate; // 开始日期
    @TableField(value="quantities_end_date")
    private Date quantitiesEndDate; // 结束日期
    @TableField(value="quantities_price")
    private BigDecimal quantitiesPrice; // 工程租赁单价(无税)
    @TableField(value="quantities_tax_price")
    private BigDecimal quantitiesTaxPrice; // 工程租赁单价
    @TableField(value="rent_num")
    private BigDecimal rentNum; // 租赁数量
    @TableField(value="quantities_num")
    private BigDecimal quantitiesNum; // 工程数量
    @TableField(value="quantities_mny")
    private BigDecimal quantitiesMny; // 工程租赁金额(无税)
    @TableField(value="quantities_tax_mny")
    private BigDecimal quantitiesTaxMny; // 工程租赁金额)
    @TableField(value="quantities_tax_rate")
    private BigDecimal quantitiesTaxRate; // 工程租赁税率
    @TableField(value="quantities_tax")
    private BigDecimal quantitiesTax; // 工程租赁税额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="production_manufactor")
    private String productionManufactor; // 生产厂家
    @TableField(value="wbs_id")
    private Long wbsId; // 核算对象主键
    @TableField(value="wbs_code")
    private String wbsCode; // 核算对象编码
    @TableField(value="wbs_name")
    private String wbsName; // 核算对象名称
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目主键
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目编码
    @TableField(value="subject_name")
    private String subjectName; // 成本科目名称
    @TableField(value="flag_oil")
    private Integer flagOil; // 是否含油 (1:是，0：否)
    @TableField(value="flag_operation")
    private Integer flagOperation; // 是否含操作手(1:是，0：否)

    public Integer getFlagOil() {
        return flagOil;
    }

    public void setFlagOil(Integer flagOil) {
        this.flagOil = flagOil;
    }

    public Integer getFlagOperation() {
        return flagOperation;
    }

    public void setFlagOperation(Integer flagOperation) {
        this.flagOperation = flagOperation;
    }
    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getQuantitiesFactoryCode() {
        return quantitiesFactoryCode;
    }

    public void setQuantitiesFactoryCode(String quantitiesFactoryCode) {
        this.quantitiesFactoryCode = quantitiesFactoryCode;
    }

    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getBillingUnitName() {
        return billingUnitName;
    }

    public void setBillingUnitName(String billingUnitName) {
        this.billingUnitName = billingUnitName;
    }
    public Long getBillingUnitId() {
        return billingUnitId;
    }

    public void setBillingUnitId(Long billingUnitId) {
        this.billingUnitId = billingUnitId;
    }
    public Date getQuantitiesStartDate() {
        return quantitiesStartDate;
    }

    public void setQuantitiesStartDate(Date quantitiesStartDate) {
        this.quantitiesStartDate = quantitiesStartDate;
    }
    public Date getQuantitiesEndDate() {
        return quantitiesEndDate;
    }

    public void setQuantitiesEndDate(Date quantitiesEndDate) {
        this.quantitiesEndDate = quantitiesEndDate;
    }
    public BigDecimal getQuantitiesPrice() {
        return quantitiesPrice;
    }

    public void setQuantitiesPrice(BigDecimal quantitiesPrice) {
        this.quantitiesPrice = quantitiesPrice;
    }
    public BigDecimal getQuantitiesTaxPrice() {
        return quantitiesTaxPrice;
    }

    public void setQuantitiesTaxPrice(BigDecimal quantitiesTaxPrice) {
        this.quantitiesTaxPrice = quantitiesTaxPrice;
    }
    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }
    public BigDecimal getQuantitiesNum() {
        return quantitiesNum;
    }

    public void setQuantitiesNum(BigDecimal quantitiesNum) {
        this.quantitiesNum = quantitiesNum;
    }

    public BigDecimal getQuantitiesMny() {
        return quantitiesMny;
    }

    public void setQuantitiesMny(BigDecimal quantitiesMny) {
        this.quantitiesMny = quantitiesMny;
    }

    public BigDecimal getQuantitiesTaxMny() {
        return quantitiesTaxMny;
    }

    public void setQuantitiesTaxMny(BigDecimal quantitiesTaxMny) {
        this.quantitiesTaxMny = quantitiesTaxMny;
    }
    public BigDecimal getQuantitiesTaxRate() {
        return quantitiesTaxRate;
    }

    public void setQuantitiesTaxRate(BigDecimal quantitiesTaxRate) {
        this.quantitiesTaxRate = quantitiesTaxRate;
    }
    public BigDecimal getQuantitiesTax() {
        return quantitiesTax;
    }

    public void setQuantitiesTax(BigDecimal quantitiesTax) {
        this.quantitiesTax = quantitiesTax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
