package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
//import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.enums.ChangeStatusEnum;
import com.ejianc.business.rent.enums.ContractStatusEnum;
import com.ejianc.business.rent.enums.DraftTypeEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.rent.mapper.RentContractChangeMapper;
import com.ejianc.business.rent.mapper.RentContractMapper;
import com.ejianc.business.rent.service.*;
import com.ejianc.business.rent.utils.MaterialConstant;
import com.ejianc.business.rent.vo.*;
import com.ejianc.business.settle.vo.CostPriceApiVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.RentTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 租赁合同变更
 * 
 * @author generator
 * 
 */
@Service("rentContractChangeService")
public class RentContractChangeServiceImpl extends BaseServiceImpl<RentContractChangeMapper, RentContractChangeEntity> implements IRentContractChangeService{
    @Autowired
    private IRentContractService contractService;
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentContractRecordService contractRecordService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentContractRecordService rentContractRecordService;
    private static final String BILL_CHANGE_CODE = "RENT_CONTRACT_CHANGE";//此处需要根据实际修改
    private static final String PRICE_PARAM_CODE = "P-A71vRo0214";//价格控制参数

    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IRentDayDetailedService rentDayDetailedService;
    @Autowired
    private IRentMonthDetailedService rentMonthDetailedService;
    @Autowired
    private IRentQuantitiesDetailedService rentQuantitiesDetailedService;
    @Autowired
    private IRentOtherDetailedService rentOtherDetailedService;
    @Autowired
    private IRentTotalPlanService rentTotalPlanService;

    @Autowired
    private IRentContractClauseService contractClauseService;
    @Autowired
    private RentContractMapper rentContractMapper;
    @Autowired
    private IRentContractPaymentClauseService contractPaymentService;
    private final String CONTRACT_RECORD_REFCODE = "proSubContractRecord";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";
    private final String CONTRACT_REFCODE = "proSubContract";
    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";

    @Autowired
    private IAttachmentApi attachmentApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractChangeService contractChangeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IRentContractChangeAsyncService contractChangeAsyncService;
    @Autowired
    private IShareMaterialApi materialApi;

    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886"; // 水印参数

    private static final String CHECK_PARAM_CODE = "P-4i7sNe70";//变更金额控制
    private static final String CHECK_PLAN_CODE = "P-i91Xpi92";//设备租赁总计划金额控制

    // 设备租赁合同-签订、变更、补充协议  【设备租赁清单历史最高价】 控【设备租赁合同价格】
    private final String HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-Msv0xc0196";
    // 设备租赁合同-签订、变更、补充协议  【设备租赁清单历史最低价】 控【设备租赁合同价格】
    private final String HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-H2vDc40195";

    /**
     * 变更
     * @param rentContractChangeVO
     */
    @Override
    public RentContractChangeVO saveOrUpdates(RentContractChangeVO rentContractChangeVO) {
        RentContractEntity rentContractEntity =contractService.getById(rentContractChangeVO.getContractId());
        LambdaQueryWrapper<RentContractChangeEntity> lambdachange = Wrappers.<RentContractChangeEntity>lambdaQuery();
        lambdachange.eq(RentContractChangeEntity::getContractId, rentContractChangeVO.getMainContractId());
        if(rentContractChangeVO.getId() != null) {
            lambdachange.ne(RentContractChangeEntity::getId,rentContractChangeVO.getId());
        }
        lambdachange.and(l -> l.ne(RentContractChangeEntity::getSignatureState, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(RentContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        if(CollectionUtils.isNotEmpty(rentContractChangeVO.getAttachIds()) &&  null != rentContractEntity.getContractFileId()) {
            rentContractChangeVO.getAttachIds().remove(rentContractChangeVO.getContractFileId());
        }

        RentContractChangeEntity changeEntity = BeanMapper.map(rentContractChangeVO, RentContractChangeEntity.class);
        if (changeEntity.getId() == null){
            changeEntity.setSignatureState(SignatureStatusEnum.未签章.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setContractPerformanceState(ContractPerformanceStateEnum.未签订.getStateCode());
            if(changeEntity.getChangeVersion() < 10){
                changeEntity.setCode(changeEntity.getCode() + "10" + changeEntity.getChangeVersion());
            }else{
                changeEntity.setCode(changeEntity.getCode() + "1" + changeEntity.getChangeVersion());
            }
            this.clearDetailList(changeEntity);
        }
        changeEntity.setChangeContractName(changeEntity.getContractName());
        super.saveOrUpdate(changeEntity,false);//保存
        saveOrUpdateContract(changeEntity);//回写主表
        RentContractChangeVO changeVO = BeanMapper.map(changeEntity, RentContractChangeVO.class);
        return changeVO;
    }

    /**
     * 查询合同
     * @param contractId
     * @param changeId
     * @return
     */
    @Override
    public RentContractChangeVO addConvertByConId(Long contractId, Long changeId) {
        RentContractEntity contractEntity = contractService.selectById(contractId);
        if(ChangeStatusEnum.变更中.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            RentContractChangeEntity change = this.selectById(contractEntity.getChangeId());
            RentContractChangeVO vo = BeanMapper.map(change, RentContractChangeVO.class);
            return vo;
       }
        RentContractChangeVO changeVO = BeanMapper.map(contractEntity, RentContractChangeVO.class);
        changeVO.setBillState(null);

        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setMainContractId(contractEntity.getId());
        changeVO.setMainContractCode(contractEntity.getCode());
        changeVO.setMainContractName(contractEntity.getContractName());
        changeVO.setBeforeChangeTax(contractEntity.getContractAmountTax());
        changeVO.setSignedFileId(null);


        changeVO.setChangeDraftType(DraftTypeEnum.上传合同.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion()+ 1);
        changeVO.setSignatureState(SignatureStatusEnum.未签章.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.未归档.getTypeCode());
        changeVO.setWatermarkContractFileId(null); // 水印设置为null
       /* CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractEntity.getId()), billTypeCode, "attachMgr", String.valueOf(contractEntity.getId()), "BT200422000000028", "attachMgr");//附件
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));*/


        resetSub(changeVO);
        return changeVO;
    }


    /**
     * 更改子表
     * @param changeVO
     */
    public void resetSub(RentContractChangeVO changeVO) {
        //日租明细
        List<RentChangeDayDetailedVO> dayList = changeVO.getRentDayDetailedList();
        if(CollectionUtils.isNotEmpty(dayList)){
            dayList.forEach(dayDetailed ->{
                dayDetailed.setSrcTblId(dayDetailed.getId());
                dayDetailed.setId(IdWorker.getId());
//                dayDetailed.setSrcTblId(dayDetailed.getId());
                dayDetailed.setBeforeDayRentPrice(dayDetailed.getDayRentPrice());
                dayDetailed.setBeforeRentNum(dayDetailed.getRentNum());
                dayDetailed.setBeforeStopRentPrice(dayDetailed.getStopRentPrice());
                dayDetailed.setRowState("edit");
            });
        }
        //月租明细
        List<RentChangeMonthDetailedVO> monthList = changeVO.getRentMonthDetailedList();
        if(CollectionUtils.isNotEmpty(monthList)){
            monthList.forEach(monthDetailed ->{
                monthDetailed.setSrcTblId(monthDetailed.getId());
                monthDetailed.setId(IdWorker.getId());
                monthDetailed.setChangeId(monthDetailed.getId());
                monthDetailed.setBeforeDayTaxPrice(monthDetailed.getDayTaxPrice());
                monthDetailed.setBeforeInsufficientMonthDayRentPrice(monthDetailed.getInsufficientMonthDayRentPrice());
                monthDetailed.setBeforeMonthRentPrice(monthDetailed.getMonthRentPrice());
                monthDetailed.setRowState("add");
            });
        }

        List<RentChangeOtherDetailedVO> otherList = changeVO.getRentOtherDetailedList();
        if(CollectionUtils.isNotEmpty(otherList)){
            otherList.forEach(otherDetailed ->{
                otherDetailed.setSrcTblId(otherDetailed.getId());
                otherDetailed.setId(IdWorker.getId());
                otherDetailed.setBeforeNotTaxAmount(otherDetailed.getNotTaxAmount());
                otherDetailed.setBeforeNotTaxPrice(otherDetailed.getNotTaxPrice());
                otherDetailed.setBeforeNum(otherDetailed.getNum());
                otherDetailed.setBeforePrice(otherDetailed.getPrice());
                otherDetailed.setBeforeTax(otherDetailed.getTax());
                otherDetailed.setBeforeTaxAmount(otherDetailed.getTaxAmount());
                otherDetailed.setRowState("edit");
            });
        }
        //工程量
        List<RentChangeQuantitiesVO> quantitiesList = changeVO.getRentQuantitiesDetailedList();
        if(CollectionUtils.isNotEmpty(quantitiesList)){
            quantitiesList.forEach(quantities ->{
                quantities.setSrcTblId(quantities.getId());
                quantities.setId(IdWorker.getId());
                quantities.setBeforeQuantitiesNum(quantities.getQuantitiesNum());
                quantities.setBeforeQuantitiesPrice(quantities.getQuantitiesPrice());
                quantities.setBeforeRentNum(quantities.getRentNum());
                quantities.setBeforeTax(quantities.getTax());
                quantities.setRowState("edit");
            });
        }
        //合同条款
        List<RentChangeContractClauseVO> contractList = changeVO.getRentContractClauseList();
        if(CollectionUtils.isNotEmpty(contractList)){
            contractList.forEach(item ->{
                item.setSrcTblId(item.getId());
                item.setRowState("edit");
            });
        }

        //合同支付条款
        List<RentChangeContractPaymentVO> paymentList = changeVO.getRentContractPaymentClauseList();
        if(CollectionUtils.isNotEmpty(paymentList)){
            paymentList.forEach(item ->{
                item.setSrcTblId(item.getId());
                item.setRowState("edit");
            });
        }
    }

    /**
     * 变更回写到主合同
     */
    @Transactional
    public void saveOrUpdateContract(RentContractChangeEntity changeEntity){
        RentContractEntity rentContractEntity =contractService.getById(changeEntity.getContractId());
        rentContractEntity.setChangeCode(changeEntity.getCode());
        rentContractEntity.setChangeDate(changeEntity.getChangeDate());
        rentContractEntity.setChangeId(changeEntity.getId());
        rentContractEntity.setChangeStatus(2);//改成变更中
        rentContractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        rentContractEntity.setChangeFile(changeEntity.getChangeFile());
        rentContractEntity.setBeforeChangeMny(rentContractEntity.getContractMny());
        rentContractEntity.setAfterChangeMny(changeEntity.getChangeMny());
        rentContractEntity.setChangeVersion(changeEntity.getChangeVersion());
        rentContractEntity.setChangingMny((changeEntity.getChangeMny()!= null?changeEntity.getChangeMny():BigDecimal.ZERO).subtract(changeEntity.getChangeTax()!= null?changeEntity.getChangeTax():BigDecimal.ZERO));
        rentContractEntity.setChangeContractSignatureStatus(Integer.valueOf(changeEntity.getSignatureState()));
        rentContractEntity.setChangeFile(changeEntity.getChangeFile());
        contractService.saveOrUpdate(rentContractEntity);
    }

    /**
     * 查询详情
     * @param id
     * @return
     */
    @Override
    public RentContractChangeVO queryDetailRecord(Long id) {
        RentContractEntity contractEntity = contractService.selectById(id);
        RentContractChangeVO changeVO = new RentContractChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());

        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
//        param.getParams().put("contract_performance_state", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        param.getParams().put("signature_state", new Parameter(QueryParam.EQ, SignatureStatusEnum.已签章.getCode()));
        param.getOrderMap().put("change_date", QueryParam.DESC);
        param.getOrderMap().put("create_time", QueryParam.DESC);
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(change_mny) as sumChangeMoney, count(*) as changeNum");
        resp = super.getMap(wrapper);

        //设置变更详情
        changeVO.setChangeList(BeanMapper.mapList(queryList(param), RentContractChangeVO.class));

        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0 ){
            changeAmtRate = (sumChangeMoney.divide(contractEntity.getBaseTaxMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
        }

        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long) resp.get("changeNum");
        changeVO.setChangeNum(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0);
        changeVO.setChangeMnyRate(changeAmtRate);
        //区分是否主合同的变更合同
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
//        page.findUI('changeBtn').disabled = (data.performanceStatus == "3" ||
//                data.performanceStatus == "4" || data.performanceStatus == "5" ||
//                data.changeStatus == 2 || data.signatureStatus != 3) ? true : false;

//        //判断能否新增变更
//        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureState())
//                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())
//                || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
//                && (!(PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getContractPerformanceState())))){
//
//            changeVO.setEditFlag(this.editChangeFlag(id));
//        }
//        Boolean isEditFlag = null;
//        String contractPerformanceState = contractEntity.getContractPerformanceState();
//        Integer changeStatus = contractEntity.getChangeStatus();
//        String signatureState = contractEntity.getSignatureState();
//        if (contractPerformanceState.equals(PerformanceStatusEnum.已终止.getCode()) ||
//                contractPerformanceState.equals(PerformanceStatusEnum.已作废.getCode()) ||
//                contractPerformanceState.equals(PerformanceStatusEnum.已冻结.getCode()) ||
//                changeStatus.equals(ChangeStatusEnum.变更中.getCode()) )
//        {
//            isEditFlag = true;
//        }else {
//            isEditFlag = false;
//        }
//        changeVO.setEditFlag(isEditFlag);
        if(!(contractEntity.getRentHarborType()==null||0==contractEntity.getRentHarborType())){
            changeVO.setEditFlag(false); //内阻合同不支持变更
        }else if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureState())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())
                || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }


    /**
     * 查询能否变更
     *
     * @param contractId
     * @return
     */
    public Boolean editChangeFlag(Long contractId) {
        RentContractEntity contractEntity = contractService.selectById(contractId);
        // 非履约中合同不允许变更
        if (!ContractPerformanceStateEnum.履约中.getStateCode().equals(contractEntity.getContractPerformanceState())) {
            return false;
        }
         /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<RentContractChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(RentContractChangeEntity::getContractId, contractId);
        lambda.and(l -> l.ne(RentContractChangeEntity::getSignatureState, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(RentContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<RentContractChangeEntity> changeList = super.list(lambda);

        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }
//    /**
//     * 查询能否变更
//     * @param contractId
//     * @return
//     */
//    @Override
//    public Boolean editChangeFlag(Long contractId) {
//         /*
//            一个主合同仅有一个未生效得补充协议
//            单据生效： 当单据审批通过，且签章状态为已签章
//            自由态也不能新增
//         */
//        LambdaQueryWrapper<RentContractChangeEntity> lambda = new LambdaQueryWrapper<>();
//        lambda.eq(RentContractChangeEntity::getContractId, contractId);
//        lambda.and(l -> l.ne(RentContractChangeEntity::getSignatureState, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(RentContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
//        List<RentContractChangeEntity> changeList = super.list(lambda);
//        if (changeList.size() > 0){
//            return false;
//        }
//        return true;
//    }

    /**
     * 审批通过后调用
     * @param changeBillId
     * @param billTypeCode
     * @param commitState
     * @return
     */
    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        CommonResponse<String> resp = null;
        /**更新变更的审批时间  begin */
        RentContractChangeEntity changeEntity = this.selectById(changeBillId);

        // 原合同数据
        RentContractVO contractVO = rentContractService.queryDetail(changeEntity.getContractId());

        // 回写记录表数据
        writeBackRecord(changeEntity, contractVO);

        // 回写原合同数据
        RentContractEntity rentContractEntity = writeBackContract(changeEntity, contractVO);

        // 设置变更合同生效状态
        changeEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
        changeEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
        changeEntity.setChangeContractSignatureStatus(Integer.valueOf(SignatureStatusEnum.已签章.getCode()));
        changeEntity.setCommitDate(new Date());
        //合同已生效，添加生效时间
        changeEntity.setEffectiveDate(new Date());

        // 变更单更新
        contractChangeService.saveOrUpdate(changeEntity);

        // 推送合同池
        contractService.pushContract(BeanMapper.map(rentContractEntity, RentContractVO.class));

        return CommonResponse.success("变更单生效，回写合同成功！");

    }

    /**
     * 回写记录表数据
     * @param changeEntity
     * @param contractVO
     */
    public void writeBackRecord(RentContractChangeEntity changeEntity, RentContractVO contractVO) {
        // 同步原合同到记录表
        RentContractRecordEntity recordEntity = BeanMapper.map(contractVO, RentContractRecordEntity.class);
        recordEntity.setContractId(changeEntity.getContractId());
        recordEntity.setId(null);
        if(CollectionUtils.isNotEmpty(recordEntity.getRentDayDetailedList())){
            recordEntity.getRentDayDetailedList().forEach(vo -> {
//                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentMonthDetailedList())){
            recordEntity.getRentMonthDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentQuantitiesDetailedList())){
            recordEntity.getRentQuantitiesDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentOtherDetailedList())){
            recordEntity.getRentOtherDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentContractPaymentClauseList())){
            recordEntity.getRentContractPaymentClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }

        if(CollectionUtils.isNotEmpty(recordEntity.getRentContractPaymentClauseList())){
            recordEntity.getRentContractPaymentClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }

        contractRecordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");

        // 原合同附件、起草附件同步到记录单据中
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(contractVO.getId()), "BT220303000000002", "proRentContract",
                String.valueOf(recordEntity.getId()), "EJCBT202204000017", "proRentContractRecord");
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));

        logger.info("同步附件");
        CommonResponse<String> response2 = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(contractVO.getId()), "BT220303000000002", "proRentContractFile",
                String.valueOf(recordEntity.getId()), "EJCBT202204000017", "proRentContractRecordFile");
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response2));



    }
    public RentContractEntity writeBackContract(RentContractChangeEntity changeEntity, RentContractVO contractVO) {
        logger.info("更新变更数据到主合同表,contractVO---------------->: {}", JSONObject.toJSONString(contractVO));
        RentContractEntity contractEntity = BeanMapper.map(contractVO, RentContractEntity.class);
        //基本信息
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setPartyId(changeEntity.getPartyId());
        contractEntity.setPartyName(changeEntity.getPartyName());
        contractEntity.setPartyPhone(changeEntity.getPartyPhone());
        contractEntity.setPartyHandleUser(changeEntity.getPartyHandleUser());
        contractEntity.setPartyHandleUserName(changeEntity.getPartyHandleUserName());
        contractEntity.setPartyUser(changeEntity.getPartyUser());
        contractEntity.setPartyUserName(changeEntity.getPartyUserName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierHandleUser(changeEntity.getSupplierHandleUser());
        contractEntity.setSupplierHandleUserName(changeEntity.getSupplierHandleUserName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplementCode(changeEntity.getSupplementCode());
        contractEntity.setMeterRentType(changeEntity.getMeterRentType());
        contractEntity.setMeterRentTypeName(changeEntity.getMeterRentTypeName());
        contractEntity.setMonthSettlement(changeEntity.getMonthSettlement());
        contractEntity.setMeterDate(changeEntity.getMeterDate());
        contractEntity.setPreventDate(changeEntity.getPreventDate());
        contractEntity.setSignedDate(changeEntity.getSignedDate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFile(changeEntity.getContractFile());
        contractEntity.setChangingRatio(changeEntity.getChangingRatio());
        contractEntity.setChangeContractName(changeEntity.getContractName());
        contractEntity.setChangeFileId(changeEntity.getChangeFileId());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setSupplierAddress(changeEntity.getSupplierAddress());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setChangingTaxMny(null);
        contractEntity.setRentHarborType(changeEntity.getRentHarborType());
        contractEntity.setTargetType(changeEntity.getTargetType());
        contractEntity.setTargetResultId(changeEntity.getTargetResultId());
        contractEntity.setTargetResultName(changeEntity.getTargetResultName());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());

        contractEntity.setPurchaseId(changeEntity.getPurchaseId());
        contractEntity.setPurchaseName(changeEntity.getPurchaseName());

		/*
			起草方式为线下签订，则变更合同为已签章，直接生效。主合同状态改为已变更
			起草方式为线上起草、上传合同，则主合同状态改为变更单据已生效
		 */
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        // 回写原合同子表信息
        // 日租
        if (ListUtil.isNotEmpty(contractVO.getRentDayDetailedList())) {
            List<Long> collect = contractVO.getRentDayDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                rentDayDetailedService.removeByIds(collect);
            }

        }
        List<RentDayDetailedEntity> dailyRentList = BeanMapper.mapList(changeEntity.getRentDayDetailedList(), RentDayDetailedEntity.class);
        if (ListUtil.isNotEmpty(dailyRentList)) {
            for (RentDayDetailedEntity entity : dailyRentList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentDayDetailedList(dailyRentList);
        // 月租
        if (ListUtil.isNotEmpty(contractVO.getRentMonthDetailedList())) {
            List<Long> collect = contractVO.getRentMonthDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                rentMonthDetailedService.removeByIds(collect);
            }

        }
        List<RentMonthDetailedEntity> monthRentList = BeanMapper.mapList(changeEntity.getRentMonthDetailedList(), RentMonthDetailedEntity.class);
        if (ListUtil.isNotEmpty(dailyRentList)) {
            for (RentMonthDetailedEntity entity : monthRentList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentMonthDetailedList(monthRentList);
        // 工程租
        if (ListUtil.isNotEmpty(contractVO.getRentQuantitiesDetailedList())) {
            List<Long> collect = contractVO.getRentQuantitiesDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                rentQuantitiesDetailedService.removeByIds(collect);
            }

        }
        List<RentQuantitiesDetailedEntity> quantitiesDetailedList = BeanMapper.mapList(changeEntity.getRentQuantitiesDetailedList(), RentQuantitiesDetailedEntity.class);
        if (ListUtil.isNotEmpty(dailyRentList)) {
            for (RentQuantitiesDetailedEntity entity : quantitiesDetailedList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentQuantitiesDetailedList(quantitiesDetailedList);
        // 其他费用
        if (ListUtil.isNotEmpty(contractVO.getRentOtherDetailedList())) {
            List<Long> collect = contractVO.getRentOtherDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                rentOtherDetailedService.removeByIds(collect);
            }

        }
        List<RentOtherDetailedEntity> otherDetailedList = BeanMapper.mapList(changeEntity.getRentOtherDetailedList(), RentOtherDetailedEntity.class);
        if (ListUtil.isNotEmpty(dailyRentList)) {
            for (RentOtherDetailedEntity entity : otherDetailedList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
//
        contractEntity.setRentOtherDetailedList(otherDetailedList);
        // 条款
        if (ListUtil.isNotEmpty(contractVO.getRentContractClauseList())) {
            List<Long> collect = contractVO.getRentContractClauseList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                contractClauseService.removeByIds(collect);
            }

        }
        List<RentContractClauseEntity> contractClauseEntityList = BeanMapper.mapList(changeEntity.getRentContractClauseList(), RentContractClauseEntity.class);
        if (ListUtil.isNotEmpty(dailyRentList)) {
            for (RentContractClauseEntity entity : contractClauseEntityList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentContractClauseList(contractClauseEntityList);
        // 付款
        if (ListUtil.isNotEmpty(contractVO.getRentContractClauseList())) {
            List<Long> collect = contractVO.getRentContractPaymentClauseList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                contractClauseService.removeByIds(collect);
            }

        }
        List<RentContractPaymentClauseEntity> paymentClauseEntityList = BeanMapper.mapList(changeEntity.getRentContractPaymentClauseList(), RentContractPaymentClauseEntity.class);
        if (ListUtil.isNotEmpty(dailyRentList)) {
            for (RentContractPaymentClauseEntity entity : paymentClauseEntityList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentContractPaymentClauseList(paymentClauseEntityList);

        //
        contractService.saveOrUpdate(contractEntity, false);

        // 同步起草方式附件（不包含变更附件管理附件）到原合同
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(changeEntity.getId()), "BT220303000000001", "proRentContractChangeFile",
                String.valueOf(contractEntity.getId()), "BT220303000000002", "proRentContractFile");
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));
        return contractEntity;


    }
    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        RentContractChangeEntity entity = super.selectById(changeBillId);
        //合同变更只有详情页有删除
        RentContractEntity contractEntity = contractService.selectById(entity.getContractId());

        QueryWrapper<RentContractChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractEntity.getId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.ne("id", changeBillId);
        int count = super.count(query);

        contractEntity.setChangeVersion(contractEntity.getChangeVersion()-1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.已变更.getCode() : ChangeStatusEnum.未变更.getCode());
        //修改变更中金额
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFile(null);
        //contractEntity.setChangeContractName(null);
        contractService.update(contractEntity, new QueryWrapper<RentContractEntity>().eq("id",contractEntity.getId()),false);

        super.removeById(changeBillId,false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public RentContractChangeVO saveOrUpdate(RentContractChangeVO saveOrUpdateVO,Boolean isControl) {
        // 获取主合同当前合同文件Id
        RentContractEntity rentContractEntity = contractService.selectById(saveOrUpdateVO.getMainContractId());
        // 将主合同原合同文件从attachId中删除，否改文件会被该写到变更合同中
        if(ListUtil.isNotEmpty(saveOrUpdateVO.getAttachIds()) &&  null != rentContractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(rentContractEntity.getContractFileId());
        }

        RentContractChangeEntity entity = BeanMapper.map(saveOrUpdateVO, RentContractChangeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            if (!isControl){
//                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CHANGE_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
//                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//                if (billCode.isSuccess()) {
//                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//                }
//                else {
//                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//                }
            }
            entity.setSignatureState(SignatureStatusEnum.未签章.getCode());
            entity.setContractState(ContractStatusEnum.未签订.getCode());
            entity.setFilingRef(0);
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                // 第一次变更
                entity.setChangeVersion(1);
            }
            else {
                // 版本号+1
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }
            //设置编码
            if(entity.getChangeVersion() < 10){
                entity.setCode(saveOrUpdateVO.getCode() + "-1-0" + entity.getChangeVersion());
            } else {
                entity.setCode(saveOrUpdateVO.getCode() + "-1-"  + entity.getChangeVersion());
            }
            if (!isControl){
                // 清空字表id、复制sourceBid
                clearDetailList(entity);
            }
        }
        if (saveOrUpdateVO.getId() == null &&!isControl){
            QueryWrapper<RentContractChangeEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("contract_id", saveOrUpdateVO.getContractId()).orderByDesc("create_time");
            List<RentContractChangeEntity> list = super.list(wrapper);
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            //删除旧的目标成本
            ExecutionVO executionVO1;
            if (list.size() > 0) {
                executionVO1 = targetCost(BeanMapper.map(list.get(0), RentContractChangeVO.class),null);
            }else {
                executionVO1 = contractService.targetCost(BeanMapper.map(rentContractEntity, RentContractVO.class),"");

            }
            totalExecutionVOList.add(executionVO1.getTotalVO());
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException("删除旧目标成本失败！");
            }
        }

        contractService.validateContract(saveOrUpdateVO.getMainContractId(), MaterialConstant.变更单, saveOrUpdateVO.getId(), MaterialConstant.保存);
        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setContractName(entity.getContractName());
        entity.setChangeContractName(entity.getContractName());
        if (!isControl){
            this.saveOrUpdate(entity, false);
        }


        // 回写主合同信息
        LambdaUpdateWrapper<RentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(RentContractEntity::getChangeId, entity.getId());
        updateWrapper.set(RentContractEntity::getChangingMny, entity.getContractMny());
        updateWrapper.set(RentContractEntity::getChangingTaxMny, entity.getContractTaxMny());
        updateWrapper.set(RentContractEntity::getChangeCode, entity.getCode());
        updateWrapper.set(RentContractEntity::getChangeVersion, entity.getChangeVersion());
        updateWrapper.set(RentContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(RentContractEntity::getChangeDate, entity.getChangeDate());
        updateWrapper.set(RentContractEntity::getChangeDraftType, entity.getChangeDraftType());
        updateWrapper.set(RentContractEntity::getChangeContractSignatureStatus, entity.getSignatureState());
        updateWrapper.set(RentContractEntity::getChangeFileId, entity.getChangeFileId());
        updateWrapper.set(RentContractEntity::getChangeContractName, entity.getContractName());
        updateWrapper.eq(RentContractEntity::getId, entity.getMainContractId());
        if (!isControl){
            contractService.update(updateWrapper);
            RentContractChangeVO vo = BeanMapper.map(this.selectById(entity.getId()), RentContractChangeVO.class);

            // 推送新目标成本
            CommonResponse<String> response = executionApi.aggPush(targetCost(vo,null));
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败！");
            }
        }
        if (null ==entity.getId() && isControl) {
            entity.setId(IdWorker.getId());
            return BeanMapper.map(entity,RentContractChangeVO.class);
        }
        return BeanMapper.map(entity, RentContractChangeVO.class);

    }

    public void deleteOldCost(RentContractChangeVO changeVO) {
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();

        ExecutionVO executionVO = targetCost(changeVO,null);
        totalExecutionVOList.add(executionVO.getTotalVO());
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()){
            throw new BusinessException("删除旧目标成本失败！");
        }
    }
    @Override
    public ExecutionVO targetCost(RentContractChangeVO changeVO,Long lastSourceId) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();

        totalVO.setSourceId(changeVO.getId());
        totalVO.setTenantId(changeVO.getTenantId());
        totalVO.setBillCode(changeVO.getCode());
        totalVO.setBillType("BT220303000000001");
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.设备租赁合同.getCode());
        totalVO.setProjectId(changeVO.getProjectId());
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setMoney(changeVO.getContractMny());
        totalVO.setTaxMoney(changeVO.getContractTaxMny());
        totalVO.setLastSourceId(lastSourceId);
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipment-frontend/#/leaseContractcontractChangeCard?id=" + changeVO.getId());

        executionVO.setTotalVO(totalVO);
        //子表赋值
        //表体字段：组织(主表)、项目名称(主表)、计租方式、分类ID、分类编码、分类名称、设备档案编码、设备档案名称、单位、租赁数量、租赁天数、租赁月数、工程量、 租赁金额(无税)、租赁金额
        List<DetailExecutionVO> detailList = new ArrayList<>();
        if (null != changeVO.getRentDayDetailedList()){
            for (RentChangeDayDetailedVO rentDayDetailedVO : changeVO.getRentDayDetailedList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentDayDetailedVO.getId() == null ? IdWorker.getId() : rentDayDetailedVO.getId());
                detailExecutionVO.setSourceBillId(rentDayDetailedVO.getChangeId());
                detailExecutionVO.setContractId(changeVO.getContractId());
                detailExecutionVO.setRentType(RentTypeEnum.日租.getCode());

                //设备分类
                detailExecutionVO.setCategoryId(rentDayDetailedVO.getCategoryId());
                detailExecutionVO.setCategoryName(rentDayDetailedVO.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentDayDetailedVO.getEquipmentId());
                detailExecutionVO.setCode(rentDayDetailedVO.getEquipmentCode());
                detailExecutionVO.setName(rentDayDetailedVO.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentDayDetailedVO.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentDayDetailedVO.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentDayDetailedVO.getDayRentPrice());
                detailExecutionVO.setTaxPrice(rentDayDetailedVO.getDayRentNotTaxPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentDayDetailedVO.getRentNum()));
                //租赁月数
                detailExecutionVO.setRentDayNum(rentDayDetailedVO.getRentDay());
                //本期结算金额
                detailExecutionVO.setMoney(rentDayDetailedVO.getRentMny());
                detailExecutionVO.setTaxMoney(rentDayDetailedVO.getRentTaxMny());

                detailList.add(detailExecutionVO);
            }
        }
        if (null != changeVO.getRentMonthDetailedList()){
            for (RentChangeMonthDetailedVO rentMonthDetailedVO : changeVO.getRentMonthDetailedList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentMonthDetailedVO.getId() == null ? IdWorker.getId() : rentMonthDetailedVO.getId());
                detailExecutionVO.setSourceBillId(rentMonthDetailedVO.getChangeId());
                detailExecutionVO.setContractId(changeVO.getContractId());
                detailExecutionVO.setRentType(RentTypeEnum.月租.getCode());

                //设备分类
                detailExecutionVO.setCategoryId(rentMonthDetailedVO.getCategoryId());
                detailExecutionVO.setCategoryName(rentMonthDetailedVO.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentMonthDetailedVO.getEquipmentId());
                detailExecutionVO.setCode(rentMonthDetailedVO.getEquipmentCode());
                detailExecutionVO.setName(rentMonthDetailedVO.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentMonthDetailedVO.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentMonthDetailedVO.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentMonthDetailedVO.getMonthRentPrice());
                detailExecutionVO.setTaxPrice(rentMonthDetailedVO.getMonthRentNotTaxPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentMonthDetailedVO.getRentNum()));
                //租赁月数
                detailExecutionVO.setRentMonthNum(rentMonthDetailedVO.getRentMonth());
                //本期结算金额
                detailExecutionVO.setMoney(rentMonthDetailedVO.getRentMny());
                detailExecutionVO.setTaxMoney(rentMonthDetailedVO.getRentTaxMny());

                detailList.add(detailExecutionVO);
            }
        }
        if (null != changeVO.getRentQuantitiesDetailedList()){
            for (RentChangeQuantitiesVO rentQuantitiesDetailedVO : changeVO.getRentQuantitiesDetailedList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentQuantitiesDetailedVO.getId() == null ? IdWorker.getId() : rentQuantitiesDetailedVO.getId());
                detailExecutionVO.setSourceBillId(rentQuantitiesDetailedVO.getChangeId());
                detailExecutionVO.setContractId(changeVO.getContractId());
                detailExecutionVO.setRentType(RentTypeEnum.工程量租.getCode());

                //设备分类
                detailExecutionVO.setCategoryId(rentQuantitiesDetailedVO.getCategoryId());
                detailExecutionVO.setCategoryName(rentQuantitiesDetailedVO.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentQuantitiesDetailedVO.getEquipmentId());
                detailExecutionVO.setCode(rentQuantitiesDetailedVO.getEquipmentCode());
                detailExecutionVO.setName(rentQuantitiesDetailedVO.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentQuantitiesDetailedVO.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentQuantitiesDetailedVO.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentQuantitiesDetailedVO.getQuantitiesPrice());
                detailExecutionVO.setTaxPrice(rentQuantitiesDetailedVO.getNotTaxQuantitiesPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentQuantitiesDetailedVO.getRentNum()));
                //租赁月数
                detailExecutionVO.setQuantityNum(rentQuantitiesDetailedVO.getQuantitiesNum());
                //本期结算金额
                detailExecutionVO.setMoney(rentQuantitiesDetailedVO.getRentMny());
                detailExecutionVO.setTaxMoney(rentQuantitiesDetailedVO.getRentTaxMny());

                detailList.add(detailExecutionVO);
            }
        }

        //设备分类编码信息赋值
        //根据分类ID查询物料分类信息
        if (CollectionUtils.isNotEmpty(detailList)){
            List<Long> categoryIdList = detailList.stream().map(DetailExecutionVO::getCategoryId).collect(Collectors.toList());
            List<MaterialCategoryVO> categoryVOList = materialApi.queryCategoryListByIds(categoryIdList).getData();
            if (CollectionUtils.isNotEmpty(categoryVOList)){
                Map<Long, MaterialCategoryVO> categoryMap = categoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
                for (DetailExecutionVO detailExecutionVO : detailList) {
                    if (null != categoryMap.get(detailExecutionVO.getCategoryId())){
                        detailExecutionVO.setCategoryInnerCode(categoryMap.get(detailExecutionVO.getCategoryId()).getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryMap.get(detailExecutionVO.getCategoryId()).getCode());
                    }
                }
            }
        }
        executionVO.setDetailList(detailList);
        logger.info("目标成本推送数据---设备租赁合同变更---->{}", JSONObject.toJSONString(executionVO));
        return executionVO;
    }


    /**
     * 文件复制
     *
     * @param srcBillId 源单据Id
     * @param srcBillTypeCode 源单据类型
     * @param targetBillId 目标单据Id
     * @param targetBillTypeCode 目标单据类型
     * @param srcAttachSourceType 源单据附件业务类型
     * @return
     */
    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {

        //同步合同附件列表
        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
                srcAttachSourceType, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE);
        if (!copyContractAttachResp.isSuccess()){
            logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    ,srcBillId, srcBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, copyContractAttachResp.getMsg());
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
        }

        if(copyContractFile) {
            //同步合同文件
            CommonResponse copyContractFileResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE,
                    targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE);
            if (!copyContractFileResp.isSuccess()){
                logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                        ,srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, copyContractFileResp.getMsg());
                return CommonResponse.error("审批失败，同步合同文件失败，错误信息：" + copyContractFileResp.getMsg());
            }
        }

        return null;
    }
    @Override
    public void queryBpm(Long billId){
        RentContractEntity contractEntity = contractService.selectById(billId);
        if (contractEntity != null){

            if((DraftTypeEnum.线下签订.getCode().toString()).equals(contractEntity.getDraftType())) {
                //线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
                logger.info("合同id-{}为线下签订直接修改为签章状态并设置为履约中", billId);
                contractEntity.setSignatureState(com.ejianc.business.rent.enums.SignatureStatusEnum.已签章.getCode());
                contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
                //合同已生效，添加生效时间
                contractEntity.setEffectiveDate(new Date());
            } else if(null == contractEntity.getContractFileId()) {
                //确保线上起草方式时，用户已编辑合同文件
            }
        }

        //直审时添加单据提交人等信息
        contractEntity.setCommitDate(new Date());
        contractEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
        contractEntity.setCommitUserName(sessionManager.getUserContext().getUserName());


        contractService.saveOrUpdate(contractEntity);
    }

    public void clearDetailList(RentContractChangeEntity changeEntity) {
        // 日租
        if(ListUtil.isNotEmpty(changeEntity.getRentDayDetailedList())){
            for (RentChangeDayDetailedEntity entity : changeEntity.getRentDayDetailedList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 月租
        if(ListUtil.isNotEmpty(changeEntity.getRentMonthDetailedList())){
            for (RentChangeMonthDetailedEntity entity : changeEntity.getRentMonthDetailedList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 工程量租
        if(ListUtil.isNotEmpty(changeEntity.getRentMonthDetailedList())){
            for (RentChangeMonthDetailedEntity entity : changeEntity.getRentMonthDetailedList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 维修
        if(ListUtil.isNotEmpty(changeEntity.getRentOtherDetailedList())){
            for (RentChangeOtherDetailedEntity entity : changeEntity.getRentOtherDetailedList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }


        // 付款计划
        if(ListUtil.isNotEmpty(changeEntity.getRentContractPaymentClauseList())){
            for (RentChangeContractPaymentEntity entity : changeEntity.getRentContractPaymentClauseList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 合同条款
        if(ListUtil.isNotEmpty(changeEntity.getRentContractClauseList())){
            for (RentChangeContractClauseEntity entity : changeEntity.getRentContractClauseList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
    }


    @Override
    public ParamsCheckVO targetCostCtrl(RentContractChangeVO changeVO) {
        RentContractChangeVO contractVO1 = saveOrUpdate(changeVO,true);
        QueryWrapper<RentContractChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", changeVO.getContractId()).orderByDesc("create_time");
        List<RentContractChangeEntity> list = super.list(wrapper);
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        RentContractEntity rentContractEntity = contractService.selectById(changeVO.getContractId());
        Long lastSourceId = null;
        if (list.size() > 0) {
            lastSourceId = list.get(0).getId();
        }else {
            lastSourceId = rentContractEntity.getId();

        }
        ExecutionVO executionVO = targetCost(contractVO1,lastSourceId);
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = checkParams(contractVO1, response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        RentContractChangeVO contractVO = queryDetail(id);
        ExecutionVO executionVO = targetCost(contractVO,null);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public RentContractChangeVO queryDetail(Long id) {
        RentContractChangeEntity entity = contractChangeService.selectById(id);
        RentContractChangeVO vo = BeanMapper.map(entity, RentContractChangeVO.class);
        return vo;
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        RentContractChangeEntity changeEntity = super.selectById(billId);
        if (changeEntity != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                this.effectiveSaveWriteContract(billId, changeEntity.getCode(), false);
                // 推送合同池
//                rentContractService.pushContract(BeanMapper.map(contractEntity, RentContractVO.class));
                return true;
            }
            else {
                changeEntity.setSignatureState(String.valueOf(status));
                super.saveOrUpdate(changeEntity);
                logger.info("变更合同签章状态已修改---------------->");
                //回写主合同（变更合同签章状态，主合同变更状态）
                LambdaUpdateWrapper<RentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(RentContractEntity::getId, changeEntity.getContractId());
                updateWrapper.set(RentContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureState()));
                contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
                logger.info("签章状态为已签章，回写主合同签章状态---------------->");
            }
            return true;
        }
        else {
            return false;
        }
    }
    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(RentContractChangeVO vo,ParamsCheckVO paramsCheckVO2){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        if(CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
        }
        paramsCheckVOS.addAll(this.checkParamsMny(vo));//合同金额控制变更金额
        paramsCheckVOS.addAll(this.checkParamsMnyPlan(vo));//总计划金额控制
        if(paramsCheckVO2!=null){//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }
        // 历史价控 合同价
        paramsCheckVOS.addAll(this.historyPriceCtrlContractPrice(vo));

        //目标成本价格控制
        ParamsCheckVO costParams = this.costPriceCheckParams(vo);
        if(costParams!=null){
            paramsCheckVOS.add(costParams);
        }
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    /**
     * 目标价格控制
     * @param vo
     * @return
     */
    public ParamsCheckVO costPriceCheckParams(RentContractChangeVO vo) {
        List<RentChangeDayDetailedVO> rentSettlementDayList = vo.getRentDayDetailedList();
        List<RentChangeMonthDetailedVO> rentSettlementMonthList = vo.getRentMonthDetailedList();
        List<RentChangeQuantitiesVO> rentSettlementQuantitiesList = vo.getRentQuantitiesDetailedList();

        CostPriceApiVO materialPriceHistoryApiVO = new CostPriceApiVO();
        List<CostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(rentSettlementDayList)){
            for (RentChangeDayDetailedVO detailVO : rentSettlementDayList) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getEquipmentId()!=null){
                    CostPriceApiVO priceHistoryApiVO = new CostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                    priceHistoryApiVO.setMaterialName(detailVO.getName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getDayRentNotTaxPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getDayRentPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if(CollectionUtil.isNotEmpty(rentSettlementMonthList)){
            for (RentChangeMonthDetailedVO detailVO : rentSettlementMonthList) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getEquipmentId()!=null){
                    CostPriceApiVO priceHistoryApiVO = new CostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                    priceHistoryApiVO.setMaterialName(detailVO.getName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getMonthRentNotTaxPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getMonthRentPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if(CollectionUtil.isNotEmpty(rentSettlementQuantitiesList)){
            for (RentChangeQuantitiesVO detailVO : rentSettlementQuantitiesList) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getEquipmentId()!=null){
                    CostPriceApiVO priceHistoryApiVO = new CostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                    priceHistoryApiVO.setMaterialName(detailVO.getName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getNotTaxQuantitiesPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getQuantitiesPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = rentSettlementService.costPriceParams(materialPriceHistoryApiVO,PRICE_PARAM_CODE,"设备租赁合同");
        return  paramsCheckVO;
    }
    //施工合同参数控制
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(RentContractChangeVO vo) {
        CommonResponse<List<ParamsCheckVO>> response = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getContractId(), vo.getContractTaxMny(),vo.getOrgId());
        logger.info("施工合同控制信息返回："+JSONObject.toJSONString(response.getData()));
        if(!response.isSuccess()){
            throw new BusinessException("获取施工参数控制信息失败!"+response.getMsg());
        }
        return response.getData();
    }


    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(RentContractChangeVO changeVO) {
        logger.info("proequipment---RentContractChangeServiceImpl---historyPriceCtrlContractPrice()--- 历史价控合同价入参：{}", JSONObject.toJSONString(changeVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        List<RentChangeDayDetailedVO> dayDetailList = changeVO.getRentDayDetailedList();
        List<RentChangeMonthDetailedVO> monthDetailList = changeVO.getRentMonthDetailedList();
        List<RentChangeQuantitiesVO> quantitiesDetailList = changeVO.getRentQuantitiesDetailedList();

        maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MAX_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
        minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MIN_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("设备购置合同历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("设备购置合同历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        //todo 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.设备租赁价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.设备租赁价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (RentChangeDayDetailedVO  detailVO: dayDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDayRentPrice()==null ? BigDecimal.ZERO : detailVO.getDayRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//日租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("日租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("日租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                //月租
                for (RentChangeMonthDetailedVO  detailVO: monthDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getMonthRentPrice()==null ? BigDecimal.ZERO : detailVO.getMonthRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//月租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("月租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("月租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                //工程量租
                for (RentChangeQuantitiesVO  detailVO: quantitiesDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getQuantitiesPrice()==null ? BigDecimal.ZERO : detailVO.getQuantitiesPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//工程量租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("工程量租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("工程量租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (RentChangeDayDetailedVO  detailVO: dayDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDayRentPrice()==null ? BigDecimal.ZERO : detailVO.getDayRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//日租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("日租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("日租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                //月租
                for (RentChangeMonthDetailedVO  detailVO: monthDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getMonthRentPrice()==null ? BigDecimal.ZERO : detailVO.getMonthRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//月租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("月租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("月租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                //工程量租
                for (RentChangeQuantitiesVO  detailVO: quantitiesDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getQuantitiesPrice()==null ? BigDecimal.ZERO : detailVO.getQuantitiesPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//工程量租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("工程量租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("工程量租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }


    /**
     * 单据管控-累计变更金额大于合同金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMny(RentContractChangeVO vo) {
        BigDecimal changeMoney  = vo.getChangeMny()==null?BigDecimal.ZERO:vo.getChangeMny();
        BigDecimal contractTaxMny = vo.getBaseTaxMny()==null?BigDecimal.ZERO:vo.getBaseTaxMny();//初始合同金额
        BigDecimal totalChangeMoney =  changeMoney;//累计变更金额  默认赋值本次
        //查询累计变更金额
        QueryWrapper<RentContractChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", vo.getContractId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state",1,3);
        query.eq("signature_state",SignatureStatusEnum.已签章.getCode());
        List<RentContractChangeEntity> list = this.list(query);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(list)){
            for (RentContractChangeEntity changeEntity : list) {
                totalChangeMoney = ComputeUtil.safeAdd(changeEntity.getChangeMny(),totalChangeMoney);//累加变更金额
            }
        }
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("累计变更金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalChangeMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("变更超合同金额");
                        paramsCheckDsVO.setWarnName("累计变更金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次变更金额：").append(changeMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计变更金额：").append(totalChangeMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalChangeMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }


        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    /**
     * 单据管控-合同金额大于总计划金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(RentContractChangeVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal contractTaxMny = vo.getContractTaxMny()==null?BigDecimal.ZERO:vo.getContractTaxMny();//本次合同金额
        BigDecimal planTaxMny = BigDecimal.ZERO;//总计划金额
        BigDecimal totalMoney =  contractTaxMny;//累计合同金额  默认赋值本次
        //查询总计划
        LambdaQueryWrapper<RentTotalPlanEntity> planLambda = new LambdaQueryWrapper<>();
        planLambda.eq(RentTotalPlanEntity::getProjectId, vo.getProjectId());
        planLambda.in(RentTotalPlanEntity::getBillState,1,3);
        planLambda.eq(RentTotalPlanEntity::getDr,0);
        List<RentTotalPlanEntity> planList = rentTotalPlanService.list(planLambda);
        if(CollectionUtils.isNotEmpty(planList)){
            planTaxMny = planList.stream().filter(e -> e.getTemporaryAmount() != null).map(RentTotalPlanEntity::getTemporaryAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }else {
            return paramsCheckVOList;
        }
        //查询合同
        LambdaQueryWrapper<RentContractEntity> Lambda = new LambdaQueryWrapper<>();
        Lambda.eq(RentContractEntity::getProjectId, vo.getProjectId());
        Lambda.orderByDesc(RentContractEntity::getCreateTime);
        Lambda.ne(RentContractEntity::getId, vo.getContractId());//除本次
        List<RentContractEntity> list = rentContractService.list(Lambda);//查询项目下所有合同
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> collect = list.stream().map(RentContractEntity::getId).collect(Collectors.toList());
            List<RentContractChangeVO> contractChangeList = rentContractMapper.getRentContractChangeList(collect);//查询未生效的变更单
            Map<Long, RentContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(RentContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
            List<RentSettlementVO> settlementList = rentContractMapper.getRentSettlementList(collect);//查询最后一个结算单
            Map<Long, RentSettlementVO> mapSettle = settlementList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(RentSettlementVO::getContractId, item -> item, (v1, v2) -> v2));
            for (RentContractEntity entity : list) {
                BigDecimal zero = BigDecimal.ZERO;//要累加的金额
                if (ContractPerformanceStateEnum.已终止.getStateCode().equals(entity.getContractPerformanceState()) ||ContractPerformanceStateEnum.已作废.getStateCode().equals(entity.getContractPerformanceState())){
                    //合同已终止、已结束、已作废：取合同结算金额）  即最终结算或 最后一次结算  累计结算金额
                    if(mapSettle.containsKey(entity.getId())){
                        zero = mapSettle.get(entity.getId()).getCurrentSettlementTaxMny();
                    }// 校验变更合同
                }else if(mapChange.containsKey(entity.getId())){//有为生效的变更单  取最新变更单金额
                    zero = mapChange.get(entity.getId()).getContractTaxMny();
                } else {//没有未生效的变更单   合同状态为 未签订、履约中、已冻结取签订金额
                    zero = entity.getContractTaxMny();
                }
                totalMoney = ComputeUtil.safeAdd(zero,totalMoney);//累加变更金额
            }
        }
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PLAN_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PLAN_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总计划金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(planTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("租赁金额超总计划金额");
                        paramsCheckDsVO.setWarnName("租赁金额超总计划金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次合同金额：").append(contractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计合同金额：").append(totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，总计划金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    @Override
    public Map queryChangeCompare(Long id) {
          /*
            当前变更合同如果未提交，则和主合同对比
            如果提交，则和合同记录表对比
         */
        RentContractChangeEntity changeEntity = super.selectById(id);
        RentContractChangeVO changeCompareVO = BeanMapper.map(changeEntity, RentContractChangeVO.class);
        RentContractEntity contractEntity = rentContractService.selectById(changeEntity.getContractId());

        RentContractChangeVO beforeChangeVO = new RentContractChangeVO();
        boolean flag = false;
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            // 若变更单已审批通过，则查询最新的合同记录
            LambdaQueryWrapper<RentContractRecordEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(RentContractRecordEntity::getChangeId, id);
            wrapper.eq(RentContractRecordEntity::getContractId, changeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);

            List<RentContractRecordEntity> recordEntityList = contractRecordService.list(wrapper);
            if (ListUtil.isNotEmpty(recordEntityList)) {
                beforeChangeVO = BeanMapper.map(contractRecordService.selectById(recordEntityList.get(0).getId()), RentContractChangeVO.class);
            }
        }else {
            beforeChangeVO = BeanMapper.map(contractEntity, RentContractChangeVO.class);
            flag = true;
        }

        Map<String, Object> returnMap = new HashMap<>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            // 日租
            if (ListUtil.isNotEmpty(changeCompareVO.getRentDayDetailedList())) {
                List<RentChangeDayDetailedVO> dailyRentList = beforeChangeVO.getRentDayDetailedList();
                Map<Long, RentChangeDayDetailedVO> beforeDailyMap = new HashMap<>();
                if (flag) {
                    beforeDailyMap = dailyRentList.stream().collect(Collectors.toMap(RentChangeDayDetailedVO::getId, Function.identity()));
                }else {
                    beforeDailyMap = dailyRentList.stream().collect(Collectors.toMap(RentChangeDayDetailedVO::getSrcTblId, Function.identity()));
                }

                for (RentChangeDayDetailedVO vo : changeCompareVO.getRentDayDetailedList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        RentChangeDayDetailedVO beforeVO = beforeDailyMap.get(vo.getSrcTblId());
                        vo.setBcDayFactoryCode(beforeVO.getDayFactoryCode());
                        vo.setBcDayRentPrice(beforeVO.getDayRentPrice());
                        vo.setBcStopRentPrice(beforeVO.getStopRentPrice());
                        vo.setBcRentNum(beforeVO.getRentNum());
                        vo.setBcTax(beforeVO.getTax());
                        vo.setBcDayRentNotTaxPrice(beforeVO.getDayRentNotTaxPrice());
                        vo.setBcStopRentNotTaxPrice(beforeVO.getStopRentNotTaxPrice());
                        vo.setBcPlanIntoDate(beforeVO.getPlanIntoDate());
                        vo.setBcPlanOutDate(beforeVO.getPlanOutDate());
                        vo.setBcProductionManufactor(beforeVO.getProductionManufactor());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcTaxMny(beforeVO.getTaxMny());
                        vo.setBcRentDay(beforeVO.getRentDay());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                        vo.setBcTaxMoney(beforeVO.getTaxMoney());

                    }
                }

                changeCompareVO.setRentDayDetailedList(changeCompareVO.getRentDayDetailedList().stream().filter(daily -> StringUtils.isNotEmpty(daily.getChangeType())).collect(Collectors.toList()));
            }
            // 月租
            if (ListUtil.isNotEmpty(changeCompareVO.getRentMonthDetailedList())) {
                List<RentChangeMonthDetailedVO> monthRentList = beforeChangeVO.getRentMonthDetailedList();
                Map<Long, RentChangeMonthDetailedVO> beforeMonthMap = new HashMap<>();
                if (flag) {
                    beforeMonthMap = monthRentList.stream().collect(Collectors.toMap(RentChangeMonthDetailedVO::getId, Function.identity()));
                }else {
                    beforeMonthMap = monthRentList.stream().collect(Collectors.toMap(RentChangeMonthDetailedVO::getSrcTblId, Function.identity()));
                }

                for (RentChangeMonthDetailedVO vo : changeCompareVO.getRentMonthDetailedList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        RentChangeMonthDetailedVO beforeVO = beforeMonthMap.get(vo.getSrcTblId());

                        vo.setBcMonthFactoryCode(beforeVO.getMonthFactoryCode());
                        vo.setBcMonthRentPrice(beforeVO.getMonthRentPrice());
                        vo.setBcInsufficientMonthDayRentPrice(beforeVO.getInsufficientMonthDayRentPrice());
                        vo.setBcStopRentPrice(beforeVO.getStopRentPrice());
                        vo.setBcRentNum(beforeVO.getRentNum());
                        vo.setBcTax(beforeVO.getBcTax());
                        vo.setBcMonthRentNotTaxPrice(beforeVO.getMonthRentNotTaxPrice());
                        vo.setBcInsufficientMonthNotTaxRentPrice(beforeVO.getInsufficientMonthNotTaxRentPrice());
                        vo.setBcPlanIntoDate(beforeVO.getPlanIntoDate());
                        vo.setPlanOutDate(beforeVO.getPlanOutDate());
                        vo.setBcProductionManufactor(beforeVO.getProductionManufactor());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcEquipmentCode(beforeVO.getEquipmentCode());
                        vo.setBcDayTaxPrice(beforeVO.getDayTaxPrice());
                        vo.setBcTaxMny(beforeVO.getTaxMny());
                        vo.setBcNotTaxMonthPrice(beforeVO.getNotTaxMonthPrice());
                        vo.setBcDayRentNotTaxPrice(beforeVO.getDayRentNotTaxPrice());
                        vo.setBcNotTaxStopPrice(beforeVO.getNotTaxStopPrice());
                        vo.setBcRentMonth(beforeVO.getRentMonth());
                        vo.setBcRentDay(beforeVO.getRentDay());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                        vo.setBcTaxMoney(beforeVO.getTaxMoney());
                    }
                }

                changeCompareVO.setRentMonthDetailedList(changeCompareVO.getRentMonthDetailedList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }
            // 工程量
            if (ListUtil.isNotEmpty(changeCompareVO.getRentQuantitiesDetailedList())) {
                List<RentChangeQuantitiesVO> quantitiesRentList = beforeChangeVO.getRentQuantitiesDetailedList();
                Map<Long, RentChangeQuantitiesVO> beforeQuantitiesMap = new HashMap<>();
                if (flag) {
                    beforeQuantitiesMap = quantitiesRentList.stream().collect(Collectors.toMap(RentChangeQuantitiesVO::getId, Function.identity()));
                }else {
                    beforeQuantitiesMap = quantitiesRentList.stream().collect(Collectors.toMap(RentChangeQuantitiesVO::getSrcTblId, Function.identity()));
                }

                for (RentChangeQuantitiesVO vo : changeCompareVO.getRentQuantitiesDetailedList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        RentChangeQuantitiesVO beforeVO = beforeQuantitiesMap.get(vo.getSrcTblId());

                        vo.setBcQuantitiesFactoryCode(beforeVO.getQuantitiesFactoryCode());
                        vo.setBcQuantitiesNum(beforeVO.getQuantitiesNum());
                        vo.setBcQuantitiesPrice(beforeVO.getQuantitiesPrice());
                        vo.setBcRentNum(beforeVO.getRentNum());
                        vo.setBcTax(beforeVO.getTax());
                        vo.setBcPlanIntoDate(beforeVO.getPlanIntoDate());
                        vo.setBcPlanOutDate(beforeVO.getPlanOutDate());
                        vo.setBcProductionManufactor(beforeVO.getProductionManufactor());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcNotTaxQuantitiesPrice(beforeVO.getNotTaxQuantitiesPrice());
                        vo.setBcNotTaxQuantitiesMny(beforeVO.getNotTaxQuantitiesMny());
                        vo.setBcRentMny(beforeVO.getRentMny());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                        vo.setBcTaxMoney(beforeVO.getTaxMoney());
                    }
                }

                changeCompareVO.setRentQuantitiesDetailedList(changeCompareVO.getRentQuantitiesDetailedList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }
            // 其他
            if (ListUtil.isNotEmpty(changeCompareVO.getRentOtherDetailedList())) {
                List<RentChangeOtherDetailedVO> otherRentList = beforeChangeVO.getRentOtherDetailedList();
                Map<Long, RentChangeOtherDetailedVO> beforeOtherMap = new HashMap<>();
                if (flag) {
                    beforeOtherMap = otherRentList.stream().collect(Collectors.toMap(RentChangeOtherDetailedVO::getId, Function.identity()));
                }else {
                    beforeOtherMap = otherRentList.stream().collect(Collectors.toMap(RentChangeOtherDetailedVO::getSrcTblId, Function.identity()));
                }

                for (RentChangeOtherDetailedVO vo : changeCompareVO.getRentOtherDetailedList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        RentChangeOtherDetailedVO beforeVO = beforeOtherMap.get(vo.getSrcTblId());
                        vo.setBcPrice(beforeVO.getPrice());
                        vo.setBcNum(beforeVO.getNum());
                        vo.setBcTaxAmount(beforeVO.getTaxAmount());
                        vo.setBcNotTaxPrice(beforeVO.getNotTaxPrice());
                        vo.setBcNotTaxAmount(beforeVO.getNotTaxAmount());
                        vo.setBcMemo(beforeVO.getBcMemo());
                        vo.setBcTaxMoney(beforeVO.getTaxMoney());
                    }
                }

                changeCompareVO.setRentOtherDetailedList(changeCompareVO.getRentOtherDetailedList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }
            // 设置合同付款阶段
            if (ListUtil.isNotEmpty(changeCompareVO.getRentContractPaymentClauseList())) {
                List<RentChangeContractPaymentVO> otherRentList = beforeChangeVO.getRentContractPaymentClauseList();
                Map<Long, RentChangeContractPaymentVO> beforeOtherMap = new HashMap<>();
                if (flag) {
                    beforeOtherMap = otherRentList.stream().collect(Collectors.toMap(RentChangeContractPaymentVO::getId, Function.identity()));
                }else {
                    beforeOtherMap = otherRentList.stream().collect(Collectors.toMap(RentChangeContractPaymentVO::getSrcTblId, Function.identity()));
                }

                for (RentChangeContractPaymentVO vo : changeCompareVO.getRentContractPaymentClauseList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        RentChangeContractPaymentVO beforeVO = beforeOtherMap.get(vo.getSrcTblId());
                        vo.setBcName(beforeVO.getName());
                        vo.setBcPaymentContent(beforeVO.getPaymentContent());
                        vo.setBcPaymentRatio(beforeVO.getPaymentRatio());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setChangeType("2");
                    }
                }

                changeCompareVO.setRentContractPaymentClauseList(changeCompareVO.getRentContractPaymentClauseList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }

            // 设置合同条款
            if (ListUtil.isNotEmpty(changeCompareVO.getRentContractClauseList())) {
                List<RentChangeContractClauseVO> otherRentList = beforeChangeVO.getRentContractClauseList();
                Map<Long, RentChangeContractClauseVO> beforeOtherMap = new HashMap<>();
                if (flag) {
                    beforeOtherMap = otherRentList.stream().collect(Collectors.toMap(RentChangeContractClauseVO::getId, Function.identity()));
                }else {
                    beforeOtherMap = otherRentList.stream().collect(Collectors.toMap(RentChangeContractClauseVO::getSrcTblId, Function.identity()));
                }

                for (RentChangeContractClauseVO vo : changeCompareVO.getRentContractClauseList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        RentChangeContractClauseVO beforeVO = beforeOtherMap.get(vo.getSrcTblId());
                        vo.setBcName(beforeVO.getName());
                        vo.setBcName(beforeVO.getName());
                        vo.setBcClauseContent(beforeVO.getClauseContent());
                        vo.setChangeType("2");
                    }
                }

                changeCompareVO.setRentContractClauseList(changeCompareVO.getRentContractClauseList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }


            //设置合同条款
//            List<RentChangeContractClauseVO> newClauses = new ArrayList<>();
//            Map<Long, RentChangeContractClauseVO> beforeClauseMap = new HashMap<>();
//            if (flag) {
//                beforeClauseMap = beforeChangeVO.getRentContractClauseList().stream().collect(Collectors.toMap(RentChangeContractClauseVO::getId, clause -> clause, (v1,v2) ->v2));
//            }else {
//                beforeClauseMap = beforeChangeVO.getRentContractClauseList().stream().collect(Collectors.toMap(RentChangeContractClauseVO::getSrcTblId, clause -> clause, (v1,v2) ->v2));
//            }
//            if(ListUtil.isNotEmpty(changeCompareVO.getRentContractClauseList())) {
//                RentChangeContractClauseVO beforeVo = null;
//                for (RentChangeContractClauseVO vo : changeCompareVO.getRentContractClauseList()) {
//                    if(vo.getSrcTblId() == null) {
//                        // 没有来源则说明为新增项
//                        vo.setChangeType("0");
//                        newClauses.add(vo);
//                    } else if(beforeClauseMap.containsKey(vo.getSrcTblId())) {
//                        beforeVo = beforeClauseMap.get(vo.getSrcTblId());
//                        if (!Objects.equals(beforeVo.getClauseNameId(), vo.getClauseNameId()) || !Objects.equals(beforeVo.getClauseContent(), vo.getClauseContent())) {
//                            // 参照变更
//                            vo.setBcName(beforeVo.getName());
//                            vo.setBcClauseContent(beforeVo.getClauseContent());
//                            vo.setChangeType("2");
//                            newClauses.add(vo);
//                        }else {
////                            newClauses.add(vo);
//                        }
//
//                        beforeClauseMap.remove(vo.getSrcTblId());
//                    }
//                }
//            }
//            if(MapUtils.isNotEmpty(beforeClauseMap)) {
//                //若原始条款有剩余项，则说这些项变更时被删除
//                beforeClauseMap.values().forEach(c -> {
//                    c.setChangeType("1");
//                    newClauses.add(c);
//                });
//            }


//            // 设置合同付款阶段
//            List<RentChangeContractPaymentVO> newPayList = new ArrayList<>();
//            Map<Long, RentChangeContractPaymentVO> beforePayMap = new HashMap<>();
//            if (flag) {
//                beforePayMap = beforeChangeVO.getRentContractPaymentClauseList().stream().collect(Collectors.toMap(RentChangeContractPaymentVO::getId, item -> item, (v1, v2) -> v2));
//            }else {
//                beforePayMap = beforeChangeVO.getRentContractPaymentClauseList().stream().collect(Collectors.toMap(RentChangeContractPaymentVO::getSrcTblId, item -> item, (v1, v2) -> v2));
//            }
//            if (ListUtil.isNotEmpty(changeCompareVO.getRentContractPaymentClauseList())) {
//                RentChangeContractPaymentVO beforeVo = null;
//                for (RentChangeContractPaymentVO vo : changeCompareVO.getRentContractPaymentClauseList()) {
//
//                    if (vo.getSrcTblId() == null) {
//                        //没有来源则说明为新增项
//                        vo.setChangeType("0");
//                        newPayList.add(vo);
//                    } else if (beforePayMap.containsKey(vo.getSrcTblId())) {
//                        beforeVo = beforePayMap.get(vo.getSrcTblId());
//                        if (!beforeVo.getName().equals(vo.getName()) || !beforeVo.getPaymentRatio().equals(vo.getPaymentRatio())) {
//                            vo.setBcName(beforeVo.getName());
//                            vo.setBcPaymentContent(beforeVo.getPaymentContent());
//                            vo.setBcPaymentRatio(beforeVo.getPaymentRatio());
//                            vo.setBcMemo(beforeVo.getMemo());
//                            vo.setChangeType("2");
//                            newPayList.add(vo);
//                        }
//                        beforePayMap.remove(vo.getSrcTblId());
//                    }
//                }
//
//            }
//            if(MapUtils.isNotEmpty(beforePayMap)) {
//                //若原始条款有剩余项，则说这些项变更时被删除
//                beforePayMap.values().forEach(c -> {
//                    c.setChangeType("1");
//                    newPayList.add(c);
//                });
//            }
//            changeCompareVO.setRentContractPaymentClauseList(newPayList);


//            changeCompareVO.setRentContractClauseList(newClauses);
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
            }

        return returnMap;
    }

    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    @Override
    public void asyncWatermarkById(Long id) {
        RentContractChangeEntity changeEntity = super.selectById(id);
        logger.info("开始获取水印参数信息，变更合同id：{}--------", id);
        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        logger.info("获取水印系统参数请求结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            String billType = "BT220303000000001";
            String sourceType = "equipmentRent";
            // 转换水印参数配置：默认规则
            WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(),
                    changeEntity.getCode(), billType, sourceType);
            Assert.notNull(watermarkVO, "获取水印系统参数失败!");
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            contractChangeAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }

    /**
     * 删除目标成本
     * @param targetCost
     */
    public void deleteTargetCost(ExecutionVO targetCost) {
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();

        totalExecutionVOList.add(targetCost.getTotalVO());
        logger.info("删除目标成本："+JSONObject.toJSONString(totalExecutionVOList));
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()){
            throw new BusinessException("删除旧目标成本失败！");
        }
    }

    @Override
    public RentContractChangeEntity queryChangeList(RentContractChangeEntity entity) {
        // 查询变更记录
        LambdaQueryWrapper<RentContractChangeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RentContractChangeEntity::getContractId, entity.getMainContractId());
        if (entity.getId() != null) {
            wrapper.ne(RentContractChangeEntity::getId, entity.getId());
        }
        wrapper.orderByDesc(RentContractChangeEntity::getCreateTime);
        List<RentContractChangeEntity> list = this.list(wrapper);

        if (ListUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }
}
