package com.ejianc.business.temporary.userecord.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.promaterial.check.api.ICheckApi;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.settlement.api.IProMaterialSettleApi;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementEntity;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.business.temporary.userecord.vo.SupTemporaryUseRecordSubVO;
import com.ejianc.business.temporary.userecord.vo.SupTemporaryUseRecordVO;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;
import com.ejianc.business.userecord.bean.UseRecordEntity;
import com.ejianc.business.userecord.vo.SupUseRecordSubVO;
import com.ejianc.business.userecord.vo.SupUseRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.temporary.userecord.mapper.TemporaryUseRecordMapper;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordService;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;

/**
 * 临时设备使用记录表
 * 
 * @author generator
 * 
 */
@Service("temporaryUseRecordService")
public class TemporaryUseRecordServiceImpl extends BaseServiceImpl<TemporaryUseRecordMapper, TemporaryUseRecordEntity> implements ITemporaryUseRecordService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private JedisPool jedisPool;
    private final String  OPERATE= "LS_USE_RECORD";
    //TODO  待修改
    private static final String BILL_TYPE = "BT220302000000007";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/temporaryUseRecord/saveTemporaryUseRecord";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/temporaryUseRecord/deleteTemporaryUseRecord";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ICheckApi checkApi;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;

    //参数控制编码
    private static final String CHECK_MNY_CON_CODE = "P-c791wU0144";//【施工合同金额】控【无合同验收、零星机械金额】
    private static final String CHECK_MNY_CODE = "P-40M28D0135";//单次临时设备使用记录金额控制
    private static final String CHECK_MNY_SUP_CODE = "P-552cZM0136";//单个供应商临时设备使用记录金额控制

    @Override
    public IPage<TemporaryUseRecordVO> queryData(QueryParam param) {
        IPage<TemporaryUseRecordVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<TemporaryUseRecordVO> list = baseMapper.queryData(changeToQueryWrapper(param), page);
        IPage<TemporaryUseRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

    @Override
    public boolean pushBillToSupCenter(TemporaryUseRecordEntity entity, String billTypeCode) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupTemporaryUseRecordVO supVO = BeanMapper.map(entity, SupTemporaryUseRecordVO.class);
            List<SupTemporaryUseRecordSubVO> supDetailVOS = BeanMapper.mapList(entity.getTemporaryUseRecordSubList(), SupTemporaryUseRecordSubVO.class);
            supVO.setTemporaryUseRecordSubList(supDetailVOS);
            paramMap.put("transData", JSONObject.toJSONString(supVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), billTypeCode, "projectMangerSign", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送附件参数-{}", entity.getSupplierId(), JSONObject.toJSONString(files));
                logger.info("向供应商-{}推送计量单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSupplierId().toString(),
                        files);
//                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                logger.error("获取单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSupplierId(), e);
//            throw e;
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(TemporaryUseRecordEntity entity, String billTypeCode) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());
        entity.setNotSignature(0);
        baseMapper.updateById(entity);
        logger.info("修改签字信息：{}", JSONObject.toJSONString(entity));
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", entity.getSupplierId(), entity.getId());
            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DELPUSH_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", entity.getId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }
    /*供方签字确认*/
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        TemporaryUseRecordEntity entity = super.selectById(billId);
        //设置供方签字信息
        entity.setSupOperateTime(supOperateTime);
        entity.setSupOperatorName(supOperatorName);
        entity.setSupOperatorPhone(supOperatorPhone);
        entity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + entity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", entity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, entity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            entity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：0-未签字 1-已签字
            entity.setNotSignature(1);
            //更新单据
            super.saveOrUpdate(entity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", entity.getId(), e);
            msg = "单据签字信息回写失败！";
            throw e;
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(TemporaryUseRecordVO vo){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*参数控制区域*/
        if(CollectionUtils.isNotEmpty(this.checkParamsMny(vo))){//单次临时设备使用记录金额控制
            paramsCheckVOS.addAll(this.checkParamsMny(vo));
        }
        if(CollectionUtils.isNotEmpty(this.checkParamsSupplierMny(vo))){//单个供应商临时设备使用记录金额控制*/
            paramsCheckVOS.addAll(this.checkParamsSupplierMny(vo));
        }
        if(CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){//【施工合同金额】控【无合同验收、零星机械金额】*/
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        /*--end---参数控制区域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    /*
     * 单次临时设备使用记录金额控制*/
    @Override
    public  List<ParamsCheckVO> checkParamsMny(TemporaryUseRecordVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("单次临时设备使用记录金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    BigDecimal mny = null==vo.getUseMny()?BigDecimal.ZERO:vo.getUseMny();//本次使用金额
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("本次使用金额超过限定金额");
                        paramsCheckDsVO.setWarnName("单次临时使用记录金额超限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(mny, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    /*
     * 单个供应商临时设备使用记录金额控制*/
    @Override
    public  List<ParamsCheckVO> checkParamsSupplierMny(TemporaryUseRecordVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal mny = null==vo.getUseMny()?BigDecimal.ZERO:vo.getUseMny();//本次使用金额
        LambdaQueryWrapper<TemporaryUseRecordEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TemporaryUseRecordEntity::getSupplierId, vo.getSupplierId());
        wrapper.eq(TemporaryUseRecordEntity::getProjectId, vo.getProjectId());
        if(null!=vo.getId()){
            wrapper.ne(TemporaryUseRecordEntity::getId, vo.getId());
        }
        List<TemporaryUseRecordEntity> list = super.list(wrapper);
        //根据供应商和项目汇总所有金额
        BigDecimal totalMny = list.stream().filter(e -> e.getUseMny() != null).map(TemporaryUseRecordEntity::getUseMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalMny = ComputeUtil.safeAdd(totalMny,mny);//相加本次
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_SUP_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("单个供应商临时设备使用记录金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值

                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("供应商零星机械费用超过限定金额");
                        paramsCheckDsVO.setWarnName("供应商零星机械费用超过限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMny, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }
    /*
     * 【施工合同金额】控【无合同验收、零星机械金额】*/
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(TemporaryUseRecordVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;//施工合同金额
        BigDecimal mny = null==vo.getUseMny()?BigDecimal.ZERO:vo.getUseMny();//本次使用金额
        BigDecimal totalMny = mny;//无合同验收金额+临时设备金额   默认赋值本次金额
        //根据项目查询该项目下所有状态的 临时设备记录使用金额累计
        LambdaQueryWrapper<TemporaryUseRecordEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TemporaryUseRecordEntity::getProjectId, vo.getProjectId());
        if(null!=vo.getId()){
            wrapper.ne(TemporaryUseRecordEntity::getId, vo.getId());
        }
        List<TemporaryUseRecordEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            BigDecimal totalUseMny = list.stream().filter(e -> null!=e.getUseMny()).map(TemporaryUseRecordEntity::getUseMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd(totalMny,totalUseMny);//累加临时设备记录使用金额
        }
        //根据项目查询该项目下所有状态的【无合同材料验收+无合同混凝土验收】
        CommonResponse<JSONObject> response = checkApi.queryCheckMnyProjectId(vo.getProjectId());
        logger.info("该项目：{}-下所有状态的【无合同材料验收+无合同混凝土验收】金额结果:{}",vo.getProjectId(),JSONObject.toJSONString(response));
        if(response.isSuccess() && null!=response.getData()){
            BigDecimal checkTaxMny = response.getData().getBigDecimal("checkTaxMny");
            totalMny = ComputeUtil.safeAdd(totalMny,checkTaxMny);//累加 无合同材料验收+无合同混凝土验收 金额
        }
        //根据项目查询施工合同金额
        CommonResponse<ContractRegisterVO> commonResponse = proincomeContrantApi.queryContranctMny(vo.getProjectId());
        logger.info("该项目:{}-下生效的最新正式施工合同:{}",vo.getProjectId(),JSONObject.toJSONString(commonResponse));
        if(commonResponse.isSuccess() && null!=commonResponse.getData()){
            contractTaxMny = null==commonResponse.getData().getContractTaxMny() ? BigDecimal.ZERO : commonResponse.getData().getContractTaxMny();
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("单个供应商临时租赁结算金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    //施工合同百分比 后的金额
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("无合同验收、临机费用超施工合同额");
                        paramsCheckDsVO.setWarnName("无合同验收、临机费用累计金额超施工合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次零材、零机发生金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }
}
