/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pricelib.service.impl;

import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.pricelib.bean.RentPriceContractCollectEntity;
import com.ejianc.business.pricelib.bean.RentPriceContractEntity;
import com.ejianc.business.pricelib.bean.RentPriceGuideDetailEntity;
import com.ejianc.business.pricelib.mapper.RentPriceContractCollectMapper;
import com.ejianc.business.pricelib.service.IRentPriceContractCollectService;
import com.ejianc.business.pricelib.service.IRentPriceContractService;
import com.ejianc.business.pricelib.service.IRentPriceGuideDetailService;
import com.ejianc.business.pricelib.vo.RentPriceContractCollectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentPriceContractCollectService")
public class RentPriceContractCollectServiceImpl
extends BaseServiceImpl<RentPriceContractCollectMapper, RentPriceContractCollectEntity>
implements IRentPriceContractCollectService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentPriceContractService rentPriceContractService;
    @Autowired
    private IRentPriceGuideDetailService rentPriceGuideDetailService;

    @Override
    public void savePriceContractToHistoryByTiming() {
        this.logger.info("---\u5386\u53f2\u4ef7\u683cinit\u5f00\u59cb---");
        this.logger.info("---\u6570\u636e\u5168\u5220\u9664\u64cd\u4f5c\u5f00\u59cb---");
        ((RentPriceContractCollectMapper)this.baseMapper).delPriceContractCollectAll();
        this.logger.info("---\u6570\u636e\u63d2\u5165\u64cd\u4f5c\u5f00\u59cb---");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("outFlag", new Parameter("eq", (Object)0));
        queryParam.getParams().put("performanceStatus", new Parameter("in", Arrays.asList(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode(), ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode(), ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode(), ContractPerformanceStateEnum.\u5df2\u7ed3\u675f.getStateCode())));
        List priceContractList = this.rentPriceContractService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)priceContractList)) {
            return;
        }
        ArrayList<RentPriceContractCollectEntity> priceContractCollectList = new ArrayList<RentPriceContractCollectEntity>();
        Map<Long, Map<Integer, List<RentPriceContractEntity>>> priceContractMap = priceContractList.stream().collect(Collectors.groupingBy(RentPriceContractEntity::getDocId, Collectors.groupingBy(RentPriceContractEntity::getRentType)));
        for (Map.Entry<Long, Map<Integer, List<RentPriceContractEntity>>> entry : priceContractMap.entrySet()) {
            Map<Integer, List<RentPriceContractEntity>> rentPriceContractEntityDocMap = entry.getValue();
            for (Map.Entry<Integer, List<RentPriceContractEntity>> rentTypeEntry : rentPriceContractEntityDocMap.entrySet()) {
                List<RentPriceContractEntity> value = rentTypeEntry.getValue();
                List priceList = value.stream().map(RentPriceContractEntity::getContractPrice).collect(Collectors.toList());
                List taxPriceList = value.stream().map(RentPriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                RentPriceContractEntity priceContract = value.get(0);
                if (priceContract == null) continue;
                BigDecimal maxPrice = ((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4);
                BigDecimal minPrice = ((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4);
                String priceArea = minPrice + "-" + maxPrice;
                BigDecimal taxMaxPrice = ((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
                BigDecimal taxMinPrice = ((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
                String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
                RentPriceContractCollectEntity rentPriceContractCollectEntity = new RentPriceContractCollectEntity();
                rentPriceContractCollectEntity.setDocId(priceContract.getDocId());
                rentPriceContractCollectEntity.setDocCode(priceContract.getDocCode());
                rentPriceContractCollectEntity.setDocName(priceContract.getDocName());
                rentPriceContractCollectEntity.setDocCategoryId(priceContract.getDocCategoryId());
                rentPriceContractCollectEntity.setDocCategoryName(priceContract.getDocCategoryName());
                rentPriceContractCollectEntity.setDocInnerCode(priceContract.getDocInnerCode());
                rentPriceContractCollectEntity.setUnitId(priceContract.getUnitId());
                rentPriceContractCollectEntity.setUnitName(priceContract.getUnitName());
                rentPriceContractCollectEntity.setPriceTypeName(priceContract.getPriceTypeName());
                rentPriceContractCollectEntity.setRentType(priceContract.getRentType());
                rentPriceContractCollectEntity.setContractMaxPrice(maxPrice);
                rentPriceContractCollectEntity.setContractMinPrice(minPrice);
                rentPriceContractCollectEntity.setContractPriceArea(priceArea);
                rentPriceContractCollectEntity.setContractTaxMaxPrice(taxMaxPrice);
                rentPriceContractCollectEntity.setContractTaxMinPrice(taxMinPrice);
                rentPriceContractCollectEntity.setContractTaxPriceArea(taxPriceArea);
                priceContractCollectList.add(rentPriceContractCollectEntity);
            }
        }
        this.logger.info("\u4fdd\u5b58\u6570\u636e\u5927\u5c0f{}\u6761", (Object)priceContractCollectList.size());
        super.saveOrUpdateBatch(priceContractCollectList);
        this.logger.info("---\u6570\u636e\u63d2\u5165\u64cd\u4f5c\u7ed3\u675f---");
    }

    @Override
    public List<RentPriceContractCollectVO> getPriceContractByDocIds(List<Long> docIds, Integer rentType) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("docId", new Parameter("in", docIds));
        queryParam.getParams().put("rentType", new Parameter("eq", (Object)rentType));
        List priceContractCollectVOList = BeanMapper.mapList((Iterable)super.queryList(queryParam), RentPriceContractCollectVO.class);
        List<RentPriceContractCollectVO> guideDetailList = this.getGuidePriceAreaByDocIds(docIds);
        if (CollectionUtils.isNotEmpty(guideDetailList)) {
            Map guidePriceMap = guideDetailList.stream().collect(Collectors.toMap(RentPriceContractCollectVO::getDocId, Function.identity(), (key1, key2) -> key2));
            if (CollectionUtils.isNotEmpty((Collection)priceContractCollectVOList)) {
                for (RentPriceContractCollectVO rentPriceContractCollectVO : priceContractCollectVOList) {
                    if (!guidePriceMap.containsKey(rentPriceContractCollectVO.getDocId())) continue;
                    rentPriceContractCollectVO.setGuidePriceArea(((RentPriceContractCollectVO)guidePriceMap.get(rentPriceContractCollectVO.getDocId())).getGuidePriceArea());
                    rentPriceContractCollectVO.setGuideTaxPriceArea(((RentPriceContractCollectVO)guidePriceMap.get(rentPriceContractCollectVO.getDocId())).getGuideTaxPriceArea());
                    guidePriceMap.remove(rentPriceContractCollectVO.getDocId());
                }
            }
            if (guidePriceMap != null) {
                guidePriceMap.keySet().stream().forEach(key -> {
                    RentPriceContractCollectVO rentPriceContractCollectVO = new RentPriceContractCollectVO();
                    rentPriceContractCollectVO.setDocId(((RentPriceContractCollectVO)guidePriceMap.get(key)).getDocId());
                    rentPriceContractCollectVO.setGuidePriceArea(((RentPriceContractCollectVO)guidePriceMap.get(key)).getGuidePriceArea());
                    rentPriceContractCollectVO.setGuideTaxPriceArea(((RentPriceContractCollectVO)guidePriceMap.get(key)).getGuideTaxPriceArea());
                    priceContractCollectVOList.add(rentPriceContractCollectVO);
                });
            }
        }
        return priceContractCollectVOList;
    }

    @Override
    public List<RentPriceContractCollectVO> getGuidePriceAreaByDocIds(List<Long> docIds) {
        List<RentPriceGuideDetailEntity> list = this.rentPriceGuideDetailService.queryPriceGuideDetailByDocIds(docIds);
        ArrayList<RentPriceContractCollectVO> PriceContractCollectVOList = new ArrayList<RentPriceContractCollectVO>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)) {
            for (RentPriceGuideDetailEntity guide : list) {
                RentPriceContractCollectVO rentPriceContractCollectVO = new RentPriceContractCollectVO();
                BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
                BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
                min = min.divide(BigDecimal.ONE, 4, 4);
                max = max.divide(BigDecimal.ONE, 4, 4);
                rentPriceContractCollectVO.setGuidePriceArea(min + "-" + max);
                min = guide.getMinTaxPrice() == null ? BigDecimal.ZERO : guide.getMinTaxPrice();
                max = guide.getMaxTaxPrice() == null ? BigDecimal.ZERO : guide.getMaxTaxPrice();
                min = min.divide(BigDecimal.ONE, 4, 4);
                max = max.divide(BigDecimal.ONE, 4, 4);
                rentPriceContractCollectVO.setGuideTaxPriceArea(min + "-" + max);
                rentPriceContractCollectVO.setDocId(guide.getDocId());
                PriceContractCollectVOList.add(rentPriceContractCollectVO);
            }
        }
        return PriceContractCollectVOList;
    }
}

