/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentRentalEntity;
import com.ejianc.business.rent.bean.RentSettlementDayEntity;
import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.rent.bean.RentSettlementFeeEntity;
import com.ejianc.business.rent.bean.RentSettlementFragmentaryEntity;
import com.ejianc.business.rent.bean.RentSettlementMonthEntity;
import com.ejianc.business.rent.bean.RentSettlementQuantitiesEntity;
import com.ejianc.business.rent.bean.RentSettlementRentalEntity;
import com.ejianc.business.rent.mapper.RentSettlementMapper;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentSettlementFragmentaryService;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.business.rent.vo.RentSettleRecordVO;
import com.ejianc.business.rent.vo.RentSettlementVO;
import com.ejianc.business.rent.vo.SupRentSettlementDayVO;
import com.ejianc.business.rent.vo.SupRentSettlementFeeVO;
import com.ejianc.business.rent.vo.SupRentSettlementMonthVO;
import com.ejianc.business.rent.vo.SupRentSettlementQuantitiesVO;
import com.ejianc.business.rent.vo.SupRentSettlementRentalVO;
import com.ejianc.business.rent.vo.SupRentSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordSubEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordSubService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="rentSettlementService")
public class RentSettlementServiceImpl
extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity>
implements IRentSettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE_GC = "P-5kO0W220";
    private static final String CHECK_PARAM_CODE_ZZ = "P-Zez9060156";
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "RENT_SETTLE";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ITemporaryUseRecordSubService temporaryUseRecordSubService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRentSettlementFragmentaryService rentSettlementFragmentaryService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private RentSettlementMapper rentSettlementMapper;
    private final String OPERATE = "RENT_SETTLE_JS";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/rentSettlement/saveRentSettlement";
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/rentSettlement/deleteRentSettlement";
    private static final String BILL_TYPE = "EJCBT202204000006";

    @Override
    public RentSettlementVO saveOrUpdate(RentSettlementVO saveOrUpdateVO) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentSettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
            entity.setSignStatus(0);
            entity.setSignatureStatus(0);
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        if (null != entity.getContractId() && this.queryExist(entity.getContractId(), entity.getId())) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355\uff01");
        }
        List<RentSettlementFragmentaryEntity> rentSettlementFragmentaryList = entity.getRentSettlementFragmentaryList();
        if (CollectionUtils.isNotEmpty(rentSettlementFragmentaryList)) {
            ArrayList<Long> addLong = new ArrayList<Long>();
            ArrayList<Long> delLong = new ArrayList<Long>();
            for (RentSettlementFragmentaryEntity fragmentaryEntity : rentSettlementFragmentaryList) {
                if ("del".equals(fragmentaryEntity.getRowState())) {
                    delLong.add(fragmentaryEntity.getSourceId());
                    continue;
                }
                addLong.add(fragmentaryEntity.getSourceId());
            }
            this.updateSettleFlag(addLong, true);
            this.updateSettleFlag(delLong, false);
        }
        super.saveOrUpdate((Object)entity, false);
        RentSettlementVO vo = (RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class);
        return vo;
    }

    public void updateSettleFlag(List<Long> ids, Boolean flag) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(TemporaryUseRecordSubEntity::getPid, ids);
        List list = this.temporaryUseRecordSubService.list((Wrapper)wrapper);
        List collect = list.stream().map(item -> item.getId()).collect(Collectors.toList());
        if (flag.booleanValue()) {
            this.logger.info("\u7ed3\u7b97--\u4e34\u65f6\u8bb0\u5f55id--{}", (Object)JSONObject.toJSONString(ids));
            this.temporaryUseRecordSubService.updateSettleFlag(collect, 1);
        } else {
            this.logger.info("\u91ca\u653e--\u4e34\u65f6\u8bb0\u5f55id--{}", (Object)JSONObject.toJSONString(ids));
            this.temporaryUseRecordSubService.updateSettleFlag(collect, 0);
        }
    }

    @Override
    public void delete(List<Long> settleIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(RentSettlementFragmentaryEntity::getSettlementId, settleIds);
        List list = this.rentSettlementFragmentaryService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<Long> delIds = list.stream().map(RentSettlementFragmentaryEntity::getSourceId).collect(Collectors.toList());
            this.updateSettleFlag(delIds, false);
        }
        super.removeByIds(settleIds, false);
    }

    @Override
    public void delById(Long id) {
        Boolean flag = this.rentSettlementMapper.delById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25!");
        }
    }

    @Override
    public boolean queryExist(Long contractId, Long id) {
        List list;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentSettlementEntity::getContractId, (Object)contractId);
        wrapper.notIn(RentSettlementEntity::getBillState, new Object[]{1, 3});
        if (id != null) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        return CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)wrapper)));
    }

    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal currentTaxMny = BigDecimal.ZERO;
        BigDecimal currentMny = BigDecimal.ZERO;
        String sTDate = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        wrapper.in(RentSettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(RentSettlementEntity::getContractId, (Object)contractId);
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            RentSettlementEntity settlementEntity = (RentSettlementEntity)((Object)list.get(0));
            currentTaxMny = settlementEntity.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getCurrentSettlementTaxMny();
            currentMny = settlementEntity.getCurrentSettlementMny() == null ? BigDecimal.ZERO : settlementEntity.getCurrentSettlementMny();
            sTDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementEntity.getSettlementDate());
        }
        map.put("currentTaxMny", currentTaxMny);
        map.put("currentMny", currentMny);
        map.put("sTDate", sTDate);
        map.put("settlementNum", list.size());
        return CommonResponse.success((String)"\u83b7\u53d6\u91d1\u989d\u548c\u65f6\u95f4\u6210\u529f\uff01", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(RentSettlementEntity entity) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = "EJCBT202204000006::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"RENT_SETTLE_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "RENT_SETTLE_JS");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            SupRentSettlementVO supRentSettlementVO = (SupRentSettlementVO)BeanMapper.map((Object)((Object)entity), SupRentSettlementVO.class);
            List supRentSettlementDayVOS = BeanMapper.mapList(entity.getRentSettlementDayList(), SupRentSettlementDayVO.class);
            List supRentSettlementMonthVOS = BeanMapper.mapList(entity.getRentSettlementMonthList(), SupRentSettlementMonthVO.class);
            List supRentSettlementQuantitiesVOS = BeanMapper.mapList(entity.getRentSettlementQuantitiesList(), SupRentSettlementQuantitiesVO.class);
            List supRentSettlementRentalVOS = BeanMapper.mapList(entity.getRentSettlementRentalList(), SupRentSettlementRentalVO.class);
            List supSettlementFeeVOS = BeanMapper.mapList(entity.getRentSettlementFeeList(), SupRentSettlementFeeVO.class);
            supRentSettlementVO.setRentSettlementDayList(supRentSettlementDayVOS);
            supRentSettlementVO.setRentSettlementMonthList(supRentSettlementMonthVOS);
            supRentSettlementVO.setRentSettlementRentalList(supRentSettlementRentalVOS);
            supRentSettlementVO.setRentSettlementQuantitiesList(supRentSettlementQuantitiesVOS);
            supRentSettlementVO.setRentSettlementFeeList(supSettlementFeeVOS);
            paramMap.put("transData", JSONObject.toJSONString((Object)supRentSettlementVO));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "projectMangerSign", null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9644\u4ef6\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(files));
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/rentSettlement/saveRentSettlement", paramMap, entity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u8ba2\u5355\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "RENT_SETTLE_JS");
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(RentSettlementEntity entity) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = "EJCBT202204000006::" + entity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        ((RentSettlementMapper)this.baseMapper).updateById((Object)entity);
        this.logger.info("\u4fee\u6539\u7b7e\u5b57\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)entity));
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"RENT_SETTLE_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "RENT_SETTLE_JS");
                var6_6 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var6_6;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSupplierId(), (Object)entity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/rentSettlement/deleteRentSettlement", RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl36
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var9_11 = supHandleResp;
                return var9_11;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl36:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "RENT_SETTLE_JS");
        }
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        RentSettlementEntity settlementEntity = (RentSettlementEntity)((Object)super.selectById((Serializable)((Object)billId)));
        settlementEntity.setSupOperateTime(supOperateTime);
        settlementEntity.setSupOperatorName(supOperatorName);
        settlementEntity.setSupOperatorPhone(supOperatorPhone);
        settlementEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "EJCBT202204000006::" + settlementEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"RENT_SETTLE_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)settlementEntity.getId());
                this.releaseLock(jedis, false, key, "RENT_SETTLE_JS");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, settlementEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            settlementEntity.setAttachIds(attchIdsList);
            settlementEntity.setSignStatus(1);
            super.saveOrUpdate((Object)settlementEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)settlementEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
            throw e;
        }
        finally {
            this.releaseLock(jedis, locked, key, "RENT_SETTLE_JS");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public boolean pushSettleToPool(RentSettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            spv.setBillCodeUrl("/ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + vo.getId());
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    private void convertSettleVOToSettlePoolVO(RentSettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        spv.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        spv.setSourceType(SettleSourceTypeEnum.\u8bbe\u5907\u79df\u5165\u7ed3\u7b97.getCode());
        spv.setSettlePropertyName("\u652f\u51fa");
        spv.setSettleProperty(Integer.valueOf(0));
        spv.setSourceId(vo.getId());
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setContractFlag(Integer.valueOf(0));
        spv.setHandleType(Integer.valueOf(0));
        if (vo.getContractId() != null) {
            spv.setContractFlag(Integer.valueOf(1));
            RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(vo.getContractId()));
            spv.setContractType(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setPartyaId(contractEntity.getPartyId());
            spv.setPartyaName(contractEntity.getPartyName());
            spv.setSignDate(contractEntity.getSignedDate());
            spv.setLastTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny()));
            spv.setLastMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny()));
            spv.setLastTax(ComputeUtil.safeSub((BigDecimal)spv.getLastTaxMny(), (BigDecimal)spv.getLastMny()));
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(RentSettlementEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentSettlementEntity::getContractId, (Object)entity.getContractId());
        wrapper.in(RentSettlementEntity::getBillState, Arrays.asList(1, 3));
        List list = this.list((Wrapper)wrapper);
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(RentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.getById(entity.getContractId()));
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(this.baseHost + "ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public CommonResponse<RentSettlementVO> pushCost(RentSettlementVO vo) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)((RentSettlementMapper)this.baseMapper).selectById(vo.getId()));
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementRentalList())) {
            List rentalEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementRentalList(), RentSettlementRentalEntity.class);
            entity.setRentSettlementRentalList(rentalEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementDayList())) {
            List dayEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementDayList(), RentSettlementDayEntity.class);
            entity.setRentSettlementDayList(dayEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementMonthList())) {
            List monthEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementMonthList(), RentSettlementMonthEntity.class);
            entity.setRentSettlementMonthList(monthEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementQuantitiesList())) {
            List quantitiesEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementQuantitiesList(), RentSettlementQuantitiesEntity.class);
            entity.setRentSettlementQuantitiesList(quantitiesEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementFeeList())) {
            List feeEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementFeeList(), RentSettlementFeeEntity.class);
            entity.setRentSettlementFeeList(feeEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentSettlementFragmentaryList())) {
            List fragmentaryEntities = BeanMapper.mapList((Iterable)vo.getRentSettlementFragmentaryList(), RentSettlementFragmentaryEntity.class);
            entity.setRentSettlementFragmentaryList(fragmentaryEntities);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class));
    }

    @Override
    public void costPush(RentSettlementEntity entity) {
        String oldRelationFlag;
        this.logger.info("\u5f00\u59cbcostPush");
        List<RentSettlementFragmentaryEntity> fragmentaryList = entity.getRentSettlementFragmentaryList();
        List<RentSettlementDayEntity> dayList = entity.getRentSettlementDayList();
        List<RentSettlementMonthEntity> monthList = entity.getRentSettlementMonthList();
        List<RentSettlementQuantitiesEntity> quantitiesList = entity.getRentSettlementQuantitiesList();
        List<RentSettlementFeeEntity> feeList = entity.getRentSettlementFeeList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fragmentaryList)) {
            for (RentSettlementFragmentaryEntity rentSettlementFragmentaryEntity : fragmentaryList) {
                if (null != rentSettlementFragmentaryEntity.getSubjectIdFragmentary() && null != rentSettlementFragmentaryEntity.getWbsIdFragmentary()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (RentSettlementDayEntity rentSettlementDayEntity : dayList) {
                if (null != rentSettlementDayEntity.getSubjectId() && null != rentSettlementDayEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (RentSettlementMonthEntity rentSettlementMonthEntity : monthList) {
                if (null != rentSettlementMonthEntity.getSubjectId() && null != rentSettlementMonthEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (RentSettlementQuantitiesEntity rentSettlementQuantitiesEntity : quantitiesList) {
                if (null != rentSettlementQuantitiesEntity.getSubjectId() && null != rentSettlementQuantitiesEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (RentSettlementFeeEntity rentSettlementFeeEntity : feeList) {
                if (null != rentSettlementFeeEntity.getSubjectId() && null != rentSettlementFeeEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(feeList) && ListUtil.isEmpty(dayList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(quantitiesList) && ListUtil.isEmpty(fragmentaryList)) {
            newRelationFlag = "0";
        }
        if ("1".equals(oldRelationFlag = entity.getRelationFlag())) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9886\u6599\u51fa\u5e93Id---{}", (Object)entity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(entity);
        }
        entity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        lambdaUpdateWrapper.set(RentSettlementEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)lambdaUpdateWrapper);
    }

    @Override
    public List<RentRentalEntity> queryRental(Long contractId, String settleDate) {
        return ((RentSettlementMapper)this.baseMapper).queryRental(contractId, settleDate);
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyList(RentContractEntity rentContractEntity, RentSettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        if (null != rentContractEntity.getPurchaseType() && 2 == rentContractEntity.getPurchaseType()) {
            return paramsCheckVOList;
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getSettlementType()) {
            case 0: {
                CHECK_PARAM_CODE = CHECK_PARAM_CODE_GC;
                break;
            }
            case 1: {
                CHECK_PARAM_CODE = CHECK_PARAM_CODE_ZZ;
            }
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    String orgName = datum.getOrgName();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BillParamVO billParamVO = datum;
                    BigDecimal totalSettleTaxMny = null == vo.getCurrentSettlementTaxMny() ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                    BigDecimal settleTaxMny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)rentContractEntity.getContractTaxMny(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleTaxMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalSettleTaxMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO checkParams(RentSettlementVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (vo.getContractId() != null) {
            RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(vo.getContractId()));
            paramsCheckVOS.addAll(this.checkParamsMnyList(rentContractEntity, vo));
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private void saveCost(RentSettlementEntity entity) {
        CostDetailVO costDetailVO;
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<RentSettlementFragmentaryEntity> fragmentaryList = entity.getRentSettlementFragmentaryList();
        List<RentSettlementDayEntity> dayList = entity.getRentSettlementDayList();
        List<RentSettlementMonthEntity> monthList = entity.getRentSettlementMonthList();
        List<RentSettlementQuantitiesEntity> quantitiesList = entity.getRentSettlementQuantitiesList();
        List<RentSettlementFeeEntity> feeList = entity.getRentSettlementFeeList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fragmentaryList)) {
            for (RentSettlementFragmentaryEntity rentSettlementFragmentaryEntity : fragmentaryList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementFragmentaryEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementFragmentaryEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementFragmentaryEntity.getFragmentaryTaxMny());
                costDetailVO.setHappenMny(rentSettlementFragmentaryEntity.getFragmentaryMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_FRAGMENTARY");
                costDetailVO.setWbsId(rentSettlementFragmentaryEntity.getWbsIdFragmentary());
                costDetailVO.setWbsCode(rentSettlementFragmentaryEntity.getWbsCodeFragmentary());
                costDetailVO.setWbsName(rentSettlementFragmentaryEntity.getWbsNameFragmentary());
                costDetailVO.setSubjectId(rentSettlementFragmentaryEntity.getSubjectIdFragmentary());
                costDetailVO.setSubjectCode(rentSettlementFragmentaryEntity.getSubjectCodeFragmentary());
                costDetailVO.setSubjectName(rentSettlementFragmentaryEntity.getSubjectNameFragmentary());
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (RentSettlementDayEntity rentSettlementDayEntity : dayList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementDayEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementDayEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementDayEntity.getDayTaxMny());
                costDetailVO.setHappenMny(rentSettlementDayEntity.getDayMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_DAY");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (RentSettlementMonthEntity rentSettlementMonthEntity : monthList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementMonthEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementMonthEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementMonthEntity.getMonthTaxMny());
                costDetailVO.setHappenMny(rentSettlementMonthEntity.getMonthMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_MONTH");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (RentSettlementQuantitiesEntity rentSettlementQuantitiesEntity : quantitiesList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementQuantitiesEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementQuantitiesEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementQuantitiesEntity.getQuantitiesTaxMny());
                costDetailVO.setHappenMny(rentSettlementQuantitiesEntity.getQuantitiesMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_QUANTITIES");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (RentSettlementFeeEntity rentSettlementFeeEntity : feeList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)rentSettlementFeeEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(rentSettlementFeeEntity.getId());
                costDetailVO.setHappenTaxMny(rentSettlementFeeEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(rentSettlementFeeEntity.getFeeMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_FEE");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            for (CostDetailVO costDetailVO2 : costDetailVOList) {
                costDetailVO2.setSourceBillCode(entity.getBillCode());
                costDetailVO2.setSourceBillName(SourceTypeEnum.\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97.getTypeName());
                costDetailVO2.setSourceBillUrl("/ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());
                costDetailVO2.setSourceId(entity.getId());
                costDetailVO2.setHappenDate(entity.getSettlementDate());
                costDetailVO2.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO2.setId(null);
                costDetailVO2.setSourceType("TEMP_EQ_JS");
                costDetailVO2.setProjectId(entity.getProjectId());
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.selectById(id));
        if (entity.getSettlementType() != null && entity.getSettlementType() == 1) {
            this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5f00\u59cb");
            CommonResponse response = this.executionApi.aggPush(this.targetCost(entity));
            this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)this.targetCost(entity)));
            if (!response.isSuccess()) {
                this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public RentSettleRecordVO queryDetailRecord(Long contractId) {
        RentSettleRecordVO settleRecordVO = new RentSettleRecordVO();
        RentContractEntity contract = (RentContractEntity)((Object)this.rentContractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getContractPerformanceState());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"settlement_date");
        List list = super.list((Wrapper)listQuery);
        List rentSettlementVOS = BeanMapper.mapList((Iterable)list, RentSettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            contractSettleMny = list.stream().map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);
        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        } else {
            settleRecordVO.setSettleRate(settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100L)).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    @Override
    public void updateContractPoolSettle(RentSettlementVO vo, Boolean type) {
        if (null != vo.getContractId()) {
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + (type != false ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0csettleEntity={}, \u8fc7\u7a0b\uff080\uff09/\u6700\u7ec8\uff081\uff09={}, type={}", new Object[]{vo, vo.getSettlementType(), type});
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
            BigDecimal totalSettleMny = BigDecimal.ZERO;
            BigDecimal totalSettleTax = BigDecimal.ZERO;
            if (type.booleanValue()) {
                totalSettleTaxMny = vo.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                totalSettleMny = vo.getCurrentSettlementMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementMny();
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            } else {
                totalSettleTaxMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny());
                totalSettleMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny());
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            }
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);
            contractPoolVO.setTotalSettleMny(totalSettleMny);
            contractPoolVO.setTotalSettleTax(totalSettleTax);
            if (1 == vo.getSettlementType()) {
                if (type.booleanValue()) {
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
            }
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
            CommonResponse updateConPoolRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)updateConPoolRes));
        }
    }
}

