package com.ejianc.business.pricelib.controller;

import java.io.Serializable;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.business.pricelib.service.IRentPriceContractCollectService;
import com.ejianc.business.pricelib.vo.RentPriceContractCollectVO;

/**
 * 设备租赁价格库-根据清单id汇总表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("rentPriceContractCollect")
public class RentPriceContractCollectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRentPriceContractCollectService service;


    /**
     * @Description shelfGoods 价格库列表数据到历史表定时任务
     */
    @RequestMapping(value = "/savePriceContractCollect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> savePriceContractCollect(HttpServletRequest request) {
        service.savePriceContractToHistoryByTiming();
        return CommonResponse.success("价格库列表数据到历史表定时任务处理成功");
    }


    //查询多个档案清单历史价格
    @PostMapping("/getPriceContractByDocIds")
    public CommonResponse<List<RentPriceContractCollectVO>> getPriceContractByDocIds(@RequestBody JSONObject jsonObject){
        logger.info("档案id集合【{}】", JSONObject.toJSONString(jsonObject));
        List<Long> docIds = JSONArray.parseArray(jsonObject.getString("docIds"), Long.class);
        List<RentPriceContractCollectVO> PriceContractCollectVOList = service.getPriceContractByDocIds(docIds, jsonObject.getInteger("rentType"));
        return CommonResponse.success("查询成功！",PriceContractCollectVOList);
    }
}
