package com.ejianc.business.temporary.userecord.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordService;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("/api/temporaryUseRecord/")
public class TemporaryUseRecordApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITemporaryUseRecordService service;

    /**
     * 根据 项目和收款单位 查询合同为空的 已生效的 临时设备使用记录 的 使用金额之和
     *
     * @param projectId  项目id
     * @param supplierId 供应商id
     * @return 查询结果
     */
    @ApiOperation("根据 项目和收款单位 查询合同为空的 已生效的 临时设备使用记录 的 使用金额之和")
    @RequestMapping(value = "/queryTemporaryUseRecordMny", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<JSONObject> queryTemporaryUseRecordMny(@RequestParam("projectId") Long projectId,
                                                          @RequestParam("supplierId") Long supplierId) {
        logger.info("查询临时设备使用记录使用金额之和，查询参数projectId:{}，supplierId:{}", projectId, supplierId);
        QueryParam param = new QueryParam();
        param.getParams().put("noContract", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        List<TemporaryUseRecordEntity> list = service.queryList(param, false);
        BigDecimal useMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            useMny = list.stream().filter(e -> e.getUseMny() != null).map(TemporaryUseRecordEntity::getUseMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("useMny", useMny);
        logger.info("查询临时设备使用记录使用金额之和，查询结果:{}", jsonObject);
        return CommonResponse.success("查询成功", jsonObject);
    }


    /**
     * 根据 项目 查询合同为空的 已生效的 临时设备使用记录 的 使用金额之和
     *
     * @param projectId  项目id
     * @return 查询结果
     */
    @ApiOperation("根据 项目 查询合同为空的 已生效的 临时设备使用记录 的 使用金额之和")
    @RequestMapping(value = "/queryTemporaryUseProject", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<JSONObject> queryTemporaryUseProject(@RequestParam("projectId") Long projectId) {
        logger.info("查询临时设备使用记录使用金额之和，查询参数projectId:{}", projectId);
        QueryParam param = new QueryParam();
        param.getParams().put("noContract", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        List<TemporaryUseRecordEntity> list = service.queryList(param, false);
        BigDecimal useMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            useMny = list.stream().filter(e -> e.getUseMny() != null).map(TemporaryUseRecordEntity::getUseMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("useMny", useMny);
        logger.info("查询临时设备使用记录使用金额之和，查询结果:{}", jsonObject);
        return CommonResponse.success("查询成功", jsonObject);
    }

    /**
     * 根据 项目 查询合同为空的 已生效的 临时设备使用记录
     *
     * @param projectId  项目id
     * @return 查询结果
     */
    @ApiOperation("根据 项目 查询合同为空的 已生效的 临时设备使用记录")
    @RequestMapping(value = "/queryTemporaryListUseProject", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<TemporaryUseRecordVO> > queryTemporaryListUseProject(@RequestParam("projectId") Long projectId) {
        logger.info("查询临时设备使用记录使用金额之和，查询参数projectId:{}", projectId);
        QueryParam param = new QueryParam();
        param.getParams().put("noContract", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        List<TemporaryUseRecordEntity> list = service.queryList(param, false);
        List<TemporaryUseRecordVO> recordVOS = BeanMapper.mapList(list, TemporaryUseRecordVO.class);
        logger.info("查询临时设备使用记录，查询结果:{}", recordVOS);
        return CommonResponse.success("查询成功", recordVOS);
    }
    /**
     * 根据 项目查询所有状态临时设备使用记录 的 使用金额之和
     *
     * @param projectId  项目id
     * @return 查询结果
     */
    @ApiOperation("根据 项目查询所有状态临时设备使用记录 的 使用金额之和")
    @RequestMapping(value = "/queryProTemporaryUseRecordMny", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<JSONObject> queryProTemporaryUseRecordMny(@RequestParam("projectId") Long projectId) {
        logger.info("查询临时设备使用记录使用金额之和，查询参数projectId:{}", projectId);
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<TemporaryUseRecordEntity> list = service.queryList(param, false);
        BigDecimal useMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            useMny = list.stream().filter(e ->null!= e.getUseMny()).map(TemporaryUseRecordEntity::getUseMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("useMny", useMny);
        logger.info("查询临时设备使用记录使用金额之和，查询结果:{}", jsonObject);
        return CommonResponse.success("查询成功", jsonObject);
    }
}
