/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.business.rent.bean.RentEquipmentPlanEntity;
import com.ejianc.business.rent.bean.RentTotalPlanEntity;
import com.ejianc.business.rent.mapper.RentEquipmentPlanMapper;
import com.ejianc.business.rent.service.IRentEquipmentPlanService;
import com.ejianc.business.rent.service.IRentTotalPlanService;
import com.ejianc.business.rent.vo.RentEquipmentPlanVO;
import com.ejianc.business.rent.vo.RentPlanEnum;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentEquipmentPlanService")
public class RentEquipmentPlanServiceImpl
extends BaseServiceImpl<RentEquipmentPlanMapper, RentEquipmentPlanEntity>
implements IRentEquipmentPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentTotalPlanService rentTotalPlanService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PLAN_MNY_PARAM_CODE = "P-06b7t60241";

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        List entityList;
        if (StringUtils.isEmpty((CharSequence)RentPlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (RentEquipmentPlanEntity entity : entityList) {
                if (RentPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getBiddingState())) {
                    throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010" + entity.getCode() + "\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01");
                }
                entity.setBiddingState(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }

    @Override
    public ParamsCheckVO checkParams(RentEquipmentPlanVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsByMasterPlanMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public List<ParamsCheckVO> checkParamsByMasterPlanMny(RentEquipmentPlanVO vo) {
        CommonResponse billParamByCode;
        BigDecimal temporaryMoney;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal totalMoney = temporaryMoney = vo.getTemporaryAmount();
        LambdaQueryWrapper planLambda = new LambdaQueryWrapper();
        planLambda.eq(RentTotalPlanEntity::getProjectId, (Object)vo.getProjectId());
        planLambda.in(RentTotalPlanEntity::getBillState, new Object[]{1, 3});
        planLambda.eq(BaseEntity::getDr, (Object)0);
        List planList = this.rentTotalPlanService.list((Wrapper)planLambda);
        if (!CollectionUtils.isNotEmpty((Collection)planList)) {
            return paramsCheckVOS;
        }
        BigDecimal planTaxMny = planList.stream().filter(e -> null != e.getTemporaryAmount()).map(RentTotalPlanEntity::getTemporaryAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        LambdaQueryWrapper Lambda = new LambdaQueryWrapper();
        Lambda.eq(RentEquipmentPlanEntity::getProjectId, (Object)vo.getProjectId());
        Lambda.in(RentEquipmentPlanEntity::getBillState, new Object[]{1, 3});
        List list = super.list((Wrapper)Lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (RentEquipmentPlanEntity batchPlanEntity : list) {
                totalMoney = MathUtil.safeAdd(totalMoney, batchPlanEntity.getTemporaryAmount());
            }
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PLAN_MNY_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u603b\u8ba1\u5212\u91d1\u989d\u63a7\u5236\u6279\u6b21\u8ba1\u5212\u91d1\u989d\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)planTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u6279\u6b21\u8ba1\u5212\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u6279\u6b21\u8ba1\u5212\u91d1\u989d\u5927\u4e8e\u603b\u8ba1\u5212\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u6279\u6b21\u8ba1\u5212\u91d1\u989d\uff1a").append(temporaryMoney.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u6279\u6b21\u8ba1\u5212\u91d1\u989d\uff1a").append(totalMoney.setScale(2, 4)).append("\u5143\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }
}

