package com.ejianc.business.rent.service;

import com.ejianc.business.rent.vo.RentContractChangeVO;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.rent.bean.RentContractChangeEntity;

import java.util.List;
import java.util.Map;

/**
 * 租赁合同变更
 * 
 * @author generator
 * 
 */
public interface IRentContractChangeService extends IBaseService<RentContractChangeEntity> {
    /**
     * 保存或者修改
     * @param rentContractChangeVO
     */
    public RentContractChangeVO saveOrUpdates(RentContractChangeVO rentContractChangeVO);

    public RentContractChangeVO addConvertByConId(Long contractId, Long changeId);

    /**
     * 查询详情
     * @param id
     * @return
     */
    public RentContractChangeVO queryDetailRecord(Long id);

    /**
     * 根据合同id查询是否可以变更
     * @param contractId
     * @return
     */
    public Boolean editChangeFlag(Long contractId);

    ExecutionVO targetCost(RentContractChangeVO changeVO,Long lastSourceId);

    public void queryBpm(Long contractId);
    public CommonResponse<String> effectiveSaveWriteContract(Long billId, String billTypeCode, Boolean commitState);
    public CommonResponse<String> deleteById(Long changeBillId);

    RentContractChangeVO saveOrUpdate(RentContractChangeVO saveOrUpdateVO,Boolean isControl);

    ParamsCheckVO targetCostCtrl(RentContractChangeVO changeVO);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    RentContractChangeVO queryDetail(Long id);
    Boolean changeSignStatus(Long billId, int status, String refCode);
    ParamsCheckVO checkParams(RentContractChangeVO vo,ParamsCheckVO paramsCheckVO2);
    List<ParamsCheckVO> checkParamsMny(RentContractChangeVO vo);
    List<ParamsCheckVO> checkParamsMnyPlan(RentContractChangeVO vo);
    /*施工合同 控  变更
     *        @param 变更合同vo

     * */
    List<ParamsCheckVO> checkParamsConstruction(RentContractChangeVO vo);

    Map queryChangeCompare(Long id);

    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    void asyncWatermarkById(Long id);

    public void deleteTargetCost(ExecutionVO targetCost);

    public RentContractChangeEntity queryChangeList(RentContractChangeEntity entity);

    /**
     * 变更历史价控合同价
     * @param changeVO
     * @return
     */
    List<ParamsCheckVO> historyPriceCtrlContractPrice(RentContractChangeVO changeVO);
}
