package com.ejianc.business.rent.service;

import com.ejianc.business.ac.bean.ContractRelieveEntity;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.rent.bean.RentContractRelieveEntity;

/**
 * 租赁合同解除
 * 
 * @author generator
 * 
 */
public interface IRentContractRelieveService extends IBaseService<RentContractRelieveEntity> {
    ExecutionVO targetCost(RentContractRelieveEntity entity);

    void delById(Long id);

    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param billId  合同解除单据id
     * @param status  签章状态
     * @param refCode 唯一标识
     * @return 结果数据
     */
    CommonResponse<String> relieveContract(String billId, String status, String refCode);
}
