package com.ejianc.business.rent.service.impl;

import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.service.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;

@Service("rentChangeTotalPlan") 
public class RentChangeTotalPlanBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IRentChangeTotalPlanService changeService;
	@Autowired
	private IRentTotalPlanService planService;
	@Autowired
	private IRentTotalPlanSubService rentTotalPlanSubService;
	@Autowired
	private IRentTotalPlanHistoryService rentTotalPlanHistoryService;
	@Autowired
	private IRentTotalPlanHistorySubService rentTotalPlanHistorySubService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//TODO
		//1是直审，2是有审批流
		logger.info("--------------总计划变更审批通过，处理业务");
		//变更表
		RentChangeTotalPlanEntity entity = changeService.selectById(billId);
		List<RentChangeTotalPlanSubEntity> subEntityList = entity.getTotalPlanSubList();
		//计划主表
		RentTotalPlanEntity rentTotalPlanEntity = planService.selectById(entity.getTotalId());

		//同步原计划到记录表
		logger.info("--------------同步原始总计划到记录表");
		RentTotalPlanHistoryEntity historyEntity = BeanMapper.map(rentTotalPlanEntity, RentTotalPlanHistoryEntity.class);
		historyEntity.setTotalId(entity.getTotalId());//原计划主键
		historyEntity.setId(null);
		historyEntity.setCreateTime(new Date());
		historyEntity.setRentTotalPlanHistorySubList(null);
		rentTotalPlanHistoryService.saveOrUpdate(historyEntity, false);

        //同步原清单到记录表
		logger.info("--------------同步原始总计划清单到记录表");
		List<RentTotalPlanSubEntity> totalPlanSubList = rentTotalPlanEntity.getTotalPlanSubList();
		if (null != totalPlanSubList && totalPlanSubList.size() > 0) {
			List<RentTotalPlanHistorySubEntity> historyDetails = BeanMapper.mapList(totalPlanSubList, RentTotalPlanHistorySubEntity.class);
			for (RentTotalPlanHistorySubEntity hde : historyDetails) {
				hde.setHistoryId(historyEntity.getId());//记录表主键
				hde.setTotalId(entity.getTotalId());//原合同主键
				hde.setTotalBid(hde.getId());//原子表id
				hde.setId(null);
			}
			rentTotalPlanHistorySubService.saveOrUpdateBatch(historyDetails, historyDetails.size(), false);
		}


		//回写计划主表
		RentTotalPlanEntity newEntity = BeanMapper.map(entity, RentTotalPlanEntity.class);
		newEntity.setId(rentTotalPlanEntity.getId());
		newEntity.setBaseMny(rentTotalPlanEntity.getBaseMny());
		newEntity.setChangingMny(null);
		newEntity.setChangeStatus(3);//状态改为已变更
		newEntity.setChangeCode(rentTotalPlanEntity.getChangeCode());
		newEntity.setChangeId(rentTotalPlanEntity.getChangeId());
		newEntity.setBillState(rentTotalPlanEntity.getBillState());
		newEntity.setCreateTime(rentTotalPlanEntity.getCreateTime());
		newEntity.setVersion(rentTotalPlanEntity.getVersion());
		newEntity.setTotalPlanSubList(null);
		newEntity.setCode(rentTotalPlanEntity.getCode());
		newEntity.setOrgId(rentTotalPlanEntity.getOrgId());
		logger.info("--------------变更总计划回写到原始总计划");
		planService.saveOrUpdate(newEntity);

		// 回写原合同清单表
		logger.info("--------------变更总计划清单回写到原始总计划清单");
		planService.delByPlanId(rentTotalPlanEntity.getId());

		if (CollectionUtils.isNotEmpty(subEntityList)) {
			List<RentTotalPlanSubEntity> detailEntitys = BeanMapper.mapList(subEntityList, RentTotalPlanSubEntity.class);
			for(RentTotalPlanSubEntity detailEntity : detailEntitys){
				detailEntity.setPid(entity.getTotalId());
			}
			rentTotalPlanSubService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
		}

		logger.info("--------------处理总计划变更单");
		entity.setUsedTime(new Date());
		changeService.saveOrUpdate(entity, false);

		logger.info("--------------处理变更附件");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
