package com.ejianc.business.temporary.userecord.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordEntity;
import com.ejianc.business.temporary.userecord.bean.TemporaryUseRecordSubEntity;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordService;
import com.ejianc.business.userecord.bean.UseRecordEntity;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;

@Service("temporaryUseRecord") 
public class TemporaryUseRecordBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ITemporaryUseRecordService service;
	@Autowired
	private IBillTypeApi billTypeApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		TemporaryUseRecordEntity entity = service.selectById(billId);
		boolean pushFlag = service.pushBillToSupCenter(entity,billTypeCode);
		logger.info("获取推送供方结果--"+pushFlag);
		if(!pushFlag){
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}else{
			entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		}
		service.saveOrUpdate(entity,false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if(!resp.isSuccess()){
			return CommonResponse.error("无法撤回！"+resp.getMsg());
		}
		TemporaryUseRecordEntity entity = service.selectById(billId);
		if(entity.getNotSignature()!=null && entity.getNotSignature()==1){
			throw new BusinessException("已签字不能撤回！");
		}
		List<TemporaryUseRecordSubEntity> subList = entity.getTemporaryUseRecordSubList();
		if(CollectionUtils.isNotEmpty(subList)){
			for (TemporaryUseRecordSubEntity subEntity : subList) {
				if(subEntity.getSettleFlag()!=null && subEntity.getSettleFlag()==1){
					return CommonResponse.error("单据被结算引用，不能弃审！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//推送供方
		TemporaryUseRecordEntity entity = service.selectById(billId);
		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())){
			CommonResponse<String> commonResponse = service.updatePushBill(entity,billTypeCode);
			logger.info("供方结果"+ JSONObject.toJSONString(commonResponse));
			if(!commonResponse.isSuccess()){
				throw new BusinessException(commonResponse.getMsg());
			}
		}
		entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		service.saveOrUpdate(entity,false);
		return CommonResponse.success();
	}

}
