/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.rent.bean.RentEquipmentStopEntity;
import com.ejianc.business.rent.bean.RentEquipmentStopSubEntity;
import com.ejianc.business.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.rent.bean.RentParameterEntity;
import com.ejianc.business.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.rent.service.IRentAcceptanceService;
import com.ejianc.business.rent.service.IRentEquipmentStopService;
import com.ejianc.business.rent.service.IRentParameterDetailService;
import com.ejianc.business.rent.service.IRentParameterService;
import com.ejianc.business.rent.vo.PushRentEquipmentStopSubVO;
import com.ejianc.business.rent.vo.PushRentEquipmentStopVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rentEquipmentStop")
public class RentEquipmentStopBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private IRentEquipmentStopService stopService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentEquipmentStopService rentEquipmentStopService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop";
    private final String OPERATE = "RENT-PROEQUIPMENT-ASTOP";
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    private static final String BILL_TYPE = "BT220221000000004";
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/saveStop";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStopEntity entity = (RentEquipmentStopEntity)((Object)this.rentEquipmentStopService.selectById(billId));
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", billId);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = this.rentAcceptanceService.updateSupplierStatus(billId, dataInfo, "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop", RequestMethod.POST, entity.getSupplierId().toString(), "RENT-PROEQUIPMENT-ASTOP", BILL_TYPE);
            if (!updateSupplierStatus.booleanValue()) {
                throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.rentEquipmentStopService.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5230\u8bbe\u5907\u505c\u7528\u4e86.....{}", (Object)billId);
        RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById(billId));
        List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
        ArrayList<RentParameterEntity> parameterList = new ArrayList<RentParameterEntity>();
        for (RentEquipmentStopSubEntity subEntity : subEntityList) {
            RentParameterEntity parameterEntity = new RentParameterEntity();
            parameterEntity.setId(subEntity.getSourceId());
            parameterEntity.setStopDate(subEntity.getTypeDate());
            parameterEntity.setOperationDate(new Date());
            parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u7528.getCode());
            ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
            RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
            detailEntity.setSourceType(RentParameterTypeEnum.\u505c\u7528\u5355.getCode());
            detailEntity.setSourceId(stopEntity.getId());
            detailEntity.setOperationDate(subEntity.getTypeDate());
            detailEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u7528.getCode());
            detailEntity.setParameterId(subEntity.getSourceId());
            parameterDetailList.add(detailEntity);
            parameterEntity.setRentParameterDetailList(parameterDetailList);
            parameterList.add(parameterEntity);
        }
        this.rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u505c\u7528\u5355.getCode());
        PushRentEquipmentStopVO supplierPushCheckVO = (PushRentEquipmentStopVO)BeanMapper.map((Object)((Object)stopEntity), PushRentEquipmentStopVO.class);
        supplierPushCheckVO.setSourceId(stopEntity.getId());
        List pushRentEquipmentStopSubVOS = BeanMapper.mapList(stopEntity.getRentEquipmentStopSubList(), PushRentEquipmentStopSubVO.class);
        for (PushRentEquipmentStopSubVO supplierPushCheckDetailVO : pushRentEquipmentStopSubVOS) {
            supplierPushCheckDetailVO.setSourceId(stopEntity.getId());
            supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
            supplierPushCheckDetailVO.setId(null);
        }
        supplierPushCheckVO.setEquipmentStopDetailList(pushRentEquipmentStopSubVOS);
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        } else {
            supplierPushCheckVO.setSystemId((String)ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString((Object)supplierPushCheckVO);
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)BILL_TYPE, (Object)cooperateResp.getMsg());
            } else {
                boolean b = this.rentAcceptanceService.pushBillToSupCenter(dataInfo, stopEntity.getSupplierId(), stopEntity.getId(), BILL_TYPE, (CooperateVO)cooperateResp.getData(), PUSH_SAVE_URL);
                if (!b) {
                    this.logger.error("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)dataInfo);
                } else {
                    stopEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                }
            }
        }
        this.stopService.updateById((Object)stopEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById(billId));
        if (stopEntity.getRentType().equals("1")) {
            return CommonResponse.error((String)"\u5185\u79df\u4e0d\u652f\u6301\u64a4\u56de");
        }
        List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
        for (RentEquipmentStopSubEntity subEntity : subEntityList) {
            RentParameterDetailEntity detailEntity;
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("parameterId", new Parameter("eq", (Object)subEntity.getSourceId()));
            queryParam.getOrderMap().put("operationDate", "desc");
            queryParam.getOrderMap().put("createTime", "desc");
            List detailEntityList = this.rentParameterDetailService.queryList(queryParam, false);
            if (!CollectionUtils.isNotEmpty((Collection)detailEntityList) || billId.equals((detailEntity = (RentParameterDetailEntity)((Object)detailEntityList.get(0))).getSourceId())) continue;
            return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25:\u8be5\u5355\u636e\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u6216\u5df2\u505a\u79df\u91d1\u8ba1\u7b97\uff0c\u8bf7\u68c0\u67e5");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5230\u8bbe\u5907\u505c\u7528\u5f03\u5ba1\u6d41\u7a0b.....{}", (Object)billId);
        RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById(billId));
        List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
        ArrayList<Long> parameterIdList = new ArrayList<Long>();
        for (RentEquipmentStopSubEntity subEntity : subEntityList) {
            parameterIdList.add(subEntity.getSourceId());
        }
        this.rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.\u505c\u7528\u5355.getCode(), stopEntity.getId());
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", billId);
        map.put("systemId", ejcCloudSystemCode.getData());
        String dataInfo = JSONObject.toJSONString(map);
        Boolean updateSupplierStatus = this.rentAcceptanceService.updateSupplierStatus(billId, dataInfo, "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop", RequestMethod.POST, stopEntity.getSupplierId().toString(), "RENT-PROEQUIPMENT-ASTOP", BILL_TYPE);
        if (!updateSupplierStatus.booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
        }
        stopEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.rentEquipmentStopService.saveOrUpdate((Object)stopEntity, false);
        return CommonResponse.success();
    }
}

