package com.ejianc.business.temporary.settlement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementEntity;
import com.ejianc.business.temporary.settlement.service.ITemporarySettlementService;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

@Service("temporarySettlement")
public class TemporarySettlementBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private ITemporarySettlementService service;
	@Autowired
	private ITemporaryContractService temporaryContractService;//临时设备合同
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IExecutionApi executionApi;
	@Autowired
	private ICostDetailApi costDetailApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE
				.getBillStateCode().equals(state)) {
			logger.info("审批通过业务开始！");
			//结算单
			TemporarySettlementEntity entity = service.selectById(billId);
			//推送结算池所用vo
			TemporarySettlementVO settlementVO = BeanMapper.map(entity, TemporarySettlementVO.class);
			//修改合同状态  结算类型，0-过程,1-最终
			if(entity.getContractId()!=null && entity.getSettlementType()==1){
				TemporaryContractEntity temporaryContractEntity = temporaryContractService.selectById(entity.getContractId());
				temporaryContractEntity.setContractPerformanceState("3");
				temporaryContractService.saveOrUpdate(temporaryContractEntity);
				logger.info("修改合同状态！"+ JSONObject.toJSONString(temporaryContractEntity));
			}
			//推送结算池
			boolean pool = service.pushSettleToPool(settlementVO);
			if(!pool){
				throw new BusinessException("推送结算失败");
			}
			// 推送 实际成本
			service.costPush(entity);
// 最终结算推送目标成本
			if (entity.getSettlementType()!=null&&entity.getSettlementType()==1){
				logger.info("推送目标成本开始");
				CommonResponse<String> response = executionApi.aggPush(service.targetCost(entity));
				logger.info("推送目标成本入参：" + JSONObject.toJSONString(service.targetCost(entity)));
				if (!response.isSuccess()){
					logger.error("推送目标成本失败: , {}", response.getMsg());
					throw new BusinessException(response.getMsg());
				}

			}
			logger.info("推送成本---");
			service.costPush(entity);
			boolean pushFlag = service.pushBillToSupCenter(entity,billTypeCode);
			logger.info("获取推送供方结果--"+pushFlag);
			if(!pushFlag){
				entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			}else{
				entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
			}
			service.saveOrUpdate(entity,false);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//结算单
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		TemporarySettlementEntity entity = service.selectById(billId);
		if(entity.getSignStatus()==1){
			throw new BusinessException("已签字不能撤回！");
		}
		if(entity.getContractId()!=null){
			LambdaQueryWrapper<TemporarySettlementEntity> lambda = new LambdaQueryWrapper<>();
			lambda.eq(TemporarySettlementEntity::getContractId, entity.getContractId());
			lambda.orderByDesc(TemporarySettlementEntity::getCreateTime);
			List<TemporarySettlementEntity> list = service.list(lambda);
			TemporarySettlementEntity settlementEntity = list.get(0);
			if(!entity.getId().equals(settlementEntity.getId())){
				throw new BusinessException("只能撤回最新的结算单！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		TemporarySettlementEntity entity = service.selectById(billId);
		//修改合同状态  结算类型，0-过程,1-最终
		if(entity.getContractId()!=null && entity.getSettlementType()==1){
			TemporaryContractEntity contractEntity = temporaryContractService.selectById(entity.getContractId());
			contractEntity.setContractPerformanceState("2");
			temporaryContractService.saveOrUpdate(contractEntity);
			logger.info("修改合同状态！"+JSONObject.toJSONString(contractEntity));
		}
		//结算池撤回
		boolean pool = service.delSettleFromPool(billId);
		if(!pool){
			throw new BusinessException("弃审推送结算池失败！");
		}
		// 删除目标成本
		if (entity.getSettlementType()!=null&&entity.getSettlementType()==1) {
			List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
			ExecutionVO executionVO = service.targetCost(entity);
			totalExecutionVOList.add(executionVO.getTotalVO());
			CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
			logger.info("删除目标成本结果" + JSONObject.toJSONString(response));
			if (!response.isSuccess()) {
				throw new BusinessException("目标成本删除失败！");
			}
		}
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-临时设备结算Id---{}",entity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.updateCostDetail(entity.getId(),0);
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
//		//推送供方
		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())){
			CommonResponse<String> commonResponse = service.updatePushBill(entity,billTypeCode);
			logger.info("供方结果"+ JSONObject.toJSONString(commonResponse));
			if(!commonResponse.isSuccess()){
				throw new BusinessException(commonResponse.getMsg());
			}
		}
		//更新是否关联
		LambdaUpdateWrapper<TemporarySettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(TemporarySettlementEntity::getId, entity.getId());
		updateWrapper.set(TemporarySettlementEntity::getRelationFlag, "0");//(1:是，0：否)
		updateWrapper.set(TemporarySettlementEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
		service.update(updateWrapper);
		return CommonResponse.success();
	}

}
