/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.userecord.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.userecord.bean.UseRecordEntity;
import com.ejianc.business.userecord.mapper.UseRecordMapper;
import com.ejianc.business.userecord.service.IUseRecordService;
import com.ejianc.business.userecord.vo.SupUseRecordSubVO;
import com.ejianc.business.userecord.vo.SupUseRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="useRecordService")
public class UseRecordServiceImpl
extends BaseServiceImpl<UseRecordMapper, UseRecordEntity>
implements IUseRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "USE_RECORD";
    private static final String BILL_TYPE = "BT220302000000003";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/equipmentUseRecord/saveEquipmentUseRecord";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/equipmentUseRecord/deleteEquipmentUseRecord";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(UseRecordEntity entity, String billTypeCode) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"USE_RECORD", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "USE_RECORD");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            SupUseRecordVO supVO = (SupUseRecordVO)BeanMapper.map((Object)((Object)entity), SupUseRecordVO.class);
            List supDetailVOS = BeanMapper.mapList(entity.getUseRecordSubList(), SupUseRecordSubVO.class);
            supVO.setUseRecordSubList(supDetailVOS);
            paramMap.put("transData", JSONObject.toJSONString((Object)supVO));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), billTypeCode, "projectMangerSign", null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9644\u4ef6\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(files));
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/equipmentUseRecord/saveEquipmentUseRecord", paramMap, entity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "USE_RECORD");
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(UseRecordEntity entity, String billTypeCode) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = billTypeCode + "::" + entity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        entity.setNotSignature(false);
        ((UseRecordMapper)this.baseMapper).updateById((Object)entity);
        this.logger.info("\u4fee\u6539\u7b7e\u5b57\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)entity));
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"USE_RECORD", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "USE_RECORD");
                var7_7 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var7_7;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSupplierId(), (Object)entity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/equipmentUseRecord/deleteEquipmentUseRecord", RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl36
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var10_12 = supHandleResp;
                return var10_12;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl36:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "USE_RECORD");
        }
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        UseRecordEntity entity = (UseRecordEntity)((Object)super.selectById((Serializable)((Object)billId)));
        entity.setSupOperateTime(supOperateTime);
        entity.setSupOperatorName(supOperatorName);
        entity.setSupOperatorPhone(supOperatorPhone);
        entity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "BT220302000000003::" + entity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"USE_RECORD", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)entity.getId());
                this.releaseLock(jedis, false, key, "USE_RECORD");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, entity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            entity.setAttachIds(attchIdsList);
            entity.setNotSignature(true);
            super.saveOrUpdate((Object)entity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
            throw e;
        }
        finally {
            this.releaseLock(jedis, locked, key, "USE_RECORD");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

