package com.ejianc.business.ac.controller;

import java.io.Serializable;

import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.ac.service.IContractService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.ac.bean.FreezeEntity;
import com.ejianc.business.ac.service.IFreezeService;
import com.ejianc.business.ac.vo.FreezeVO;

/**
 * 安拆合同冻结实体表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("freeze")
public class FreezeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractService contractService;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFreezeService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FreezeVO> saveOrUpdate(@RequestBody FreezeVO saveorUpdateVO) {
        FreezeEntity entity = BeanMapper.map(saveorUpdateVO, FreezeEntity.class);
        if (entity.getId() == null) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
                //这里根据合同 id 去查询 是否存在 未生效的 冻结与解冻单
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("contractId",new Parameter(QueryParam.EQ,entity.getContractId()));
                queryParam.getParams().put("performanceStatus",new Parameter(QueryParam.EQ,entity.getPerformanceStatus()));
                List<Integer> list = new ArrayList<>();
                list.add(0);
                list.add(2);
                list.add(5);
                queryParam.getParams().put("billState",new Parameter(QueryParam.IN,list));
                List<FreezeEntity> freezeEntities = service.queryList(queryParam);
                if (!freezeEntities.isEmpty()){
                    throw new BusinessException("当前合同下有未生效的冻结/解冻 单不能再次发起冻结/解冻请求");
                }
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setBillState(0);
        service.saveOrUpdate(entity, false);
        FreezeVO vo = BeanMapper.map(entity, FreezeVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id 查询id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FreezeVO> queryDetail(Long id) {
        FreezeEntity entity = service.selectById(id);
        FreezeVO vo = BeanMapper.map(entity, FreezeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [vos] 删除id list
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FreezeVO> vos) {
        service.removeByIds(vos.stream().map(FreezeVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param 查询参数
     * @Description queryList 查询列表
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FreezeVO>> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("create_time", QueryParam.DESC);
        IPage<FreezeEntity> page = service.queryPage(param, false);
        IPage<FreezeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FreezeVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @Author
     * @Description  判断当前合同是否能新增冻结单
     */
    @RequestMapping(value = "/getContractPerformanceStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getContractPerformanceStatus(Long contractId) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        if (null != contractEntity && null != contractEntity.getPerformanceStatus()) {
            return CommonResponse.success("校验通过，该合同可以新增冻结单！", contractEntity.getPerformanceStatus());
        }
        return CommonResponse.error("校验失败，找不到合同或合同状态为空！");
    }
}
