package com.ejianc.business.ac.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型编码常量
 */
public enum BillTypeEnum {

    安拆结算("安拆结算", "EJCBT202204000007"),
    安拆合同主表("安拆合同主表", "EJCBT202204000008"),
    安拆合同变更("安拆合同变更", "EJCBT202204000010"),
    安拆冻结解冻("安拆冻结解冻", "EJCBT202204000011"),
    安拆合同解除("安拆合同解除", "EJCBT202204000013"),
    ;

    private final String name;
    private final String code;
    private static Map<String, BillTypeEnum> enumMap = new HashMap();

    private BillTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static BillTypeEnum getEnumByName(String billTypeName) {
        return (BillTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(BillTypeEnum.class).stream().collect(Collectors.toMap(BillTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
