package com.ejianc.business.process.service.impl;

import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.service.IAdjustDetailService;
import com.ejianc.business.process.vo.AdjustDetailVO;
import com.ejianc.business.process.vo.AdjustVO;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.process.mapper.AdjustMapper;
import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.service.IAdjustService;

import java.util.*;

/**
 * 分包价格调整与增补
 * 
 * @author generator
 * 
 */
@Service("adjustService")
public class AdjustServiceImpl extends BaseServiceImpl<AdjustMapper, AdjustEntity> implements IAdjustService{


    private static final String BILL_CODE = "EQUIPMENT_ADJUST_BILL_CODE";//此处需要根据实际修改

    @Autowired
    private IAdjustService service;
    @Autowired
    private IAdjustDetailService detailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public AdjustVO insertOrUpdate(AdjustVO saveOrUpdateVO) {
        AdjustEntity entity = BeanMapper.map(saveOrUpdateVO, AdjustEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getAdjustDetailList())){
            Set useTypeSet = new HashSet();
            List<AdjustDetailEntity> detailList = entity.getAdjustDetailList();
            for (AdjustDetailEntity detailEntity : detailList) {
                if(!"del".equals(detailEntity.getRowState()) && StringUtils.isNotBlank(detailEntity.getDetailUseTypeName())) {
                    useTypeSet.add(detailEntity.getDetailUseTypeName());
                }
            }
            if (CollectionUtils.isNotEmpty(useTypeSet)) {
                entity.setUseType(String.join(",", useTypeSet));
            }
        }

        service.saveOrUpdate(entity, false);
//        List<AdjustDetailEntity> detailList = entity.getAdjustDetailList();
//        if (CollectionUtils.isNotEmpty(detailList)) {
//            Map<String, Long> idMap = new HashMap<>();
//            for (AdjustDetailEntity cdEntity : detailList) {
//                idMap.put(cdEntity.getTid(), cdEntity.getId());
//            }
//            for (AdjustDetailEntity cdEntity : detailList) {
//                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
//                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
//                }
//            }
//            detailService.saveOrUpdateBatch(detailList);
//        }
        return BeanMapper.map(entity, AdjustVO.class);
    }

    @Override
    public AdjustVO queryDetail(Long id) {
        AdjustEntity entity = service.selectById(id);
        AdjustVO vo = BeanMapper.map(entity, AdjustVO.class);
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, id));
//        queryParam.getOrderMap().put("treeIndex", "asc");
//        List<AdjustDetailEntity> detailEntityListDb = detailService.queryList(queryParam, false);
//        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
//            for (AdjustDetailEntity cdEntity : detailEntityListDb) {
//                cdEntity.setTid(cdEntity.getId().toString());
//                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
//                cdEntity.setRowState("edit");
//            }
//            List<AdjustDetailVO> resultMapList = BeanMapper.mapList(detailEntityListDb, AdjustDetailVO.class);
//            sortIntMethod(resultMapList);
//            vo.setAdjustDetailList(TreeNodeBUtil.buildTree(resultMapList));
//
//        } else {
//            vo.setAdjustDetailList(BeanMapper.mapList(detailEntityListDb, AdjustDetailVO.class));
//        }
        return vo;
    }

    private static void sortIntMethod(List<AdjustDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                AdjustDetailVO o1Detail = objectMapper.convertValue(o1, AdjustDetailVO.class);
                AdjustDetailVO o2Detail = objectMapper.convertValue(o2, AdjustDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                String[] strs2 = o2Detail.getTreeIndex().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }


}
